/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.SingleParamMathTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;

public class TrigonometricTransformFunctions {

    public static class RadiansTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "radians";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.toRadians(values[i]);
            }
        }
    }

    public static class TanhTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "tanh";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.tanh(values[i]);
            }
        }
    }

    public static class SinTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "sin";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.sin(values[i]);
            }
        }
    }

    public static class CoshTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "cosh";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.cosh(values[i]);
            }
        }
    }

    public static class AsinTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "asin";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.asin(values[i]);
            }
        }
    }

    public static class CosTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "cos";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.cos(values[i]);
            }
        }
    }

    public static class AtanTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "atan";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.atan(values[i]);
            }
        }
    }

    public static class CotTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "cot";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = 1.0 / Math.tan(values[i]);
            }
        }
    }

    public static class SinhTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "sinh";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.sinh(values[i]);
            }
        }
    }

    public static class TanTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "tan";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.tan(values[i]);
            }
        }
    }

    public static class AcosTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "acos";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.acos(values[i]);
            }
        }
    }

    public static class DegreesTransformFunction
    extends SingleParamMathTransformFunction {
        public static final String FUNCTION_NAME = "degrees";

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        protected void applyMathOperator(double[] values, int length) {
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.toDegrees(values[i]);
            }
        }
    }

    public static class Atan2TransformFunction
    extends BaseTransformFunction {
        public static final String FUNCTION_NAME = "atan2";
        private TransformFunction _leftTransformFunction;
        private TransformFunction _rightTransformFunction;

        @Override
        public String getName() {
            return FUNCTION_NAME;
        }

        @Override
        public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
            if (arguments.size() != 2) {
                throw new IllegalArgumentException("Exactly 2 arguments are required for Atan2 transform function");
            }
            this._leftTransformFunction = arguments.get(0);
            this._rightTransformFunction = arguments.get(1);
            Preconditions.checkArgument((this._leftTransformFunction.getResultMetadata().isSingleValue() || this._rightTransformFunction.getResultMetadata().isSingleValue() ? 1 : 0) != 0, (String)"Argument must be single-valued for transform function: %s", (Object)this.getName());
        }

        @Override
        public TransformResultMetadata getResultMetadata() {
            return DOUBLE_SV_NO_DICTIONARY_METADATA;
        }

        @Override
        public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
            int length = projectionBlock.getNumDocs();
            if (this._doubleValuesSV == null || this._doubleValuesSV.length < length) {
                this._doubleValuesSV = new double[length];
            }
            double[] leftValues = this._leftTransformFunction.transformToDoubleValuesSV(projectionBlock);
            double[] rightValues = this._rightTransformFunction.transformToDoubleValuesSV(projectionBlock);
            for (int i = 0; i < length; ++i) {
                this._doubleValuesSV[i] = Math.atan2(leftValues[i], rightValues[i]);
            }
            return this._doubleValuesSV;
        }
    }
}

