/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.transform.function;

import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.BaseTransformFunction;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ArrayCopyUtils;

public class CastTransformFunction
extends BaseTransformFunction {
    public static final String FUNCTION_NAME = "cast";
    private TransformFunction _transformFunction;
    private FieldSpec.DataType _sourceDataType;
    private TransformResultMetadata _resultMetadata;

    @Override
    public String getName() {
        return FUNCTION_NAME;
    }

    @Override
    public void init(List<TransformFunction> arguments, Map<String, DataSource> dataSourceMap) {
        if (arguments.size() != 2) {
            throw new IllegalArgumentException("Exactly 2 arguments are required for CAST transform function");
        }
        this._transformFunction = arguments.get(0);
        TransformResultMetadata sourceMetadata = this._transformFunction.getResultMetadata();
        this._sourceDataType = sourceMetadata.getDataType();
        boolean sourceSV = sourceMetadata.isSingleValue();
        TransformFunction castFormatTransformFunction = arguments.get(1);
        if (castFormatTransformFunction instanceof LiteralTransformFunction) {
            String targetType;
            switch (targetType = ((LiteralTransformFunction)castFormatTransformFunction).getLiteral().toUpperCase()) {
                case "INT": 
                case "INTEGER": {
                    this._resultMetadata = sourceSV ? INT_SV_NO_DICTIONARY_METADATA : INT_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "LONG": {
                    this._resultMetadata = sourceSV ? LONG_SV_NO_DICTIONARY_METADATA : LONG_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "FLOAT": {
                    this._resultMetadata = sourceSV ? FLOAT_SV_NO_DICTIONARY_METADATA : FLOAT_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "DOUBLE": {
                    this._resultMetadata = sourceSV ? DOUBLE_SV_NO_DICTIONARY_METADATA : DOUBLE_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "DECIMAL": 
                case "BIGDECIMAL": 
                case "BIG_DECIMAL": {
                    Preconditions.checkState((boolean)sourceSV, (Object)"Cannot cast from MV to BIG_DECIMAL");
                    this._resultMetadata = BIG_DECIMAL_SV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "BOOL": 
                case "BOOLEAN": {
                    this._resultMetadata = sourceSV ? BOOLEAN_SV_NO_DICTIONARY_METADATA : BOOLEAN_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "TIMESTAMP": {
                    this._resultMetadata = sourceSV ? TIMESTAMP_SV_NO_DICTIONARY_METADATA : TIMESTAMP_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "STRING": 
                case "VARCHAR": {
                    this._resultMetadata = sourceSV ? STRING_SV_NO_DICTIONARY_METADATA : STRING_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                case "JSON": {
                    this._resultMetadata = sourceSV ? JSON_SV_NO_DICTIONARY_METADATA : JSON_MV_NO_DICTIONARY_METADATA;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unable to cast expression to type - " + targetType);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid cast to type - " + castFormatTransformFunction.getName());
        }
    }

    @Override
    public TransformResultMetadata getResultMetadata() {
        return this._resultMetadata;
    }

    @Override
    public int[] transformToIntValuesSV(ProjectionBlock projectionBlock) {
        switch (this._resultMetadata.getDataType()) {
            case INT: {
                return this._transformFunction.transformToIntValuesSV(projectionBlock);
            }
            case BOOLEAN: {
                return this.transformToBooleanValuesSV(projectionBlock);
            }
        }
        return super.transformToIntValuesSV(projectionBlock);
    }

    private int[] transformToBooleanValuesSV(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._intValuesSV == null) {
            this._intValuesSV = new int[length];
        }
        switch (this._sourceDataType.getStoredType()) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((int[])intValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((long[])longValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((float[])floatValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((double[])doubleValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((BigDecimal[])bigDecimalValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            case STRING: {
                String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((String[])stringValues, (int[])this._intValuesSV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot cast from SV %s to BOOLEAN", this._sourceDataType));
            }
        }
        return this._intValuesSV;
    }

    @Override
    public long[] transformToLongValuesSV(ProjectionBlock projectionBlock) {
        switch (this._resultMetadata.getDataType()) {
            case LONG: {
                return this._transformFunction.transformToLongValuesSV(projectionBlock);
            }
            case TIMESTAMP: {
                return this.transformToTimestampValuesSV(projectionBlock);
            }
        }
        return super.transformToLongValuesSV(projectionBlock);
    }

    private long[] transformToTimestampValuesSV(ProjectionBlock projectionBlock) {
        if (this._sourceDataType.getStoredType() == FieldSpec.DataType.STRING) {
            int length = projectionBlock.getNumDocs();
            if (this._longValuesSV == null) {
                this._longValuesSV = new long[length];
            }
            String[] stringValues = this._transformFunction.transformToStringValuesSV(projectionBlock);
            ArrayCopyUtils.copyToTimestamp((String[])stringValues, (long[])this._longValuesSV, (int)length);
            return this._longValuesSV;
        }
        return this._transformFunction.transformToLongValuesSV(projectionBlock);
    }

    @Override
    public float[] transformToFloatValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.FLOAT) {
            return this._transformFunction.transformToFloatValuesSV(projectionBlock);
        }
        return super.transformToFloatValuesSV(projectionBlock);
    }

    @Override
    public double[] transformToDoubleValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.DOUBLE) {
            return this._transformFunction.transformToDoubleValuesSV(projectionBlock);
        }
        return super.transformToDoubleValuesSV(projectionBlock);
    }

    @Override
    public BigDecimal[] transformToBigDecimalValuesSV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.BIG_DECIMAL) {
            return this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
        }
        return super.transformToBigDecimalValuesSV(projectionBlock);
    }

    @Override
    public String[] transformToStringValuesSV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultDataType = this._resultMetadata.getDataType();
        if (resultDataType.getStoredType() == FieldSpec.DataType.STRING) {
            switch (this._sourceDataType) {
                case BOOLEAN: {
                    int length = projectionBlock.getNumDocs();
                    if (this._stringValuesSV == null) {
                        this._stringValuesSV = new String[length];
                    }
                    int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                    ArrayCopyUtils.copyFromBoolean((int[])intValues, (String[])this._stringValuesSV, (int)length);
                    return this._stringValuesSV;
                }
                case TIMESTAMP: {
                    int length = projectionBlock.getNumDocs();
                    if (this._stringValuesSV == null) {
                        this._stringValuesSV = new String[length];
                    }
                    long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                    ArrayCopyUtils.copyFromTimestamp((long[])longValues, (String[])this._stringValuesSV, (int)length);
                    return this._stringValuesSV;
                }
            }
            return this._transformFunction.transformToStringValuesSV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesSV == null) {
            this._stringValuesSV = new String[length];
        }
        switch (resultDataType) {
            case INT: {
                int[] intValues = this._transformFunction.transformToIntValuesSV(projectionBlock);
                ArrayCopyUtils.copy((int[])intValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case LONG: {
                long[] longValues = this._transformFunction.transformToLongValuesSV(projectionBlock);
                ArrayCopyUtils.copy((long[])longValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case FLOAT: {
                float[] floatValues = this._transformFunction.transformToFloatValuesSV(projectionBlock);
                ArrayCopyUtils.copy((float[])floatValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case DOUBLE: {
                double[] doubleValues = this._transformFunction.transformToDoubleValuesSV(projectionBlock);
                ArrayCopyUtils.copy((double[])doubleValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = this._transformFunction.transformToBigDecimalValuesSV(projectionBlock);
                ArrayCopyUtils.copy((BigDecimal[])bigDecimalValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case BOOLEAN: {
                int[] intValues = this.transformToBooleanValuesSV(projectionBlock);
                ArrayCopyUtils.copyFromBoolean((int[])intValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case TIMESTAMP: {
                long[] longValues = this.transformToTimestampValuesSV(projectionBlock);
                ArrayCopyUtils.copyFromTimestamp((long[])longValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            case BYTES: {
                byte[][] bytesValues = this.transformToBytesValuesSV(projectionBlock);
                ArrayCopyUtils.copy((byte[][])bytesValues, (String[])this._stringValuesSV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot cast from SV %s to STRING", resultDataType));
            }
        }
        return this._stringValuesSV;
    }

    @Override
    public int[][] transformToIntValuesMV(ProjectionBlock projectionBlock) {
        switch (this._resultMetadata.getDataType()) {
            case INT: {
                return this._transformFunction.transformToIntValuesMV(projectionBlock);
            }
            case BOOLEAN: {
                return this.transformToBooleanValuesMV(projectionBlock);
            }
        }
        return super.transformToIntValuesMV(projectionBlock);
    }

    private int[][] transformToBooleanValuesMV(ProjectionBlock projectionBlock) {
        int length = projectionBlock.getNumDocs();
        if (this._intValuesMV == null) {
            this._intValuesMV = new int[length][];
        }
        switch (this._sourceDataType.getStoredType()) {
            case INT: {
                int[][] intValuesMV = this._transformFunction.transformToIntValuesMV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((int[][])intValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            case LONG: {
                long[][] longValuesMV = this._transformFunction.transformToLongValuesMV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((long[][])longValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            case FLOAT: {
                float[][] floatValuesMV = this._transformFunction.transformToFloatValuesMV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((float[][])floatValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            case DOUBLE: {
                double[][] doubleValuesMV = this._transformFunction.transformToDoubleValuesMV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((double[][])doubleValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            case STRING: {
                String[][] stringValuesMV = this._transformFunction.transformToStringValuesMV(projectionBlock);
                ArrayCopyUtils.copyToBoolean((String[][])stringValuesMV, (int[][])this._intValuesMV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot cast from MV %s to BOOLEAN", this._sourceDataType));
            }
        }
        return this._intValuesMV;
    }

    @Override
    public long[][] transformToLongValuesMV(ProjectionBlock projectionBlock) {
        switch (this._resultMetadata.getDataType()) {
            case LONG: {
                return this._transformFunction.transformToLongValuesMV(projectionBlock);
            }
            case TIMESTAMP: {
                return this.transformToTimestampValuesMV(projectionBlock);
            }
        }
        return super.transformToLongValuesMV(projectionBlock);
    }

    private long[][] transformToTimestampValuesMV(ProjectionBlock projectionBlock) {
        if (this._sourceDataType.getStoredType() == FieldSpec.DataType.STRING) {
            int length = projectionBlock.getNumDocs();
            if (this._longValuesMV == null) {
                this._longValuesMV = new long[length][];
            }
            String[][] stringValuesMV = this._transformFunction.transformToStringValuesMV(projectionBlock);
            ArrayCopyUtils.copyToTimestamp((String[][])stringValuesMV, (long[][])this._longValuesMV, (int)length);
            return this._longValuesMV;
        }
        return this._transformFunction.transformToLongValuesMV(projectionBlock);
    }

    @Override
    public float[][] transformToFloatValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.FLOAT) {
            return this._transformFunction.transformToFloatValuesMV(projectionBlock);
        }
        return super.transformToFloatValuesMV(projectionBlock);
    }

    @Override
    public double[][] transformToDoubleValuesMV(ProjectionBlock projectionBlock) {
        if (this._resultMetadata.getDataType().getStoredType() == FieldSpec.DataType.DOUBLE) {
            return this._transformFunction.transformToDoubleValuesMV(projectionBlock);
        }
        return super.transformToDoubleValuesMV(projectionBlock);
    }

    @Override
    public String[][] transformToStringValuesMV(ProjectionBlock projectionBlock) {
        FieldSpec.DataType resultDataType = this._resultMetadata.getDataType();
        if (resultDataType.getStoredType() == FieldSpec.DataType.STRING) {
            switch (this._sourceDataType) {
                case BOOLEAN: {
                    int length = projectionBlock.getNumDocs();
                    if (this._stringValuesMV == null) {
                        this._stringValuesMV = new String[length][];
                    }
                    int[][] intValuesMV = this._transformFunction.transformToIntValuesMV(projectionBlock);
                    ArrayCopyUtils.copyFromBoolean((int[][])intValuesMV, (String[][])this._stringValuesMV, (int)length);
                    return this._stringValuesMV;
                }
                case TIMESTAMP: {
                    int length = projectionBlock.getNumDocs();
                    if (this._stringValuesMV == null) {
                        this._stringValuesMV = new String[length][];
                    }
                    long[][] longValuesMV = this._transformFunction.transformToLongValuesMV(projectionBlock);
                    ArrayCopyUtils.copyFromTimestamp((long[][])longValuesMV, (String[][])this._stringValuesMV, (int)length);
                    return this._stringValuesMV;
                }
            }
            return this._transformFunction.transformToStringValuesMV(projectionBlock);
        }
        int length = projectionBlock.getNumDocs();
        if (this._stringValuesMV == null) {
            this._stringValuesMV = new String[length][];
        }
        switch (resultDataType) {
            case INT: {
                int[][] intValuesMV = this._transformFunction.transformToIntValuesMV(projectionBlock);
                ArrayCopyUtils.copy((int[][])intValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case LONG: {
                long[][] longValuesMV = this._transformFunction.transformToLongValuesMV(projectionBlock);
                ArrayCopyUtils.copy((long[][])longValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case FLOAT: {
                float[][] floatValuesMV = this._transformFunction.transformToFloatValuesMV(projectionBlock);
                ArrayCopyUtils.copy((float[][])floatValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case DOUBLE: {
                double[][] doubleValuesMV = this._transformFunction.transformToDoubleValuesMV(projectionBlock);
                ArrayCopyUtils.copy((double[][])doubleValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case BOOLEAN: {
                int[][] intValuesMV = this.transformToBooleanValuesMV(projectionBlock);
                ArrayCopyUtils.copyFromBoolean((int[][])intValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            case TIMESTAMP: {
                long[][] longValuesMV = this.transformToTimestampValuesMV(projectionBlock);
                ArrayCopyUtils.copyFromTimestamp((long[][])longValuesMV, (String[][])this._stringValuesMV, (int)length);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Cannot cast from MV %s to STRING", resultDataType));
            }
        }
        return this._stringValuesMV;
    }
}

