/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.streaming;

import io.grpc.stub.StreamObserver;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.operator.AcquireReleaseColumnsSegmentOperator;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.operator.blocks.results.ExceptionResultsBlock;
import org.apache.pinot.core.operator.blocks.results.MetadataResultsBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.combine.BaseCombineOperator;
import org.apache.pinot.core.operator.streaming.StreamingResponseUtils;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSelectionOnlyCombineOperator
extends BaseCombineOperator<SelectionResultsBlock> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingSelectionOnlyCombineOperator.class);
    private static final String EXPLAIN_NAME = "SELECT_STREAMING_COMBINE";
    private static final MetadataResultsBlock LAST_RESULTS_BLOCK = new MetadataResultsBlock();
    private final StreamObserver<Server.ServerResponse> _streamObserver;
    private final int _limit;
    private final AtomicLong _numRowsCollected = new AtomicLong();

    public StreamingSelectionOnlyCombineOperator(List<Operator> operators, QueryContext queryContext, ExecutorService executorService, StreamObserver<Server.ServerResponse> streamObserver) {
        super(operators, queryContext, executorService);
        this._streamObserver = streamObserver;
        this._limit = queryContext.getLimit();
    }

    @Override
    public String toExplainString() {
        return EXPLAIN_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processSegments() {
        int operatorId;
        while ((operatorId = this._nextOperatorId.getAndIncrement()) < this._numOperators) {
            Operator operator = (Operator)this._operators.get(operatorId);
            try {
                SelectionResultsBlock resultsBlock;
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).acquire();
                }
                while ((resultsBlock = (SelectionResultsBlock)operator.nextBlock()) != null) {
                    Collection<Object[]> rows = resultsBlock.getRows();
                    assert (rows != null);
                    long numRowsCollected = this._numRowsCollected.addAndGet(rows.size());
                    this._blockingQueue.offer(resultsBlock);
                    if (numRowsCollected < (long)this._limit) continue;
                    return;
                }
            }
            finally {
                if (operator instanceof AcquireReleaseColumnsSegmentOperator) {
                    ((AcquireReleaseColumnsSegmentOperator)operator).release();
                }
            }
            this._blockingQueue.offer(LAST_RESULTS_BLOCK);
        }
    }

    @Override
    protected BaseResultsBlock mergeResults() throws Exception {
        long numRowsCollected = 0L;
        int numOperatorsFinished = 0;
        long endTimeMs = this._queryContext.getEndTimeMs();
        while (numRowsCollected < (long)this._limit && numOperatorsFinished < this._numOperators) {
            BaseResultsBlock resultsBlock = (BaseResultsBlock)this._blockingQueue.poll(endTimeMs - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            if (resultsBlock == null) {
                LOGGER.error("Timed out while polling results block (query: {})", (Object)this._queryContext);
                return new ExceptionResultsBlock((Throwable)QueryException.getException((ProcessingException)QueryException.EXECUTION_TIMEOUT_ERROR, (Throwable)new TimeoutException("Timed out while polling results block")));
            }
            if (resultsBlock.getProcessingExceptions() != null) {
                return resultsBlock;
            }
            if (resultsBlock == LAST_RESULTS_BLOCK) {
                ++numOperatorsFinished;
                continue;
            }
            SelectionResultsBlock selectionResultsBlock = (SelectionResultsBlock)resultsBlock;
            DataSchema dataSchema = selectionResultsBlock.getDataSchema();
            Collection<Object[]> rows = selectionResultsBlock.getRows();
            assert (dataSchema != null && rows != null);
            numRowsCollected += (long)rows.size();
            DataTable dataTable = SelectionOperatorUtils.getDataTableFromRows(rows, dataSchema, this._queryContext.isNullHandlingEnabled());
            this._streamObserver.onNext((Object)StreamingResponseUtils.getDataResponse(dataTable));
        }
        return new MetadataResultsBlock();
    }

    @Override
    protected void mergeResultsBlocks(SelectionResultsBlock mergedBlock, SelectionResultsBlock blockToMerge) {
    }
}

