/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.Operator;
import org.apache.pinot.core.common.RowBasedBlockValueFetcher;
import org.apache.pinot.core.operator.BaseOperator;
import org.apache.pinot.core.operator.BitmapDocIdSetOperator;
import org.apache.pinot.core.operator.ExecutionStatistics;
import org.apache.pinot.core.operator.ProjectionOperator;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.operator.blocks.results.SelectionResultsBlock;
import org.apache.pinot.core.operator.transform.TransformOperator;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.selection.SelectionOperatorUtils;
import org.apache.pinot.core.query.utils.OrderByComparatorFactory;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.ImmutableBitmapDataProvider;
import org.roaringbitmap.RoaringBitmap;

public class SelectionOrderByOperator
extends BaseOperator<SelectionResultsBlock> {
    private static final String EXPLAIN_NAME = "SELECT_ORDERBY";
    private final IndexSegment _indexSegment;
    private final boolean _nullHandlingEnabled;
    private final List<ExpressionContext> _expressions;
    private final TransformOperator _transformOperator;
    private final List<OrderByExpressionContext> _orderByExpressions;
    private final TransformResultMetadata[] _orderByExpressionMetadata;
    private final int _numRowsToKeep;
    private final PriorityQueue<Object[]> _rows;
    private int _numDocsScanned = 0;
    private long _numEntriesScannedPostFilter = 0L;

    public SelectionOrderByOperator(IndexSegment indexSegment, QueryContext queryContext, List<ExpressionContext> expressions, TransformOperator transformOperator) {
        this._indexSegment = indexSegment;
        this._nullHandlingEnabled = queryContext.isNullHandlingEnabled();
        this._expressions = expressions;
        this._transformOperator = transformOperator;
        this._orderByExpressions = queryContext.getOrderByExpressions();
        assert (this._orderByExpressions != null);
        int numOrderByExpressions = this._orderByExpressions.size();
        this._orderByExpressionMetadata = new TransformResultMetadata[numOrderByExpressions];
        for (int i = 0; i < numOrderByExpressions; ++i) {
            ExpressionContext expression = this._orderByExpressions.get(i).getExpression();
            this._orderByExpressionMetadata[i] = this._transformOperator.getResultMetadata(expression);
        }
        this._numRowsToKeep = queryContext.getOffset() + queryContext.getLimit();
        Comparator<Object[]> comparator = OrderByComparatorFactory.getComparator(this._orderByExpressions, this._orderByExpressionMetadata, true, this._nullHandlingEnabled);
        this._rows = new PriorityQueue<Object[]>(Math.min(this._numRowsToKeep, 10000), comparator);
    }

    @Override
    public String toExplainString() {
        StringBuilder stringBuilder = new StringBuilder(EXPLAIN_NAME).append("(selectList:");
        if (!this._expressions.isEmpty()) {
            stringBuilder.append(this._expressions.get(0));
            for (int i = 1; i < this._expressions.size(); ++i) {
                stringBuilder.append(", ").append(this._expressions.get(i));
            }
        }
        return stringBuilder.append(')').toString();
    }

    @Override
    protected SelectionResultsBlock getNextBlock() {
        if (this._expressions.size() == this._orderByExpressions.size()) {
            return this.computeAllOrdered();
        }
        return this.computePartiallyOrdered();
    }

    private SelectionResultsBlock computeAllOrdered() {
        TransformBlock transformBlock;
        int numExpressions = this._expressions.size();
        BlockValSet[] blockValSets = new BlockValSet[numExpressions];
        int numColumnsProjected = this._transformOperator.getNumColumnsProjected();
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            for (int i = 0; i < numExpressions; ++i) {
                ExpressionContext expression = this._expressions.get(i);
                blockValSets[i] = transformBlock.getBlockValueSet(expression);
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            int numDocsFetched = transformBlock.getNumDocs();
            if (this._nullHandlingEnabled) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[numExpressions];
                for (int i = 0; i < numExpressions; ++i) {
                    nullBitmaps[i] = blockValSets[i].getNullBitmap();
                }
                for (int rowId = 0; rowId < numDocsFetched; ++rowId) {
                    Object[] row = blockValueFetcher.getRow(rowId);
                    for (int colId = 0; colId < numExpressions; ++colId) {
                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                        row[colId] = null;
                    }
                    SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                }
            } else {
                for (int i = 0; i < numDocsFetched; ++i) {
                    SelectionOperatorUtils.addToPriorityQueue(blockValueFetcher.getRow(i), this._rows, this._numRowsToKeep);
                }
            }
            this._numDocsScanned += numDocsFetched;
        }
        this._numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)numColumnsProjected;
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (int i = 0; i < numExpressions; ++i) {
            columnNames[i] = this._expressions.get(i).toString();
            TransformResultMetadata expressionMetadata = this._orderByExpressionMetadata[i];
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        DataSchema dataSchema = new DataSchema(columnNames, columnDataTypes);
        return new SelectionResultsBlock(dataSchema, this._rows);
    }

    private SelectionResultsBlock computePartiallyOrdered() {
        TransformResultMetadata expressionMetadata;
        int i;
        Object docIds;
        TransformBlock transformBlock;
        int numExpressions = this._expressions.size();
        int numOrderByExpressions = this._orderByExpressions.size();
        BlockValSet[] blockValSets = new BlockValSet[numOrderByExpressions];
        int numColumnsProjected = this._transformOperator.getNumColumnsProjected();
        while ((transformBlock = (TransformBlock)this._transformOperator.nextBlock()) != null) {
            for (int i2 = 0; i2 < numOrderByExpressions; ++i2) {
                ExpressionContext expression = this._orderByExpressions.get(i2).getExpression();
                blockValSets[i2] = transformBlock.getBlockValueSet(expression);
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            int numDocsFetched = transformBlock.getNumDocs();
            docIds = transformBlock.getDocIds();
            if (this._nullHandlingEnabled) {
                RoaringBitmap[] nullBitmaps = new RoaringBitmap[numOrderByExpressions];
                for (int i3 = 0; i3 < numOrderByExpressions; ++i3) {
                    nullBitmaps[i3] = blockValSets[i3].getNullBitmap();
                }
                for (int rowId = 0; rowId < numDocsFetched; ++rowId) {
                    Object[] row = new Object[numExpressions];
                    blockValueFetcher.getRow(rowId, row, 0);
                    row[numOrderByExpressions] = docIds[rowId];
                    for (int colId = 0; colId < numOrderByExpressions; ++colId) {
                        if (nullBitmaps[colId] == null || !nullBitmaps[colId].contains(rowId)) continue;
                        row[colId] = null;
                    }
                    SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                }
            } else {
                for (int i4 = 0; i4 < numDocsFetched; ++i4) {
                    Object[] row = new Object[numExpressions];
                    blockValueFetcher.getRow(i4, row, 0);
                    row[numOrderByExpressions] = docIds[i4];
                    SelectionOperatorUtils.addToPriorityQueue(row, this._rows, this._numRowsToKeep);
                }
            }
            this._numDocsScanned += numDocsFetched;
        }
        this._numEntriesScannedPostFilter = (long)this._numDocsScanned * (long)numColumnsProjected;
        int numRows = this._rows.size();
        ArrayList<Object[]> rowList = new ArrayList<Object[]>(numRows);
        docIds = new RoaringBitmap();
        for (Object[] row : this._rows) {
            rowList.add(row);
            int docId = (Integer)row[numOrderByExpressions];
            docIds.add(docId);
        }
        rowList.sort(Comparator.comparingInt(o -> (Integer)o[numOrderByExpressions]));
        List<ExpressionContext> nonOrderByExpressions = this._expressions.subList(numOrderByExpressions, numExpressions);
        HashSet columns = new HashSet();
        for (ExpressionContext expressionContext : nonOrderByExpressions) {
            expressionContext.getColumns(columns);
        }
        int numColumns = columns.size();
        HashMap<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
        for (String column : columns) {
            dataSourceMap.put(column, this._indexSegment.getDataSource(column));
        }
        ProjectionOperator projectionOperator = new ProjectionOperator(dataSourceMap, new BitmapDocIdSetOperator((ImmutableBitmapDataProvider)docIds, numRows));
        TransformOperator transformOperator = new TransformOperator(projectionOperator, nonOrderByExpressions);
        int numNonOrderByExpressions = nonOrderByExpressions.size();
        blockValSets = new BlockValSet[numNonOrderByExpressions];
        int rowBaseId = 0;
        while ((transformBlock = (TransformBlock)transformOperator.nextBlock()) != null) {
            for (int i5 = 0; i5 < numNonOrderByExpressions; ++i5) {
                ExpressionContext expression = nonOrderByExpressions.get(i5);
                blockValSets[i5] = transformBlock.getBlockValueSet(expression);
            }
            RowBasedBlockValueFetcher blockValueFetcher = new RowBasedBlockValueFetcher(blockValSets);
            int numDocsFetched = transformBlock.getNumDocs();
            for (i = 0; i < numDocsFetched; ++i) {
                blockValueFetcher.getRow(i, (Object[])rowList.get(rowBaseId + i), numOrderByExpressions);
            }
            this._numEntriesScannedPostFilter += (long)numDocsFetched * (long)numColumns;
            rowBaseId += numDocsFetched;
        }
        String[] columnNames = new String[numExpressions];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numExpressions];
        for (i = 0; i < numExpressions; ++i) {
            columnNames[i] = this._expressions.get(i).toString();
        }
        for (i = 0; i < numOrderByExpressions; ++i) {
            expressionMetadata = this._orderByExpressionMetadata[i];
            columnDataTypes[i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        for (i = 0; i < numNonOrderByExpressions; ++i) {
            expressionMetadata = transformOperator.getResultMetadata(nonOrderByExpressions.get(i));
            columnDataTypes[numOrderByExpressions + i] = DataSchema.ColumnDataType.fromDataType((FieldSpec.DataType)expressionMetadata.getDataType(), (boolean)expressionMetadata.isSingleValue());
        }
        DataSchema dataSchema = new DataSchema(columnNames, columnDataTypes);
        return new SelectionResultsBlock(dataSchema, this._rows);
    }

    @Override
    public List<Operator> getChildOperators() {
        return Collections.singletonList(this._transformOperator);
    }

    @Override
    public IndexSegment getIndexSegment() {
        return this._indexSegment;
    }

    @Override
    public ExecutionStatistics getExecutionStatistics() {
        long numEntriesScannedInFilter = this._transformOperator.getExecutionStatistics().getNumEntriesScannedInFilter();
        int numTotalDocs = this._indexSegment.getSegmentMetadata().getTotalDocs();
        return new ExecutionStatistics(this._numDocsScanned, numEntriesScannedInFilter, this._numEntriesScannedPostFilter, numTotalDocs);
    }
}

