/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.filter.predicate;

import it.unimi.dsi.fastutil.doubles.DoubleOpenHashSet;
import it.unimi.dsi.fastutil.doubles.DoubleSet;
import it.unimi.dsi.fastutil.floats.FloatOpenHashSet;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pinot.common.request.context.predicate.BaseInPredicate;
import org.apache.pinot.common.request.context.predicate.NotInPredicate;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.common.utils.HashUtil;
import org.apache.pinot.core.operator.filter.predicate.BaseDictionaryBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.BaseRawValueBasedPredicateEvaluator;
import org.apache.pinot.core.operator.filter.predicate.PredicateUtils;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.ByteArray;

public class NotInPredicateEvaluatorFactory {
    private NotInPredicateEvaluatorFactory() {
    }

    public static BaseDictionaryBasedPredicateEvaluator newDictionaryBasedEvaluator(NotInPredicate notInPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
        return new DictionaryBasedNotInPredicateEvaluator(notInPredicate, dictionary, dataType);
    }

    public static BaseRawValueBasedPredicateEvaluator newRawValueBasedEvaluator(NotInPredicate notInPredicate, FieldSpec.DataType dataType) {
        switch (dataType) {
            case INT: {
                int[] intValues = notInPredicate.getIntValues();
                IntOpenHashSet nonMatchingValues = new IntOpenHashSet(HashUtil.getMinHashSetSize((int)intValues.length));
                for (int value : intValues) {
                    nonMatchingValues.add(value);
                }
                return new IntRawValueBasedNotInPredicateEvaluator(notInPredicate, (IntSet)nonMatchingValues);
            }
            case LONG: {
                long[] longValues = notInPredicate.getLongValues();
                LongOpenHashSet nonMatchingValues = new LongOpenHashSet(HashUtil.getMinHashSetSize((int)longValues.length));
                for (long value : longValues) {
                    nonMatchingValues.add(value);
                }
                return new LongRawValueBasedNotInPredicateEvaluator(notInPredicate, (LongSet)nonMatchingValues);
            }
            case FLOAT: {
                float[] floatValues = notInPredicate.getFloatValues();
                FloatOpenHashSet nonMatchingValues = new FloatOpenHashSet(HashUtil.getMinHashSetSize((int)floatValues.length));
                for (float value : floatValues) {
                    nonMatchingValues.add(value);
                }
                return new FloatRawValueBasedNotInPredicateEvaluator(notInPredicate, (FloatSet)nonMatchingValues);
            }
            case DOUBLE: {
                double[] doubleValues = notInPredicate.getDoubleValues();
                DoubleOpenHashSet nonMatchingValues = new DoubleOpenHashSet(HashUtil.getMinHashSetSize((int)doubleValues.length));
                for (double value : doubleValues) {
                    nonMatchingValues.add(value);
                }
                return new DoubleRawValueBasedNotInPredicateEvaluator(notInPredicate, (DoubleSet)nonMatchingValues);
            }
            case BIG_DECIMAL: {
                BigDecimal[] bigDecimalValues = notInPredicate.getBigDecimalValues();
                TreeSet<BigDecimal> nonMatchingValues = new TreeSet<BigDecimal>(Arrays.asList(bigDecimalValues));
                return new BigDecimalRawValueBasedNotInPredicateEvaluator(notInPredicate, nonMatchingValues);
            }
            case BOOLEAN: {
                int[] booleanValues = notInPredicate.getBooleanValues();
                IntOpenHashSet nonMatchingValues = new IntOpenHashSet(HashUtil.getMinHashSetSize((int)booleanValues.length));
                for (int value : booleanValues) {
                    nonMatchingValues.add(value);
                }
                return new IntRawValueBasedNotInPredicateEvaluator(notInPredicate, (IntSet)nonMatchingValues);
            }
            case TIMESTAMP: {
                long[] timestampValues = notInPredicate.getTimestampValues();
                LongOpenHashSet nonMatchingValues = new LongOpenHashSet(HashUtil.getMinHashSetSize((int)timestampValues.length));
                for (long value : timestampValues) {
                    nonMatchingValues.add(value);
                }
                return new LongRawValueBasedNotInPredicateEvaluator(notInPredicate, (LongSet)nonMatchingValues);
            }
            case STRING: {
                List stringValues = notInPredicate.getValues();
                ObjectOpenHashSet nonMatchingValues = new ObjectOpenHashSet(HashUtil.getMinHashSetSize((int)stringValues.size()));
                for (String value : stringValues) {
                    nonMatchingValues.add(value);
                }
                return new StringRawValueBasedNotInPredicateEvaluator(notInPredicate, (Set<String>)nonMatchingValues);
            }
            case BYTES: {
                ByteArray[] bytesValues = notInPredicate.getBytesValues();
                ObjectOpenHashSet nonMatchingValues = new ObjectOpenHashSet(HashUtil.getMinHashSetSize((int)bytesValues.length));
                for (ByteArray value : bytesValues) {
                    nonMatchingValues.add(value);
                }
                return new BytesRawValueBasedNotInPredicateEvaluator(notInPredicate, (Set<ByteArray>)nonMatchingValues);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType);
    }

    private static final class BytesRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<ByteArray> _nonMatchingValues;

        BytesRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, Set<ByteArray> nonMatchingValues) {
            super((Predicate)notInPredicate);
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return -this._nonMatchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BYTES;
        }

        @Override
        public boolean applySV(byte[] value) {
            return !this._nonMatchingValues.contains(new ByteArray(value));
        }
    }

    private static final class StringRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final Set<String> _nonMatchingValues;

        StringRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, Set<String> nonMatchingValues) {
            super((Predicate)notInPredicate);
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return -this._nonMatchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.STRING;
        }

        @Override
        public boolean applySV(String value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class BigDecimalRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final TreeSet<BigDecimal> _nonMatchingValues;

        BigDecimalRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, TreeSet<BigDecimal> nonMatchingValues) {
            super((Predicate)notInPredicate);
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return -this._nonMatchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.BIG_DECIMAL;
        }

        @Override
        public boolean applySV(BigDecimal value) {
            return !this._nonMatchingValues.contains(value);
        }
    }

    private static final class DoubleRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final DoubleSet _nonMatchingValues;

        DoubleRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, DoubleSet nonMatchingValues) {
            super((Predicate)notInPredicate);
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return -this._nonMatchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.DOUBLE;
        }

        @Override
        public boolean applySV(double value) {
            return !this._nonMatchingValues.contains(value);
        }

        @Override
        public int applySV(int limit, int[] docIds, double[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                double value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class FloatRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final FloatSet _nonMatchingValues;

        FloatRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, FloatSet nonMatchingValues) {
            super((Predicate)notInPredicate);
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return -this._nonMatchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.FLOAT;
        }

        @Override
        public boolean applySV(float value) {
            return !this._nonMatchingValues.contains(value);
        }

        @Override
        public int applySV(int limit, int[] docIds, float[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                float value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class LongRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final LongSet _nonMatchingValues;

        LongRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, LongSet nonMatchingValues) {
            super((Predicate)notInPredicate);
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return -this._nonMatchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.LONG;
        }

        @Override
        public boolean applySV(long value) {
            return !this._nonMatchingValues.contains(value);
        }

        @Override
        public int applySV(int limit, int[] docIds, long[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                long value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    private static final class IntRawValueBasedNotInPredicateEvaluator
    extends BaseRawValueBasedPredicateEvaluator {
        final IntSet _nonMatchingValues;

        IntRawValueBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, IntSet nonMatchingValues) {
            super((Predicate)notInPredicate);
            this._nonMatchingValues = nonMatchingValues;
        }

        @Override
        public int getNumMatchingItems() {
            return -this._nonMatchingValues.size();
        }

        @Override
        public FieldSpec.DataType getDataType() {
            return FieldSpec.DataType.INT;
        }

        @Override
        public boolean applySV(int value) {
            return !this._nonMatchingValues.contains(value);
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }
    }

    public static final class DictionaryBasedNotInPredicateEvaluator
    extends BaseDictionaryBasedPredicateEvaluator {
        final IntSet _nonMatchingDictIdSet;
        final int _numNonMatchingDictIds;
        final Dictionary _dictionary;
        int[] _matchingDictIds;
        int[] _nonMatchingDictIds;

        DictionaryBasedNotInPredicateEvaluator(NotInPredicate notInPredicate, Dictionary dictionary, FieldSpec.DataType dataType) {
            super((Predicate)notInPredicate);
            this._nonMatchingDictIdSet = PredicateUtils.getDictIdSet((BaseInPredicate)notInPredicate, dictionary, dataType);
            this._numNonMatchingDictIds = this._nonMatchingDictIdSet.size();
            if (this._numNonMatchingDictIds == 0) {
                this._alwaysTrue = true;
            } else if (dictionary.length() == this._numNonMatchingDictIds) {
                this._alwaysFalse = true;
            }
            this._dictionary = dictionary;
        }

        @Override
        public int getNumMatchingItems() {
            return -this._numNonMatchingDictIds;
        }

        @Override
        public boolean applySV(int dictId) {
            return !this._nonMatchingDictIdSet.contains(dictId);
        }

        @Override
        public int applySV(int limit, int[] docIds, int[] values) {
            int matches = 0;
            for (int i = 0; i < limit; ++i) {
                int value = values[i];
                if (!this.applySV(value)) continue;
                docIds[matches++] = docIds[i];
            }
            return matches;
        }

        @Override
        public int[] getMatchingDictIds() {
            if (this._matchingDictIds == null) {
                int dictionarySize = this._dictionary.length();
                this._matchingDictIds = new int[dictionarySize - this._numNonMatchingDictIds];
                int index = 0;
                for (int dictId = 0; dictId < dictionarySize; ++dictId) {
                    if (this._nonMatchingDictIdSet.contains(dictId)) continue;
                    this._matchingDictIds[index++] = dictId;
                }
            }
            return this._matchingDictIds;
        }

        @Override
        public int getNumNonMatchingDictIds() {
            return this._numNonMatchingDictIds;
        }

        @Override
        public int[] getNonMatchingDictIds() {
            if (this._nonMatchingDictIds == null) {
                this._nonMatchingDictIds = this._nonMatchingDictIdSet.toIntArray();
            }
            return this._nonMatchingDictIds;
        }
    }
}

