/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.docvalsets;

import java.math.BigDecimal;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.ProjectionBlock;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.TransformFunction;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.trace.InvocationRecording;
import org.apache.pinot.spi.trace.InvocationScope;
import org.apache.pinot.spi.trace.Tracing;
import org.roaringbitmap.RoaringBitmap;

public class TransformBlockValSet
implements BlockValSet {
    private final ProjectionBlock _projectionBlock;
    private final TransformFunction _transformFunction;
    private final ExpressionContext _expression;
    private boolean _nullBitmapSet;
    private RoaringBitmap _nullBitmap;
    private int[] _numMVEntries;

    public TransformBlockValSet(ProjectionBlock projectionBlock, TransformFunction transformFunction, ExpressionContext expression) {
        this._projectionBlock = projectionBlock;
        this._transformFunction = transformFunction;
        this._expression = expression;
    }

    @Override
    @Nullable
    public RoaringBitmap getNullBitmap() {
        if (!this._nullBitmapSet) {
            RoaringBitmap nullBitmap = null;
            if (this._expression.getType() == ExpressionContext.Type.FUNCTION) {
                HashSet columns = new HashSet();
                this._expression.getFunction().getColumns(columns);
                for (String column : columns) {
                    BlockValSet blockValSet = this._projectionBlock.getBlockValueSet(column);
                    RoaringBitmap columnNullBitmap = blockValSet.getNullBitmap();
                    if (columnNullBitmap == null) continue;
                    if (nullBitmap == null) {
                        nullBitmap = columnNullBitmap.clone();
                    }
                    nullBitmap.or(columnNullBitmap);
                }
            }
            this._nullBitmap = nullBitmap;
            this._nullBitmapSet = true;
        }
        return this._nullBitmap;
    }

    @Override
    public FieldSpec.DataType getValueType() {
        return this._transformFunction.getResultMetadata().getDataType();
    }

    @Override
    public boolean isSingleValue() {
        return this._transformFunction.getResultMetadata().isSingleValue();
    }

    @Override
    @Nullable
    public Dictionary getDictionary() {
        return this._transformFunction.getDictionary();
    }

    @Override
    public int[] getDictionaryIdsSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.INT, true);
            int[] nArray = this._transformFunction.transformToDictIdsSV(this._projectionBlock);
            return nArray;
        }
    }

    @Override
    public int[] getIntValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.INT, true);
            int[] nArray = this._transformFunction.transformToIntValuesSV(this._projectionBlock);
            return nArray;
        }
    }

    @Override
    public long[] getLongValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.LONG, true);
            long[] lArray = this._transformFunction.transformToLongValuesSV(this._projectionBlock);
            return lArray;
        }
    }

    @Override
    public float[] getFloatValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.FLOAT, true);
            float[] fArray = this._transformFunction.transformToFloatValuesSV(this._projectionBlock);
            return fArray;
        }
    }

    @Override
    public double[] getDoubleValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.DOUBLE, true);
            double[] dArray = this._transformFunction.transformToDoubleValuesSV(this._projectionBlock);
            return dArray;
        }
    }

    @Override
    public BigDecimal[] getBigDecimalValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.BIG_DECIMAL, true);
            BigDecimal[] bigDecimalArray = this._transformFunction.transformToBigDecimalValuesSV(this._projectionBlock);
            return bigDecimalArray;
        }
    }

    @Override
    public String[] getStringValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.STRING, true);
            String[] stringArray = this._transformFunction.transformToStringValuesSV(this._projectionBlock);
            return stringArray;
        }
    }

    @Override
    public byte[][] getBytesValuesSV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.BYTES, true);
            byte[][] byArray = this._transformFunction.transformToBytesValuesSV(this._projectionBlock);
            return byArray;
        }
    }

    @Override
    public int[][] getDictionaryIdsMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.INT, false);
            int[][] nArray = this._transformFunction.transformToDictIdsMV(this._projectionBlock);
            return nArray;
        }
    }

    @Override
    public int[][] getIntValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.INT, false);
            int[][] nArray = this._transformFunction.transformToIntValuesMV(this._projectionBlock);
            return nArray;
        }
    }

    @Override
    public long[][] getLongValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.LONG, false);
            long[][] lArray = this._transformFunction.transformToLongValuesMV(this._projectionBlock);
            return lArray;
        }
    }

    @Override
    public float[][] getFloatValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.FLOAT, false);
            float[][] fArray = this._transformFunction.transformToFloatValuesMV(this._projectionBlock);
            return fArray;
        }
    }

    @Override
    public double[][] getDoubleValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.DOUBLE, false);
            double[][] dArray = this._transformFunction.transformToDoubleValuesMV(this._projectionBlock);
            return dArray;
        }
    }

    @Override
    public String[][] getStringValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.STRING, false);
            String[][] stringArray = this._transformFunction.transformToStringValuesMV(this._projectionBlock);
            return stringArray;
        }
    }

    @Override
    public byte[][][] getBytesValuesMV() {
        try (InvocationScope scope = Tracing.getTracer().createScope(TransformBlockValSet.class);){
            this.recordTransformValues((InvocationRecording)scope, FieldSpec.DataType.BYTES, false);
            byte[][][] byArray = this._transformFunction.transformToBytesValuesMV(this._projectionBlock);
            return byArray;
        }
    }

    @Override
    public int[] getNumMVEntries() {
        if (this._numMVEntries == null) {
            this._numMVEntries = new int[10000];
        }
        int numDocs = this._projectionBlock.getNumDocs();
        TransformResultMetadata resultMetadata = this._transformFunction.getResultMetadata();
        if (resultMetadata.hasDictionary()) {
            int[][] dictionaryIds = this.getDictionaryIdsMV();
            for (int i = 0; i < numDocs; ++i) {
                this._numMVEntries[i] = dictionaryIds[i].length;
            }
            return this._numMVEntries;
        }
        switch (resultMetadata.getDataType().getStoredType()) {
            case INT: {
                int[][] intValues = this.getIntValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = intValues[i].length;
                }
                return this._numMVEntries;
            }
            case LONG: {
                long[][] longValues = this.getLongValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = longValues[i].length;
                }
                return this._numMVEntries;
            }
            case FLOAT: {
                float[][] floatValues = this.getFloatValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = floatValues[i].length;
                }
                return this._numMVEntries;
            }
            case DOUBLE: {
                double[][] doubleValues = this.getDoubleValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = doubleValues[i].length;
                }
                return this._numMVEntries;
            }
            case STRING: {
                String[][] stringValues = this.getStringValuesMV();
                for (int i = 0; i < numDocs; ++i) {
                    this._numMVEntries[i] = stringValues[i].length;
                }
                return this._numMVEntries;
            }
        }
        throw new IllegalStateException();
    }

    private void recordTransformValues(InvocationRecording recording, FieldSpec.DataType dataType, boolean singleValue) {
        if (recording.isEnabled()) {
            int numDocs = this._projectionBlock.getNumDocs();
            recording.setNumDocsScanned(numDocs);
            recording.setFunctionName(this._transformFunction.getName());
            recording.setOutputDataType(dataType, singleValue);
        }
    }
}

