/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.data.table.IntermediateRecord;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.core.data.table.Table;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.aggregation.groupby.AggregationGroupByResult;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class GroupByResultsBlock
extends BaseResultsBlock {
    private final DataSchema _dataSchema;
    private final AggregationGroupByResult _aggregationGroupByResult;
    private final Collection<IntermediateRecord> _intermediateRecords;
    private final Table _table;
    private boolean _numGroupsLimitReached;
    private int _numResizes;
    private long _resizeTimeMs;

    public GroupByResultsBlock(DataSchema dataSchema, AggregationGroupByResult aggregationGroupByResult) {
        this._dataSchema = dataSchema;
        this._aggregationGroupByResult = aggregationGroupByResult;
        this._intermediateRecords = null;
        this._table = null;
    }

    public GroupByResultsBlock(DataSchema dataSchema, Collection<IntermediateRecord> intermediateRecords) {
        this._dataSchema = dataSchema;
        this._aggregationGroupByResult = null;
        this._intermediateRecords = intermediateRecords;
        this._table = null;
    }

    public GroupByResultsBlock(Table table) {
        this._dataSchema = table.getDataSchema();
        this._aggregationGroupByResult = null;
        this._intermediateRecords = null;
        this._table = table;
    }

    public GroupByResultsBlock(DataSchema dataSchema) {
        this._dataSchema = dataSchema;
        this._aggregationGroupByResult = null;
        this._intermediateRecords = null;
        this._table = null;
    }

    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public AggregationGroupByResult getAggregationGroupByResult() {
        return this._aggregationGroupByResult;
    }

    public Collection<IntermediateRecord> getIntermediateRecords() {
        return this._intermediateRecords;
    }

    public Table getTable() {
        return this._table;
    }

    public boolean isNumGroupsLimitReached() {
        return this._numGroupsLimitReached;
    }

    public void setNumGroupsLimitReached(boolean numGroupsLimitReached) {
        this._numGroupsLimitReached = numGroupsLimitReached;
    }

    public int getNumResizes() {
        return this._numResizes;
    }

    public void setNumResizes(int numResizes) {
        this._numResizes = numResizes;
    }

    public long getResizeTimeMs() {
        return this._resizeTimeMs;
    }

    public void setResizeTimeMs(long resizeTimeMs) {
        this._resizeTimeMs = resizeTimeMs;
    }

    @Override
    public int getNumRows() {
        return this._table == null ? 0 : this._table.size();
    }

    @Override
    @Nullable
    public DataSchema getDataSchema(QueryContext queryContext) {
        return this._dataSchema;
    }

    @Override
    @Nullable
    public Collection<Object[]> getRows(QueryContext queryContext) {
        if (this._table == null) {
            return Collections.emptyList();
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(this._table.size());
        Iterator<Record> iterator = this._table.iterator();
        while (iterator.hasNext()) {
            rows.add(iterator.next().getValues());
        }
        return rows;
    }

    @Override
    public DataTable getDataTable(QueryContext queryContext) throws IOException {
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(this._dataSchema);
        if (this._table == null) {
            return dataTableBuilder.build();
        }
        DataSchema.ColumnDataType[] storedColumnDataTypes = this._dataSchema.getStoredColumnDataTypes();
        int numColumns = this._dataSchema.size();
        Iterator<Record> iterator = this._table.iterator();
        if (queryContext.isNullHandlingEnabled()) {
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
            Object[] nullPlaceholders = new Object[numColumns];
            for (int colId = 0; colId < numColumns; ++colId) {
                nullBitmaps[colId] = new RoaringBitmap();
                nullPlaceholders[colId] = storedColumnDataTypes[colId].getNullPlaceholder();
            }
            int rowId = 0;
            while (iterator.hasNext()) {
                dataTableBuilder.startRow();
                Object[] values = iterator.next().getValues();
                for (int colId = 0; colId < numColumns; ++colId) {
                    Object value = values[colId];
                    if (value == null && storedColumnDataTypes[colId] != DataSchema.ColumnDataType.OBJECT) {
                        value = nullPlaceholders[colId];
                        nullBitmaps[colId].add(rowId);
                    }
                    this.setDataTableColumn(storedColumnDataTypes[colId], dataTableBuilder, colId, value);
                }
                dataTableBuilder.finishRow();
                ++rowId;
            }
            for (RoaringBitmap nullBitmap : nullBitmaps) {
                dataTableBuilder.setNullRowIds(nullBitmap);
            }
        } else {
            while (iterator.hasNext()) {
                dataTableBuilder.startRow();
                Object[] values = iterator.next().getValues();
                for (int colId = 0; colId < numColumns; ++colId) {
                    this.setDataTableColumn(storedColumnDataTypes[colId], dataTableBuilder, colId, values[colId]);
                }
                dataTableBuilder.finishRow();
            }
        }
        return dataTableBuilder.build();
    }

    private void setDataTableColumn(DataSchema.ColumnDataType storedColumnDataType, DataTableBuilder dataTableBuilder, int columnIndex, Object value) throws IOException {
        switch (storedColumnDataType) {
            case INT: {
                dataTableBuilder.setColumn(columnIndex, (Integer)value);
                break;
            }
            case LONG: {
                dataTableBuilder.setColumn(columnIndex, (Long)value);
                break;
            }
            case FLOAT: {
                dataTableBuilder.setColumn(columnIndex, ((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                dataTableBuilder.setColumn(columnIndex, (Double)value);
                break;
            }
            case BIG_DECIMAL: {
                dataTableBuilder.setColumn(columnIndex, (BigDecimal)value);
                break;
            }
            case STRING: {
                dataTableBuilder.setColumn(columnIndex, value.toString());
                break;
            }
            case BYTES: {
                dataTableBuilder.setColumn(columnIndex, (ByteArray)value);
                break;
            }
            case INT_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (int[])value);
                break;
            }
            case LONG_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (long[])value);
                break;
            }
            case FLOAT_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (float[])value);
                break;
            }
            case DOUBLE_ARRAY: {
                if (value instanceof DoubleArrayList) {
                    dataTableBuilder.setColumn(columnIndex, ((DoubleArrayList)value).elements());
                    break;
                }
                dataTableBuilder.setColumn(columnIndex, (double[])value);
                break;
            }
            case STRING_ARRAY: {
                dataTableBuilder.setColumn(columnIndex, (String[])value);
                break;
            }
            case OBJECT: {
                dataTableBuilder.setColumn(columnIndex, value);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported stored type: " + storedColumnDataType);
            }
        }
    }

    @Override
    public Map<String, String> getResultsMetadata() {
        Map<String, String> metadata = super.getResultsMetadata();
        if (this._numGroupsLimitReached) {
            metadata.put(DataTable.MetadataKey.NUM_GROUPS_LIMIT_REACHED.getName(), "true");
        }
        metadata.put(DataTable.MetadataKey.NUM_RESIZES.getName(), Integer.toString(this._numResizes));
        metadata.put(DataTable.MetadataKey.RESIZE_TIME_MS.getName(), Long.toString(this._resizeTimeMs));
        return metadata;
    }
}

