/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.operator.blocks.results;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.operator.blocks.results.BaseResultsBlock;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.RoaringBitmap;

public class AggregationResultsBlock
extends BaseResultsBlock {
    private final AggregationFunction[] _aggregationFunctions;
    private final List<Object> _results;

    public AggregationResultsBlock(AggregationFunction[] aggregationFunctions, List<Object> results) {
        this._aggregationFunctions = aggregationFunctions;
        this._results = results;
    }

    public AggregationFunction[] getAggregationFunctions() {
        return this._aggregationFunctions;
    }

    public List<Object> getResults() {
        return this._results;
    }

    @Override
    public int getNumRows() {
        return 1;
    }

    @Override
    public DataSchema getDataSchema(QueryContext queryContext) {
        boolean returnFinalResult = queryContext.isServerReturnFinalResult();
        int numColumns = this._aggregationFunctions.length;
        String[] columnNames = new String[numColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numColumns];
        for (int i = 0; i < numColumns; ++i) {
            AggregationFunction aggregationFunction = this._aggregationFunctions[i];
            columnNames[i] = aggregationFunction.getColumnName();
            columnDataTypes[i] = returnFinalResult ? aggregationFunction.getFinalResultColumnType() : aggregationFunction.getIntermediateResultColumnType();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    @Override
    public Collection<Object[]> getRows(QueryContext queryContext) {
        return Collections.singletonList(this._results.toArray());
    }

    @Override
    public DataTable getDataTable(QueryContext queryContext) throws IOException {
        boolean returnFinalResult = queryContext.isServerReturnFinalResult();
        DataSchema dataSchema = this.getDataSchema(queryContext);
        assert (dataSchema != null);
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(dataSchema);
        if (queryContext.isNullHandlingEnabled()) {
            int i;
            RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
            for (i = 0; i < numColumns; ++i) {
                nullBitmaps[i] = new RoaringBitmap();
            }
            dataTableBuilder.startRow();
            for (i = 0; i < numColumns; ++i) {
                Object result = this._results.get(i);
                if (result == null) {
                    result = columnDataTypes[i].getNullPlaceholder();
                    nullBitmaps[i].add(0);
                }
                if (!returnFinalResult) {
                    this.setIntermediateResult(dataTableBuilder, columnDataTypes, i, result);
                    continue;
                }
                this.setFinalResult(dataTableBuilder, columnDataTypes, i, result);
            }
            dataTableBuilder.finishRow();
            for (RoaringBitmap nullBitmap : nullBitmaps) {
                dataTableBuilder.setNullRowIds(nullBitmap);
            }
        } else {
            dataTableBuilder.startRow();
            for (int i = 0; i < numColumns; ++i) {
                Object result = this._results.get(i);
                if (!returnFinalResult) {
                    this.setIntermediateResult(dataTableBuilder, columnDataTypes, i, result);
                    continue;
                }
                result = this._aggregationFunctions[i].extractFinalResult(result);
                this.setFinalResult(dataTableBuilder, columnDataTypes, i, result);
            }
            dataTableBuilder.finishRow();
        }
        return dataTableBuilder.build();
    }

    private void setIntermediateResult(DataTableBuilder dataTableBuilder, DataSchema.ColumnDataType[] columnDataTypes, int index, Object result) throws IOException {
        DataSchema.ColumnDataType columnDataType = columnDataTypes[index];
        switch (columnDataType) {
            case LONG: {
                dataTableBuilder.setColumn(index, (Long)result);
                break;
            }
            case DOUBLE: {
                dataTableBuilder.setColumn(index, (Double)result);
                break;
            }
            case OBJECT: {
                dataTableBuilder.setColumn(index, result);
                break;
            }
            default: {
                throw new IllegalStateException("Illegal column data type in intermediate result: " + columnDataType);
            }
        }
    }

    private void setFinalResult(DataTableBuilder dataTableBuilder, DataSchema.ColumnDataType[] columnDataTypes, int index, Object result) throws IOException {
        DataSchema.ColumnDataType columnDataType = columnDataTypes[index];
        switch (columnDataType) {
            case INT: {
                dataTableBuilder.setColumn(index, (Integer)result);
                break;
            }
            case LONG: {
                dataTableBuilder.setColumn(index, (Long)result);
                break;
            }
            case FLOAT: {
                dataTableBuilder.setColumn(index, ((Float)result).floatValue());
                break;
            }
            case DOUBLE: {
                dataTableBuilder.setColumn(index, (Double)result);
                break;
            }
            case BIG_DECIMAL: {
                dataTableBuilder.setColumn(index, (BigDecimal)result);
                break;
            }
            case STRING: {
                dataTableBuilder.setColumn(index, result.toString());
                break;
            }
            case BYTES: {
                dataTableBuilder.setColumn(index, (ByteArray)result);
                break;
            }
            case DOUBLE_ARRAY: {
                dataTableBuilder.setColumn(index, ((DoubleArrayList)result).elements());
                break;
            }
            default: {
                throw new IllegalStateException("Illegal column data type in final result: " + columnDataType);
            }
        }
    }
}

