/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.minion;

import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.segment.local.indexsegment.immutable.ImmutableSegmentLoader;
import org.apache.pinot.segment.local.segment.creator.impl.SegmentIndexCreationDriverImpl;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.utils.CrcUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.V1Constants;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.creator.ForwardIndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.ReadMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawIndexConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawIndexConverter.class);
    private static final int CONVERSION_THRESHOLD = 4;
    private static final int BITS_PER_ELEMENT_FOR_RAW_INDEX = -1;
    private final String _rawTableName;
    private final ImmutableSegment _originalImmutableSegment;
    private final SegmentMetadata _originalSegmentMetadata;
    private final File _convertedIndexDir;
    private final PropertiesConfiguration _convertedProperties;
    private final String _columnsToConvert;
    private final ForwardIndexCreatorProvider _indexCreatorProvider;

    public RawIndexConverter(String rawTableName, File originalIndexDir, File convertedIndexDir, @Nullable String columnsToConvert, ForwardIndexCreatorProvider indexCreatorProvider) throws Exception {
        FileUtils.copyDirectory((File)originalIndexDir, (File)convertedIndexDir);
        IndexLoadingConfig indexLoadingConfig = new IndexLoadingConfig();
        indexLoadingConfig.setSegmentVersion(SegmentVersion.v1);
        indexLoadingConfig.setReadMode(ReadMode.mmap);
        this._rawTableName = rawTableName;
        this._originalImmutableSegment = ImmutableSegmentLoader.load((File)originalIndexDir, (IndexLoadingConfig)indexLoadingConfig, null, (boolean)false);
        this._originalSegmentMetadata = this._originalImmutableSegment.getSegmentMetadata();
        this._convertedIndexDir = convertedIndexDir;
        this._convertedProperties = new PropertiesConfiguration(new File(this._convertedIndexDir, "metadata.properties"));
        this._columnsToConvert = columnsToConvert;
        this._indexCreatorProvider = indexCreatorProvider;
    }

    public boolean convert() throws Exception {
        String segmentName = this._originalSegmentMetadata.getName();
        LOGGER.info("Start converting segment: {} in table: {}", (Object)segmentName, (Object)this._rawTableName);
        ArrayList<Object> columnsToConvert = new ArrayList<Object>();
        Schema schema = this._originalSegmentMetadata.getSchema();
        if (this._columnsToConvert == null) {
            LOGGER.info("Columns to convert are not specified, check each metric column");
            for (MetricFieldSpec metricFieldSpec : schema.getMetricFieldSpecs()) {
                if (!this._originalSegmentMetadata.getColumnMetadataFor(metricFieldSpec.getName()).hasDictionary() || !this.shouldConvertColumn((FieldSpec)metricFieldSpec)) continue;
                columnsToConvert.add(metricFieldSpec);
            }
        } else {
            LOGGER.info("Columns to convert: {}", (Object)this._columnsToConvert);
            for (String columnToConvert : StringUtils.split((String)this._columnsToConvert, (char)',')) {
                FieldSpec fieldSpec = schema.getFieldSpecFor(columnToConvert);
                if (fieldSpec == null) {
                    LOGGER.warn("Skip converting column: {} because is does not exist in the schema", columnsToConvert);
                    continue;
                }
                if (!fieldSpec.isSingleValueField()) {
                    LOGGER.warn("Skip converting column: {} because it's a multi-value column", columnsToConvert);
                    continue;
                }
                if (!this._originalSegmentMetadata.getColumnMetadataFor(columnToConvert).hasDictionary()) {
                    LOGGER.warn("Skip converting column: {} because its index is not dictionary-based", columnsToConvert);
                    continue;
                }
                columnsToConvert.add(fieldSpec);
            }
        }
        if (columnsToConvert.isEmpty()) {
            LOGGER.info("No column converted for segment: {} in table: {}", (Object)segmentName, (Object)this._rawTableName);
            return false;
        }
        for (FieldSpec fieldSpec : columnsToConvert) {
            this.convertColumn(fieldSpec);
        }
        this._convertedProperties.save();
        SegmentIndexCreationDriverImpl.persistCreationMeta((File)this._convertedIndexDir, (long)CrcUtils.forAllFilesInFolder((File)this._convertedIndexDir).computeCrc(), (long)this._originalSegmentMetadata.getIndexCreationTime());
        LOGGER.info("{} columns converted for segment: {} in table: {}", new Object[]{columnsToConvert.size(), segmentName, this._rawTableName});
        return true;
    }

    private boolean shouldConvertColumn(FieldSpec fieldSpec) {
        String columnName = fieldSpec.getName();
        FieldSpec.DataType storedType = fieldSpec.getDataType().getStoredType();
        int numTotalDocs = this._originalSegmentMetadata.getTotalDocs();
        ColumnMetadata columnMetadata = this._originalSegmentMetadata.getColumnMetadataFor(columnName);
        int cardinality = columnMetadata.getCardinality();
        int lengthOfEachEntry = storedType.isFixedWidth() ? storedType.size() * 8 : columnMetadata.getColumnMaxLength() * 8;
        long dictionaryBasedIndexSize = (long)numTotalDocs * (long)columnMetadata.getBitsPerElement() + (long)cardinality * (long)lengthOfEachEntry;
        long rawIndexSize = (long)numTotalDocs * (long)lengthOfEachEntry;
        LOGGER.info("For column: {}, size of dictionary based index: {} bits, size of raw index (without compression): {} bits", new Object[]{columnName, dictionaryBasedIndexSize, rawIndexSize});
        return rawIndexSize <= dictionaryBasedIndexSize * 4L;
    }

    private void convertColumn(FieldSpec fieldSpec) throws Exception {
        String columnName = fieldSpec.getName();
        LOGGER.info("Converting column: {}", (Object)columnName);
        FileUtils.deleteQuietly((File)new File(this._convertedIndexDir, columnName + ".dict"));
        FileUtils.deleteQuietly((File)new File(this._convertedIndexDir, columnName + ".sv.unsorted.fwd"));
        FileUtils.deleteQuietly((File)new File(this._convertedIndexDir, columnName + ".sv.sorted.fwd"));
        FileUtils.deleteQuietly((File)new File(this._convertedIndexDir, columnName + ".bitmap.inv"));
        DataSource dataSource = this._originalImmutableSegment.getDataSource(columnName);
        ForwardIndexReader forwardIndexReader = dataSource.getForwardIndex();
        Preconditions.checkState((forwardIndexReader != null ? 1 : 0) != 0, (String)"Forward index disabled for column: %s, raw index conversion operation unsupported!", (Object)columnName);
        Dictionary dictionary = dataSource.getDictionary();
        assert (dictionary != null);
        FieldSpec.DataType storedType = dictionary.getValueType();
        int numDocs = this._originalSegmentMetadata.getTotalDocs();
        ColumnMetadata columnMetadata = this._originalSegmentMetadata.getColumnMetadataFor(columnName);
        try (ForwardIndexCreator rawIndexCreator = this._indexCreatorProvider.newForwardIndexCreator(IndexCreationContext.builder().withIndexDir(this._convertedIndexDir).withColumnMetadata(columnMetadata).withFieldSpec((FieldSpec)new DimensionFieldSpec(columnName, storedType, columnMetadata.isSingleValue())).withDictionary(false).build().forForwardIndex(ChunkCompressionType.LZ4, null));
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();){
            switch (storedType) {
                case INT: {
                    for (int docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putInt(dictionary.getIntValue(forwardIndexReader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case LONG: {
                    for (int docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putLong(dictionary.getLongValue(forwardIndexReader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case FLOAT: {
                    for (int docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putFloat(dictionary.getFloatValue(forwardIndexReader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case DOUBLE: {
                    for (int docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putDouble(dictionary.getDoubleValue(forwardIndexReader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case STRING: {
                    for (int docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putString(dictionary.getStringValue(forwardIndexReader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                case BYTES: {
                    for (int docId = 0; docId < numDocs; ++docId) {
                        rawIndexCreator.putBytes(dictionary.getBytesValue(forwardIndexReader.getDictId(docId, readerContext)));
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        this._convertedProperties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)columnName, (String)"hasDictionary"), (Object)false);
        this._convertedProperties.setProperty(V1Constants.MetadataKeys.Column.getKeyFor((String)columnName, (String)"bitsPerElement"), (Object)-1);
    }
}

