/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.DoNotCall;
import io.grpc.BinaryLog;
import io.grpc.ClientInterceptor;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.NameResolver;
import io.grpc.ProxyDetector;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public abstract class AbstractManagedChannelImplBuilder<T extends ManagedChannelBuilder<T>>
extends ManagedChannelBuilder<T> {
    protected AbstractManagedChannelImplBuilder() {
    }

    @DoNotCall(value="Unsupported")
    public static ManagedChannelBuilder<?> forAddress(String name, int port) {
        throw new UnsupportedOperationException("Subclass failed to hide static factory");
    }

    @DoNotCall(value="Unsupported")
    public static ManagedChannelBuilder<?> forTarget(String target) {
        throw new UnsupportedOperationException("Subclass failed to hide static factory");
    }

    protected abstract ManagedChannelBuilder<?> delegate();

    public T directExecutor() {
        this.delegate().directExecutor();
        return this.thisT();
    }

    public T executor(Executor executor) {
        this.delegate().executor(executor);
        return this.thisT();
    }

    public T offloadExecutor(Executor executor) {
        this.delegate().offloadExecutor(executor);
        return this.thisT();
    }

    public T intercept(List<ClientInterceptor> interceptors) {
        this.delegate().intercept(interceptors);
        return this.thisT();
    }

    public T intercept(ClientInterceptor ... interceptors) {
        this.delegate().intercept(interceptors);
        return this.thisT();
    }

    public T userAgent(String userAgent) {
        this.delegate().userAgent(userAgent);
        return this.thisT();
    }

    public T overrideAuthority(String authority) {
        this.delegate().overrideAuthority(authority);
        return this.thisT();
    }

    public T usePlaintext() {
        this.delegate().usePlaintext();
        return this.thisT();
    }

    public T useTransportSecurity() {
        this.delegate().useTransportSecurity();
        return this.thisT();
    }

    @Deprecated
    public T nameResolverFactory(NameResolver.Factory resolverFactory) {
        this.delegate().nameResolverFactory(resolverFactory);
        return this.thisT();
    }

    public T defaultLoadBalancingPolicy(String policy) {
        this.delegate().defaultLoadBalancingPolicy(policy);
        return this.thisT();
    }

    public T enableFullStreamDecompression() {
        this.delegate().enableFullStreamDecompression();
        return this.thisT();
    }

    public T decompressorRegistry(DecompressorRegistry registry) {
        this.delegate().decompressorRegistry(registry);
        return this.thisT();
    }

    public T compressorRegistry(CompressorRegistry registry) {
        this.delegate().compressorRegistry(registry);
        return this.thisT();
    }

    public T idleTimeout(long value, TimeUnit unit) {
        this.delegate().idleTimeout(value, unit);
        return this.thisT();
    }

    public T maxInboundMessageSize(int max) {
        this.delegate().maxInboundMessageSize(max);
        return this.thisT();
    }

    public T maxInboundMetadataSize(int max) {
        this.delegate().maxInboundMetadataSize(max);
        return this.thisT();
    }

    public T keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.delegate().keepAliveTime(keepAliveTime, timeUnit);
        return this.thisT();
    }

    public T keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        this.delegate().keepAliveTimeout(keepAliveTimeout, timeUnit);
        return this.thisT();
    }

    public T keepAliveWithoutCalls(boolean enable) {
        this.delegate().keepAliveWithoutCalls(enable);
        return this.thisT();
    }

    public T maxRetryAttempts(int maxRetryAttempts) {
        this.delegate().maxRetryAttempts(maxRetryAttempts);
        return this.thisT();
    }

    public T maxHedgedAttempts(int maxHedgedAttempts) {
        this.delegate().maxHedgedAttempts(maxHedgedAttempts);
        return this.thisT();
    }

    public T retryBufferSize(long bytes) {
        this.delegate().retryBufferSize(bytes);
        return this.thisT();
    }

    public T perRpcBufferLimit(long bytes) {
        this.delegate().perRpcBufferLimit(bytes);
        return this.thisT();
    }

    public T disableRetry() {
        this.delegate().disableRetry();
        return this.thisT();
    }

    public T enableRetry() {
        this.delegate().enableRetry();
        return this.thisT();
    }

    public T setBinaryLog(BinaryLog binaryLog) {
        this.delegate().setBinaryLog(binaryLog);
        return this.thisT();
    }

    public T maxTraceEvents(int maxTraceEvents) {
        this.delegate().maxTraceEvents(maxTraceEvents);
        return this.thisT();
    }

    public T proxyDetector(ProxyDetector proxyDetector) {
        this.delegate().proxyDetector(proxyDetector);
        return this.thisT();
    }

    public T defaultServiceConfig(@Nullable Map<String, ?> serviceConfig) {
        this.delegate().defaultServiceConfig(serviceConfig);
        return this.thisT();
    }

    public T disableServiceConfigLookUp() {
        this.delegate().disableServiceConfigLookUp();
        return this.thisT();
    }

    public ManagedChannel build() {
        return this.delegate().build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("delegate", this.delegate()).toString();
    }

    protected final T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)((Object)thisT);
    }
}

