/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx.internal.guava.graph;

import com.google.errorprone.annotations.Immutable;
import org.weakref.jmx.internal.guava.annotations.Beta;
import org.weakref.jmx.internal.guava.base.Function;
import org.weakref.jmx.internal.guava.base.Functions;
import org.weakref.jmx.internal.guava.base.Preconditions;
import org.weakref.jmx.internal.guava.collect.ImmutableMap;
import org.weakref.jmx.internal.guava.collect.Maps;
import org.weakref.jmx.internal.guava.graph.BaseGraph;
import org.weakref.jmx.internal.guava.graph.ConfigurableValueGraph;
import org.weakref.jmx.internal.guava.graph.DirectedGraphConnections;
import org.weakref.jmx.internal.guava.graph.ForwardingGraph;
import org.weakref.jmx.internal.guava.graph.Graph;
import org.weakref.jmx.internal.guava.graph.GraphBuilder;
import org.weakref.jmx.internal.guava.graph.GraphConnections;
import org.weakref.jmx.internal.guava.graph.GraphConstants;
import org.weakref.jmx.internal.guava.graph.UndirectedGraphConnections;

@Immutable(containerOf={"N"})
@Beta
public class ImmutableGraph<N>
extends ForwardingGraph<N> {
    private final BaseGraph<N> backingGraph;

    ImmutableGraph(BaseGraph<N> backingGraph) {
        this.backingGraph = backingGraph;
    }

    public static <N> ImmutableGraph<N> copyOf(Graph<N> graph) {
        return graph instanceof ImmutableGraph ? (ImmutableGraph<N>)graph : new ImmutableGraph<N>(new ConfigurableValueGraph<N, GraphConstants.Presence>(GraphBuilder.from(graph), ImmutableGraph.getNodeConnections(graph), graph.edges().size()));
    }

    @Deprecated
    public static <N> ImmutableGraph<N> copyOf(ImmutableGraph<N> graph) {
        return Preconditions.checkNotNull(graph);
    }

    private static <N> ImmutableMap<N, GraphConnections<N, GraphConstants.Presence>> getNodeConnections(Graph<N> graph) {
        ImmutableMap.Builder<N, GraphConnections<N, GraphConstants.Presence>> nodeConnections = ImmutableMap.builder();
        for (N node : graph.nodes()) {
            nodeConnections.put(node, ImmutableGraph.connectionsOf(graph, node));
        }
        return nodeConnections.build();
    }

    private static <N> GraphConnections<N, GraphConstants.Presence> connectionsOf(Graph<N> graph, N node) {
        Function<Object, GraphConstants.Presence> edgeValueFn = Functions.constant(GraphConstants.Presence.EDGE_EXISTS);
        return graph.isDirected() ? DirectedGraphConnections.ofImmutable(graph.predecessors((Object)node), Maps.asMap(graph.successors((Object)node), edgeValueFn)) : UndirectedGraphConnections.ofImmutable(Maps.asMap(graph.adjacentNodes(node), edgeValueFn));
    }

    @Override
    protected BaseGraph<N> delegate() {
        return this.backingGraph;
    }
}

