/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.bootstrap;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.spi.Message;
import io.airlift.bootstrap.ApplicationConfigurationException;
import io.airlift.bootstrap.ColumnPrinter;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.bootstrap.LifeCycleModule;
import io.airlift.bootstrap.LoggingWriter;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationInspector;
import io.airlift.configuration.ConfigurationLoader;
import io.airlift.configuration.ConfigurationModule;
import io.airlift.configuration.WarningsMonitor;
import io.airlift.log.Logger;
import io.airlift.log.Logging;
import io.airlift.log.LoggingConfiguration;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bootstrap {
    private static final Pattern ENV_PATTERN = Pattern.compile("\\$\\{ENV:([a-zA-Z][a-zA-Z0-9_]*)}");
    private final Logger log = Logger.get((String)"Bootstrap");
    private final List<Module> modules;
    private Map<String, String> requiredConfigurationProperties;
    private Map<String, String> optionalConfigurationProperties;
    private boolean initializeLogging = true;
    private boolean quiet;
    private boolean strictConfig = true;
    private boolean initialized;

    public Bootstrap(Module ... modules) {
        this((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    public Bootstrap(Iterable<? extends Module> modules) {
        this.modules = ImmutableList.copyOf(modules);
    }

    public Bootstrap setRequiredConfigurationProperty(String key, String value) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.put(key, value);
        return this;
    }

    public Bootstrap setRequiredConfigurationProperties(Map<String, String> requiredConfigurationProperties) {
        if (this.requiredConfigurationProperties == null) {
            this.requiredConfigurationProperties = new TreeMap<String, String>();
        }
        this.requiredConfigurationProperties.putAll(requiredConfigurationProperties);
        return this;
    }

    public Bootstrap setOptionalConfigurationProperty(String key, String value) {
        if (this.optionalConfigurationProperties == null) {
            this.optionalConfigurationProperties = new TreeMap<String, String>();
        }
        this.optionalConfigurationProperties.put(key, value);
        return this;
    }

    public Bootstrap setOptionalConfigurationProperties(Map<String, String> optionalConfigurationProperties) {
        if (this.optionalConfigurationProperties == null) {
            this.optionalConfigurationProperties = new TreeMap<String, String>();
        }
        this.optionalConfigurationProperties.putAll(optionalConfigurationProperties);
        return this;
    }

    public Bootstrap doNotInitializeLogging() {
        this.initializeLogging = false;
        return this;
    }

    public Bootstrap quiet() {
        this.quiet = true;
        return this;
    }

    @Deprecated(forRemoval=true)
    public Bootstrap strictConfig() {
        this.strictConfig = true;
        return this;
    }

    @Deprecated(forRemoval=true)
    public Bootstrap nonStrictConfig() {
        this.strictConfig = false;
        return this;
    }

    public Injector initialize() {
        Map requiredProperties;
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Already initialized");
        this.initialized = true;
        Logging logging = null;
        if (this.initializeLogging) {
            logging = Logging.initialize();
        }
        Thread.currentThread().setUncaughtExceptionHandler((thread, throwable) -> this.log.error(throwable, "Uncaught exception in thread %s", new Object[]{thread.getName()}));
        if (this.requiredConfigurationProperties == null) {
            this.log.info("Loading configuration");
            requiredProperties = Collections.emptyMap();
            String configFile = System.getProperty("config");
            if (configFile != null) {
                try {
                    requiredProperties = ConfigurationLoader.loadPropertiesFrom((String)configFile);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        } else {
            requiredProperties = this.requiredConfigurationProperties;
        }
        TreeMap<String, String> unusedProperties = new TreeMap<String, String>(requiredProperties);
        ImmutableSortedMap properties = new HashMap<String, String>();
        if (this.optionalConfigurationProperties != null) {
            properties.putAll(this.optionalConfigurationProperties);
        }
        properties.putAll(requiredProperties);
        properties.putAll(ConfigurationLoader.getSystemProperties());
        ArrayList<Message> errors = new ArrayList<Message>();
        properties = Bootstrap.replaceEnvironmentVariables(properties, System.getenv(), (key, error) -> {
            unusedProperties.remove(key);
            errors.add(new Message(error));
        });
        properties = ImmutableSortedMap.copyOf(properties);
        ArrayList<Message> warnings = new ArrayList<Message>();
        ConfigurationFactory configurationFactory = new ConfigurationFactory((Map)properties, warning -> warnings.add(new Message(warning)));
        if (logging != null) {
            this.log.info("Initializing logging");
            LoggingConfiguration configuration = (LoggingConfiguration)configurationFactory.build(LoggingConfiguration.class);
            logging.configure(configuration);
        }
        configurationFactory.registerConfigurationClasses(this.modules);
        errors.addAll(configurationFactory.validateRegisteredConfigurationProvider());
        unusedProperties.keySet().removeAll(configurationFactory.getUsedProperties());
        for (String key2 : unusedProperties.keySet()) {
            Message message = new Message(String.format("Configuration property '%s' was not used", key2));
            (this.strictConfig ? errors : warnings).add(message);
        }
        if (!errors.isEmpty()) {
            throw new ApplicationConfigurationException(errors, warnings);
        }
        if (!this.quiet) {
            this.logConfiguration(configurationFactory);
        }
        if (!warnings.isEmpty()) {
            StringBuilder message = new StringBuilder();
            message.append("Configuration warnings\n");
            message.append("==========\n\n");
            message.append("Configuration should be updated:\n\n");
            for (int index = 0; index < warnings.size(); ++index) {
                message.append(String.format("%s) %s\n", index + 1, warnings.get(index)));
            }
            message.append("\n");
            message.append("==========");
            this.log.warn(message.toString());
        }
        ImmutableList.Builder moduleList = ImmutableList.builder();
        moduleList.add((Object)new LifeCycleModule());
        moduleList.add((Object)new ConfigurationModule(configurationFactory));
        moduleList.add(binder -> binder.bind(WarningsMonitor.class).toInstance(arg_0 -> ((Logger)this.log).warn(arg_0)));
        moduleList.add(Binder::disableCircularProxies);
        moduleList.add(Binder::requireExplicitBindings);
        moduleList.add(Binder::requireExactBindingAnnotations);
        moduleList.addAll(this.modules);
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Iterable)moduleList.build());
        LifeCycleManager lifeCycleManager = (LifeCycleManager)injector.getInstance(LifeCycleManager.class);
        if (lifeCycleManager.size() > 0) {
            lifeCycleManager.start();
        }
        return injector;
    }

    private void logConfiguration(ConfigurationFactory configurationFactory) {
        ColumnPrinter columnPrinter = Bootstrap.makePrinterForConfiguration(configurationFactory);
        try (PrintWriter out = new PrintWriter(new LoggingWriter(this.log));){
            columnPrinter.print(out);
        }
    }

    private static ColumnPrinter makePrinterForConfiguration(ConfigurationFactory configurationFactory) {
        ConfigurationInspector configurationInspector = new ConfigurationInspector();
        ColumnPrinter columnPrinter = new ColumnPrinter("PROPERTY", "DEFAULT", "RUNTIME", "DESCRIPTION");
        for (ConfigurationInspector.ConfigRecord record : configurationInspector.inspect(configurationFactory)) {
            for (ConfigurationInspector.ConfigAttribute attribute : record.getAttributes()) {
                columnPrinter.addValues(attribute.getPropertyName(), attribute.getDefaultValue(), attribute.getCurrentValue(), attribute.getDescription());
            }
        }
        return columnPrinter;
    }

    @VisibleForTesting
    static Map<String, String> replaceEnvironmentVariables(Map<String, String> properties, Map<String, String> environment, BiConsumer<String, String> onError) {
        HashMap<String, String> replaced = new HashMap<String, String>();
        properties.forEach((propertyKey, propertyValue) -> {
            StringBuilder replacedPropertyValue = new StringBuilder();
            Matcher matcher = ENV_PATTERN.matcher((CharSequence)propertyValue);
            while (matcher.find()) {
                String envName = matcher.group(1);
                String envValue = (String)environment.get(envName);
                if (envValue == null) {
                    onError.accept((String)propertyKey, String.format("Configuration property '%s' references unset environment variable '%s'", propertyKey, envName));
                    return;
                }
                matcher.appendReplacement(replacedPropertyValue, Matcher.quoteReplacement(envValue));
            }
            matcher.appendTail(replacedPropertyValue);
            replaced.put((String)propertyKey, replacedPropertyValue.toString());
        });
        return replaced;
    }
}

