/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray;

import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import xerial.larray.AbstractLIterator;
import xerial.larray.BufferedLIterator;
import xerial.larray.LArray;
import xerial.larray.LArray$;
import xerial.larray.LBuilder;
import xerial.larray.LIterator;
import xerial.larray.LIterator$;

public abstract class LIterator$class {
    public static boolean isEmpty(LIterator $this) {
        return !$this.hasNext();
    }

    public static BufferedLIterator buffered(LIterator $this) {
        return new BufferedLIterator<A>($this){
            private A hd;
            private boolean hdDefined;
            private final /* synthetic */ LIterator $outer;

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            public A head() {
                if (!this.hdDefined()) {
                    this.hd_$eq(this.next());
                    this.hdDefined_$eq(true);
                }
                return this.hd();
            }

            public boolean hasNext() {
                return this.hdDefined() || this.$outer.hasNext();
            }

            public A next() {
                A a;
                if (this.hdDefined()) {
                    this.hdDefined_$eq(false);
                    a = this.hd();
                } else {
                    a = this.$outer.next();
                }
                return a;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.hdDefined = false;
            }
        };
    }

    public static LIterator collect(LIterator $this, PartialFunction pf) {
        BufferedLIterator self = $this.buffered();
        return new AbstractLIterator<B>($this, self, pf){
            private final BufferedLIterator self$1;
            private final PartialFunction pf$1;

            private void skip() {
                while (this.self$1.hasNext() && !this.pf$1.isDefinedAt(this.self$1.head())) {
                    this.self$1.next();
                }
            }

            public boolean hasNext() {
                this.skip();
                return this.self$1.hasNext();
            }

            public B next() {
                this.skip();
                return (B)this.pf$1.apply(this.self$1.next());
            }
            {
                void var3_3;
                this.self$1 = self$1;
                this.pf$1 = var3_3;
            }
        };
    }

    public static LIterator scanLeft(LIterator $this, Object z, Function2 op) {
        return new AbstractLIterator<B>($this, z, op){
            private boolean hasNext;
            private B elem;
            private final /* synthetic */ LIterator $outer;
            private final Function2 op$1;

            public boolean hasNext() {
                return this.hasNext;
            }

            private void hasNext_$eq(boolean x$1) {
                this.hasNext = x$1;
            }

            private B elem() {
                return this.elem;
            }

            private void elem_$eq(B x$1) {
                this.elem = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public B next() {
                Nothing$ nothing$;
                if (this.hasNext()) {
                    void var1_1;
                    B res = this.elem();
                    if (this.$outer.hasNext()) {
                        this.elem_$eq(this.op$1.apply(this.elem(), this.$outer.next()));
                    } else {
                        this.hasNext_$eq(false);
                    }
                    nothing$ = var1_1;
                } else {
                    nothing$ = LIterator$.MODULE$.empty().next();
                }
                return (B)nothing$;
            }
            {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.op$1 = var3_3;
                this.hasNext = true;
                this.elem = z$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static boolean exists(LIterator $this, Function1 p) {
        void var2_2;
        boolean res = false;
        while (!res && $this.hasNext()) {
            res = BoxesRunTime.unboxToBoolean((Object)p.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    public static boolean contains(LIterator $this, Object elem) {
        return $this.exists(new Serializable($this, elem){
            public static final long serialVersionUID = 0L;
            private final Object elem$1;

            public final boolean apply(A x$1) {
                return BoxesRunTime.equals(x$1, (Object)this.elem$1);
            }
            {
                this.elem$1 = elem$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static Option find(LIterator $this, Function1 p) {
        void var2_2;
        None$ res = None$.MODULE$;
        while (res.isEmpty() && $this.hasNext()) {
            Object e = $this.next();
            if (!BoxesRunTime.unboxToBoolean((Object)p.apply(e))) continue;
            res = new Some(e);
        }
        return var2_2;
    }

    public static long indexWhere(LIterator $this, Function1 p) {
        long i = 0L;
        boolean found = false;
        while (!found && $this.hasNext()) {
            if (BoxesRunTime.unboxToBoolean((Object)p.apply($this.next()))) {
                found = true;
                continue;
            }
            ++i;
        }
        return found ? i : -1L;
    }

    public static long indexOf(LIterator $this, Object elem) {
        long i = 0L;
        boolean found = false;
        while (!found && $this.hasNext()) {
            if (BoxesRunTime.equals($this.next(), (Object)elem)) {
                found = true;
                continue;
            }
            ++i;
        }
        return found ? i : -1L;
    }

    public static void foreach(LIterator $this, Function1 f) {
        while ($this.hasNext()) {
            f.apply($this.next());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static boolean forall(LIterator $this, Function1 pred) {
        void var2_2;
        boolean result = true;
        while (result && $this.hasNext()) {
            result = BoxesRunTime.unboxToBoolean((Object)pred.apply($this.next()));
        }
        return (boolean)var2_2;
    }

    public static LIterator map(LIterator $this, Function1 f) {
        return new AbstractLIterator<B>($this, f){
            private final /* synthetic */ LIterator $outer;
            private final Function1 f$1;

            public B next() {
                return (B)this.f$1.apply(this.$outer.next());
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$1 = f$1;
            }
        };
    }

    public static LIterator flatMap(LIterator $this, Function1 f) {
        return new AbstractLIterator<B>($this, f){
            private LIterator<B> current;
            private final /* synthetic */ LIterator $outer;
            private final Function1 f$2;

            private LIterator<B> current() {
                return this.current;
            }

            private void current_$eq(LIterator<B> x$1) {
                this.current = x$1;
            }

            public boolean hasNext() {
                boolean bl;
                block2: {
                    while (true) {
                        if (this.current().hasNext()) {
                            bl = true;
                            break block2;
                        }
                        if (!this.$outer.hasNext()) break;
                        this.current_$eq((LIterator)this.f$2.apply(this.$outer.next()));
                    }
                    bl = false;
                }
                return bl;
            }

            public B next() {
                return (B)(this.hasNext() ? this.current() : LIterator$.MODULE$.empty()).next();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.f$2 = f$2;
                this.current = LIterator$.MODULE$.empty();
            }
        };
    }

    public static Object reduceLeft(LIterator $this, Function2 op) {
        if ($this.isEmpty()) {
            throw new UnsupportedOperationException("empty.reduceLeft");
        }
        BooleanRef first = new BooleanRef(true);
        ObjectRef acc = new ObjectRef((Object)BoxesRunTime.boxToInteger((int)0));
        $this.foreach(new Serializable($this, first, acc, op){
            public static final long serialVersionUID = 0L;
            private final BooleanRef first$1;
            private final ObjectRef acc$1;
            private final Function2 op$2;

            public final void apply(A x) {
                if (this.first$1.elem) {
                    this.acc$1.elem = x;
                    this.first$1.elem = false;
                } else {
                    this.acc$1.elem = this.op$2.apply(this.acc$1.elem, x);
                }
            }
            {
                void var4_4;
                void var3_3;
                this.first$1 = first$1;
                this.acc$1 = var3_3;
                this.op$2 = var4_4;
            }
        });
        return acc.elem;
    }

    public static LIterator filter(LIterator $this, Function1 pred) {
        return new AbstractLIterator<A>($this, pred){
            private A head;
            private boolean headDefined;
            private final /* synthetic */ LIterator $outer;
            private final Function1 pred$1;

            private A head() {
                return this.head;
            }

            private void head_$eq(A x$1) {
                this.head = x$1;
            }

            private boolean headDefined() {
                return this.headDefined;
            }

            private void headDefined_$eq(boolean x$1) {
                this.headDefined = x$1;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.headDefined_$eq(false);
                    object = this.head();
                } else {
                    object = LIterator$.MODULE$.empty().next();
                }
                return (A)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.headDefined()) return true;
                do {
                    if (!this.$outer.hasNext()) return false;
                    this.head_$eq(this.$outer.next());
                } while (!BoxesRunTime.unboxToBoolean((Object)this.pred$1.apply(this.head())));
                this.headDefined_$eq(true);
                if (!true) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.pred$1 = pred$1;
                this.headDefined = false;
            }
        };
    }

    public static LIterator filterNot(LIterator $this, Function1 p) {
        return $this.filter(new Serializable($this, p){
            public static final long serialVersionUID = 0L;
            private final Function1 p$1;

            public final boolean apply(A x$2) {
                return !BoxesRunTime.unboxToBoolean((Object)this.p$1.apply(x$2));
            }
            {
                this.p$1 = p$1;
            }
        });
    }

    public static StringBuilder addString(LIterator $this, StringBuilder b, String start, String sep, String end) {
        BooleanRef first = new BooleanRef(true);
        b.append(start);
        $this.foreach(new Serializable($this, first, b, sep){
            public static final long serialVersionUID = 0L;
            private final BooleanRef first$2;
            private final StringBuilder b$3;
            private final String sep$1;

            public final Object apply(A x) {
                BoxedUnit boxedUnit;
                if (this.first$2.elem) {
                    this.b$3.append(x);
                    this.first$2.elem = false;
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.b$3.append(this.sep$1);
                    boxedUnit = this.b$3.append(x);
                }
                return boxedUnit;
            }
            {
                void var4_4;
                void var3_3;
                this.first$2 = first$2;
                this.b$3 = var3_3;
                this.sep$1 = var4_4;
            }
        });
        b.append(end);
        return b;
    }

    public static String mkString(LIterator $this, String start, String sep, String end) {
        return $this.addString(new StringBuilder(), start, sep, end).toString();
    }

    public static String mkString(LIterator $this, String sep) {
        return $this.mkString("", sep, "");
    }

    public static String mkString(LIterator $this) {
        return $this.mkString("");
    }

    public static LIterator withFilter(LIterator $this, Function1 p) {
        return $this.filter(p);
    }

    public static boolean sameElements(LIterator $this, LIterator that) {
        while ($this.hasNext() && that.hasNext()) {
            if (BoxesRunTime.equals($this.next(), that.next())) continue;
            return false;
        }
        return !$this.hasNext() && !that.hasNext();
    }

    public static LIterator slice(LIterator $this, long from, long until) {
        long lo;
        for (long toDrop = lo = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(from)).max((Object)BoxesRunTime.boxToLong((long)0L))); toDrop > 0L && $this.hasNext(); --toDrop) {
            $this.next();
        }
        return new AbstractLIterator<A>($this, lo, until){
            private long remaining;
            private final /* synthetic */ LIterator $outer;

            private long remaining() {
                return this.remaining;
            }

            private void remaining_$eq(long x$1) {
                this.remaining = x$1;
            }

            public boolean hasNext() {
                return this.remaining() > 0L && this.$outer.hasNext();
            }

            public A next() {
                Object object;
                if (this.remaining() > 0L) {
                    this.remaining_$eq(this.remaining() - 1L);
                    object = this.$outer.next();
                } else {
                    object = LIterator$.MODULE$.empty().next();
                }
                return (A)object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.remaining = until$1 - lo$1;
            }
        };
    }

    public static long size(LIterator $this) {
        LongRef count = new LongRef(0L);
        $this.foreach(new Serializable($this, count){
            public static final long serialVersionUID = 0L;
            private final LongRef count$1;

            public final void apply(A x) {
                ++this.count$1.elem;
            }
            {
                this.count$1 = count$1;
            }
        });
        return count.elem;
    }

    public static LIterator take(LIterator $this, long n) {
        return $this.slice(0L, n);
    }

    public static LIterator takeWhile(LIterator $this, Function1 p) {
        return new AbstractLIterator<A>($this, p){
            private A hd;
            private boolean hdDefined;
            private LIterator<A> tail;
            private final Function1 p$2;

            private A hd() {
                return this.hd;
            }

            private void hd_$eq(A x$1) {
                this.hd = x$1;
            }

            private boolean hdDefined() {
                return this.hdDefined;
            }

            private void hdDefined_$eq(boolean x$1) {
                this.hdDefined = x$1;
            }

            private LIterator<A> tail() {
                return this.tail;
            }

            private void tail_$eq(LIterator<A> x$1) {
                this.tail = x$1;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (this.hdDefined()) return true;
                if (!this.tail().hasNext()) return false;
                this.hd_$eq(this.tail().next());
                if (BoxesRunTime.unboxToBoolean((Object)this.p$2.apply(this.hd()))) {
                    this.hdDefined_$eq(true);
                } else {
                    this.tail_$eq(LIterator$.MODULE$.empty());
                }
                if (!this.hdDefined()) return false;
                return true;
            }

            public A next() {
                Object object;
                if (this.hasNext()) {
                    this.hdDefined_$eq(false);
                    object = this.hd();
                } else {
                    object = LIterator$.MODULE$.empty().next();
                }
                return (A)object;
            }
            {
                this.p$2 = p$2;
                this.hdDefined = false;
                this.tail = $outer;
            }
        };
    }

    public static Tuple2 partition(LIterator $this, Function1 p) {
        BufferedLIterator self = $this.buffered();
        public class Xerial_larray_LIterator$PartitionIterator$1
        extends AbstractLIterator<A> {
            private final Function1<A, Object> p;
            private Xerial_larray_LIterator$PartitionIterator$1 other;
            private final Queue<A> lookahead;
            public final /* synthetic */ LIterator $outer;
            private final BufferedLIterator self$2;

            public Xerial_larray_LIterator$PartitionIterator$1 other() {
                return this.other;
            }

            public void other_$eq(Xerial_larray_LIterator$PartitionIterator$1 x$1) {
                this.other = x$1;
            }

            public Queue<A> lookahead() {
                return this.lookahead;
            }

            public void skip() {
                while (this.self$2.hasNext() && !BoxesRunTime.unboxToBoolean((Object)this.p.apply(this.self$2.head()))) {
                    this.other().lookahead().$plus$eq(this.self$2.next());
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean hasNext() {
                if (!this.lookahead().isEmpty()) return true;
                this.skip();
                if (this.self$2.hasNext()) return true;
                return false;
            }

            public A next() {
                Object object;
                if (this.lookahead().isEmpty()) {
                    this.skip();
                    object = this.self$2.next();
                } else {
                    object = this.lookahead().dequeue();
                }
                return (A)object;
            }

            public /* synthetic */ LIterator xerial$larray$LIterator$PartitionIterator$$$outer() {
                return this.$outer;
            }

            public Xerial_larray_LIterator$PartitionIterator$1(LIterator<A> p, Function1<A, Object> self$2) {
                this.p = p;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.self$2 = self$2;
                this.lookahead = new Queue();
            }
        }
        Xerial_larray_LIterator$PartitionIterator$1 l = new Xerial_larray_LIterator$PartitionIterator$1($this, p, self);
        Xerial_larray_LIterator$PartitionIterator$1 r = new Xerial_larray_LIterator$PartitionIterator$1($this, (Function1)new Serializable($this, p){
            public static final long serialVersionUID = 0L;
            private final Function1 p$3;

            public final boolean apply(A x$3) {
                return !BoxesRunTime.unboxToBoolean((Object)this.p$3.apply(x$3));
            }
            {
                this.p$3 = p$3;
            }
        }, self);
        l.other_$eq(r);
        r.other_$eq(l);
        return new Tuple2((Object)l, (Object)r);
    }

    public static Tuple2 span(LIterator $this, Function1 p) {
        BufferedLIterator self = $this.buffered();
        public class Xerial_larray_LIterator$Leading$1
        extends AbstractLIterator<A> {
            private boolean isDone;
            private final Queue<A> lookahead;
            public final /* synthetic */ LIterator $outer;
            private final BufferedLIterator self$3;
            private final Function1 p$4;

            private boolean isDone() {
                return this.isDone;
            }

            private void isDone_$eq(boolean x$1) {
                this.isDone = x$1;
            }

            public Queue<A> lookahead() {
                return this.lookahead;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean advance() {
                if (!this.self$3.hasNext()) return false;
                if (!BoxesRunTime.unboxToBoolean((Object)this.p$4.apply(this.self$3.head()))) return false;
                this.lookahead().$plus$eq(this.self$3.next());
                if (!true) return false;
                return true;
            }

            public void finish() {
                while (this.advance()) {
                }
                this.isDone_$eq(true);
            }

            public boolean hasNext() {
                return this.lookahead().nonEmpty() || this.advance();
            }

            public A next() {
                Object object = this.lookahead().isEmpty() ? BoxesRunTime.boxToBoolean((boolean)this.advance()) : BoxedUnit.UNIT;
                return (A)this.lookahead().dequeue();
            }

            public /* synthetic */ LIterator xerial$larray$LIterator$Leading$$$outer() {
                return this.$outer;
            }

            /*
             * WARNING - void declaration
             */
            public Xerial_larray_LIterator$Leading$1(LIterator<A> self$3) {
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.self$3 = self$3;
                this.p$4 = var3_3;
                this.isDone = false;
                this.lookahead = new Queue();
            }
        }
        Xerial_larray_LIterator$Leading$1 leading = new Xerial_larray_LIterator$Leading$1($this, self, p);
        AbstractLIterator trailing = new AbstractLIterator<A>($this, self, leading){
            private BufferedLIterator<A> it;
            private final BufferedLIterator self$3;
            private final Xerial_larray_LIterator$Leading$1 leading$1;
            private volatile boolean bitmap$0;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            private BufferedLIterator it$lzycompute() {
                LIterator$.anon.9 var1_1 = this;
                synchronized (var1_1) {
                    if (!this.bitmap$0) {
                        this.leading$1.finish();
                        this.it = this.self$3;
                        this.bitmap$0 = true;
                    }
                }
                this.self$3 = null;
                this.leading$1 = null;
                return this.it;
            }

            private BufferedLIterator<A> it() {
                return this.bitmap$0 ? this.it : this.it$lzycompute();
            }

            public boolean hasNext() {
                return this.it().hasNext();
            }

            public A next() {
                return this.it().next();
            }

            public String toString() {
                return "unknown-if-empty iterator";
            }
            {
                void var3_3;
                this.self$3 = self$3;
                this.leading$1 = var3_3;
            }
        };
        return new Tuple2((Object)leading, (Object)trailing);
    }

    public static LIterator drop(LIterator $this, long n) {
        return $this.slice(n, Long.MAX_VALUE);
    }

    public static Object toArray(LIterator $this, ClassTag evidence$1) {
        ArrayBuilder b = Array$.MODULE$.newBuilder(evidence$1);
        $this.foreach(new Serializable($this, b){
            public static final long serialVersionUID = 0L;
            private final ArrayBuilder b$1;

            public final ArrayBuilder<A1> apply(A x$4) {
                return (ArrayBuilder)this.b$1.$plus$eq(x$4);
            }
            {
                this.b$1 = b$1;
            }
        });
        return b.result();
    }

    public static LIterator zipAll(LIterator $this, LIterator that, Object thisElem, Object thatElem) {
        return new AbstractLIterator<Tuple2<A1, B1>>($this, that, thisElem, thatElem){
            private final /* synthetic */ LIterator $outer;
            private final LIterator that$1;
            private final Object thisElem$1;
            private final Object thatElem$1;

            public boolean hasNext() {
                return this.$outer.hasNext() || this.that$1.hasNext();
            }

            public Tuple2<A1, B1> next() {
                return this.$outer.hasNext() ? (this.that$1.hasNext() ? new Tuple2(this.$outer.next(), this.that$1.next()) : new Tuple2(this.$outer.next(), this.thatElem$1)) : (this.that$1.hasNext() ? new Tuple2(this.thisElem$1, this.that$1.next()) : (Tuple2)LIterator$.MODULE$.empty().next());
            }
            {
                void var4_4;
                void var3_3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.that$1 = that$1;
                this.thisElem$1 = var3_3;
                this.thatElem$1 = var4_4;
            }
        };
    }

    public static LIterator zipWithIndex(LIterator $this) {
        return new AbstractLIterator<Tuple2<A, Object>>($this){
            private long index;
            private final /* synthetic */ LIterator $outer;

            private long index() {
                return this.index;
            }

            private void index_$eq(long x$1) {
                this.index = x$1;
            }

            /*
             * WARNING - void declaration
             */
            public Tuple2<A, Object> next() {
                void var1_1;
                Tuple2 v = new Tuple2(this.$outer.next(), (Object)BoxesRunTime.boxToLong((long)this.index()));
                this.index_$eq(this.index() + 1L);
                return var1_1;
            }

            public boolean hasNext() {
                return this.$outer.hasNext();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.index = 0L;
            }
        };
    }

    public static LIterator zip(LIterator $this, LIterator that) {
        return new AbstractLIterator<Tuple2<A, B>>($this, that){
            private final /* synthetic */ LIterator $outer;
            private final LIterator that$2;

            public boolean hasNext() {
                return this.$outer.hasNext() && this.that$2.hasNext();
            }

            public Tuple2<A, B> next() {
                return new Tuple2(this.$outer.next(), this.that$2.next());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.that$2 = that$2;
            }
        };
    }

    public static LArray toLArray(LIterator $this, ClassTag evidence$2) {
        LBuilder b = LArray$.MODULE$.newBuilder(evidence$2);
        $this.foreach(new Serializable($this, b){
            public static final long serialVersionUID = 0L;
            private final LBuilder b$2;

            public final LBuilder<B, LArray<B>> apply(A x$5) {
                return this.b$2.$plus$eq(x$5);
            }
            {
                this.b$2 = b$2;
            }
        });
        return b.result();
    }

    public static void $init$(LIterator $this) {
    }
}

