/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray;

import java.util.Iterator;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import xerial.larray.AbstractLIterator;
import xerial.larray.LArray;
import xerial.larray.LBuilder;
import xerial.larray.LIterable;
import xerial.larray.LIterable$;
import xerial.larray.LIterator;
import xerial.larray.LIterator$;
import xerial.larray.LSeq;

public abstract class LIterable$class {
    public static LArray concat(LSeq $this, LSeq other) {
        LBuilder b = $this.newBuilder();
        b.sizeHint($this.size() + other.size());
        b.append($this);
        b.append(other);
        return b.result();
    }

    public static LArray $plus$plus(LSeq $this, LSeq other) {
        return $this.concat(other);
    }

    public static Object $div$colon(LSeq $this, Object z, Function2 op) {
        return $this.foldLeft(z, op);
    }

    public static Object $colon$bslash(LSeq $this, Object z, Function2 op) {
        return $this.foldRight(z, op);
    }

    public static LArray $colon$plus(LSeq $this, Object elem) {
        LBuilder b = $this.newBuilder();
        b.sizeHint($this.size() + 1L);
        b.append($this);
        b.append(elem);
        return b.result();
    }

    public static LArray $plus$colon(LSeq $this, Object elem) {
        LBuilder b = $this.newBuilder();
        b.sizeHint($this.size() + 1L);
        b.append(elem);
        b.append($this);
        return b.result();
    }

    public static Iterable ji(LSeq $this) {
        return new Iterable<A>($this){
            private final /* synthetic */ LSeq $outer;

            public Iterator<A> iterator() {
                return new Iterator<A>(this){
                    private long index;
                    private final /* synthetic */ LIterable$.anon.3 $outer;

                    private long index() {
                        return this.index;
                    }

                    private void index_$eq(long x$1) {
                        this.index = x$1;
                    }

                    public boolean hasNext() {
                        return this.index() < this.$outer.xerial$larray$LIterable$$anon$$$outer().size();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public A next() {
                        void var1_1;
                        A v = this.$outer.xerial$larray$LIterable$$anon$$$outer().apply(this.index());
                        this.index_$eq(this.index() + 1L);
                        return var1_1;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.index = 0L;
                    }
                };
            }

            public /* synthetic */ LSeq xerial$larray$LIterable$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public static LIterator iterator(LSeq $this) {
        return new AbstractLIterator<A>($this){
            private long index;
            private final /* synthetic */ LSeq $outer;

            private long index() {
                return this.index;
            }

            private void index_$eq(long x$1) {
                this.index = x$1;
            }

            public long size() {
                return this.$outer.size();
            }

            public boolean hasNext() {
                return this.index() < this.size();
            }

            /*
             * WARNING - void declaration
             */
            public A next() {
                void var1_1;
                A v = this.$outer.apply(this.index());
                this.index_$eq(this.index() + 1L);
                return var1_1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.index = 0L;
            }
        };
    }

    public static LIterator reverseIterator(LSeq $this) {
        return new AbstractLIterator<A>($this){
            private long i;
            private final /* synthetic */ LSeq $outer;

            private long i() {
                return this.i;
            }

            private void i_$eq(long x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                return 0L < this.i();
            }

            public A next() {
                Object object;
                if (0L < this.i()) {
                    this.i_$eq(this.i() - 1L);
                    object = this.$outer.apply(this.i());
                } else {
                    object = LIterator$.MODULE$.empty().next();
                }
                return (A)object;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i = $outer.size();
            }
        };
    }

    public static LIterator toIterator(LSeq $this) {
        return $this.iterator();
    }

    public static Object toArray(LSeq $this, ClassTag evidence$1) {
        ArrayBuilder b = Array$.MODULE$.newBuilder(evidence$1);
        $this.foreach(new Serializable($this, b){
            public static final long serialVersionUID = 0L;
            private final ArrayBuilder b$1;

            public final ArrayBuilder<A1> apply(A x$1) {
                return (ArrayBuilder)this.b$1.$plus$eq(x$1);
            }
            {
                this.b$1 = b$1;
            }
        });
        return b.result();
    }

    public static boolean isEmpty(LSeq $this) {
        return $this.size() == 0L;
    }

    public static LIterator collect(LSeq $this, PartialFunction pf) {
        return $this.iterator().collect(pf);
    }

    public static Option collectFirst(LSeq $this, PartialFunction pf) {
        NonLocalReturnControl nonLocalReturnControl2;
        block2: {
            Option option;
            Object object = new Object();
            try {
                $this.toIterator().foreach(new Serializable($this, object, pf){
                    public static final long serialVersionUID = 0L;
                    private final Object nonLocalReturnKey1$1;
                    private final PartialFunction pf$1;

                    public final void apply(A x) {
                        if (this.pf$1.isDefinedAt(x)) {
                            throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some(this.pf$1.apply(x)));
                        }
                    }
                    {
                        void var3_3;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        this.pf$1 = var3_3;
                    }
                });
                option = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block2;
                option = (Option)nonLocalReturnControl2.value();
            }
            return option;
        }
        throw nonLocalReturnControl2;
    }

    public static boolean contains(LSeq $this, Object elem) {
        return $this.exists(new Serializable($this, elem){
            public static final long serialVersionUID = 0L;
            private final Object elem$1;

            public final boolean apply(A x$2) {
                return BoxesRunTime.equals(x$2, (Object)this.elem$1);
            }
            {
                this.elem$1 = elem$1;
            }
        });
    }

    public static boolean exists(LSeq $this, Function1 p) {
        return $this.iterator().exists(p);
    }

    public static Option find(LSeq $this, Function1 p) {
        long i = $this.prefixLength(new Serializable($this, p){
            public static final long serialVersionUID = 0L;
            private final Function1 p$1;

            public final boolean apply(A x$3) {
                return !BoxesRunTime.unboxToBoolean((Object)this.p$1.apply(x$3));
            }
            {
                this.p$1 = p$1;
            }
        });
        return i < $this.length() ? new Some($this.apply(i)) : None$.MODULE$;
    }

    public static LIterator filter(LSeq $this, Function1 pred) {
        return $this.iterator().filter(pred);
    }

    public static LIterator filterNot(LSeq $this, Function1 pred) {
        return $this.iterator().filterNot(pred);
    }

    public static boolean forall(LSeq $this, Function1 p) {
        return $this.prefixLength(new Serializable($this, p){
            public static final long serialVersionUID = 0L;
            private final Function1 p$2;

            public final boolean apply(A x$4) {
                return BoxesRunTime.unboxToBoolean((Object)this.p$2.apply(x$4));
            }
            {
                this.p$2 = p$2;
            }
        }) == $this.length();
    }

    public static void foreach(LSeq $this, Function1 f) {
        long len = $this.size();
        for (long i = 0L; i < len; ++i) {
            f.apply($this.apply(i));
        }
    }

    public static long prefixLength(LSeq $this, Function1 p) {
        return $this.segmentLength(p, 0L);
    }

    public static long segmentLength(LSeq $this, Function1 p, long from) {
        long i;
        long len = $this.length();
        for (i = from; i < len && BoxesRunTime.unboxToBoolean((Object)p.apply($this.apply(i))); ++i) {
        }
        return i - from;
    }

    public static long length(LSeq $this) {
        return $this.size();
    }

    public static LIterator withFilter(LSeq $this, Function1 p) {
        return $this.iterator().filter(p);
    }

    public static LIterator map(LSeq $this, Function1 f) {
        return $this.iterator().map(f);
    }

    public static LIterator flatMap(LSeq $this, Function1 f) {
        return $this.iterator().flatMap(f);
    }

    public static LArray reverse(LSeq $this) {
        LBuilder b = $this.newBuilder();
        b.sizeHint($this.size());
        long i = $this.length();
        while (0L < i) {
            b.$plus$eq($this.apply(--i));
        }
        return b.result();
    }

    private static Object foldl(LSeq $this, long start, long end, Object z, Function2 op) {
        while (start != end) {
            Object object = op.apply(z, $this.apply(start));
            z = object;
            ++start;
        }
        return z;
    }

    private static Object foldr(LSeq $this, long start, long end, Object z, Function2 op) {
        while (start != end) {
            Object object = op.apply($this.apply(end - 1L), z);
            z = object;
            --end;
        }
        return z;
    }

    public static Object foldLeft(LSeq $this, Object z, Function2 op) {
        return LIterable$class.foldl($this, 0L, $this.length(), z, op);
    }

    public static Object foldRight(LSeq $this, Object z, Function2 op) {
        return LIterable$class.foldr($this, 0L, $this.length(), z, op);
    }

    public static Object reduceLeft(LSeq $this, Function2 op) {
        if ($this.length() > 0L) {
            return LIterable$class.foldl($this, 1L, $this.length(), $this.apply(0L), op);
        }
        throw new UnsupportedOperationException("empry.reduceLeft");
    }

    public static Object reduceRight(LSeq $this, Function2 op) {
        if ($this.length() > 0L) {
            return LIterable$class.foldr($this, 0L, $this.length() - 1L, $this.apply($this.length() - 1L), op);
        }
        throw new UnsupportedOperationException("empry.reduceRight");
    }

    public static Option reduceLeftOption(LSeq $this, Function2 op) {
        return $this.isEmpty() ? None$.MODULE$ : new Some($this.reduceLeft(op));
    }

    public static Option reduceRightOption(LSeq $this, Function2 op) {
        return $this.isEmpty() ? None$.MODULE$ : new Some($this.reduceRight(op));
    }

    public static Object reduce(LSeq $this, Function2 op) {
        return $this.reduceLeft(op);
    }

    public static Option reduceOption(LSeq $this, Function2 op) {
        return $this.reduceLeftOption(op);
    }

    public static Object fold(LSeq $this, Object z, Function2 op) {
        return $this.foldLeft(z, op);
    }

    public static Object aggregate(LSeq $this, Object z, Function2 seqop, Function2 combop) {
        return $this.foldLeft(z, seqop);
    }

    public static LIterator scanLeft(LSeq $this, Object z, Function2 op) {
        return $this.iterator().scanLeft(z, op);
    }

    private static long negLength(LSeq $this, long n) {
        return n >= $this.length() ? -1L : n;
    }

    public static long indexWhere(LSeq $this, Function1 p, long from) {
        long start = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(from)).max((Object)BoxesRunTime.boxToLong((long)0L)));
        return LIterable$class.negLength($this, start + $this.segmentLength(new Serializable($this, p){
            public static final long serialVersionUID = 0L;
            private final Function1 p$3;

            public final boolean apply(A x$5) {
                return !BoxesRunTime.unboxToBoolean((Object)this.p$3.apply(x$5));
            }
            {
                this.p$3 = p$3;
            }
        }, start));
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexWhere(LSeq $this, Function1 p, int end) {
        void var3_3;
        for (int i = end; i >= 0 && !BoxesRunTime.unboxToBoolean((Object)p.apply($this.apply(i))); --i) {
        }
        return (int)var3_3;
    }

    public static long indexOf(LSeq $this, Object elem) {
        return $this.iterator().indexOf(elem);
    }

    public static LArray slice(LSeq $this, long from) {
        return $this.slice(from, $this.size());
    }

    public static LArray slice(LSeq $this, long from, long until) {
        long lo = package$.MODULE$.max(from, 0L);
        long hi = package$.MODULE$.min(package$.MODULE$.max(until, 0L), $this.length());
        long elems = package$.MODULE$.max(hi - lo, 0L);
        LBuilder b = $this.newBuilder();
        b.sizeHint(elems);
        for (long i = lo; i < hi; ++i) {
            b.$plus$eq($this.apply(i));
        }
        return b.result();
    }

    public static Object head(LSeq $this) {
        if ($this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return $this.apply(0L);
    }

    public static LArray tail(LSeq $this) {
        if ($this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return $this.slice(1L, $this.size());
    }

    public static Object last(LSeq $this) {
        if ($this.length() > 0L) {
            return $this.apply($this.length() - 1L);
        }
        throw new NoSuchElementException();
    }

    public static LArray drop(LSeq $this, long n) {
        return $this.slice(n, $this.length());
    }

    public static LArray init(LSeq $this) {
        if ($this.length() > 0L) {
            return $this.slice(0L, $this.length() - 1L);
        }
        throw new UnsupportedOperationException("empty.init");
    }

    public static LArray take(LSeq $this, long n) {
        return $this.slice(0L, n);
    }

    public static LArray takeRight(LSeq $this, long n) {
        return $this.slice($this.length() - n, $this.length());
    }

    public static LArray takeWhile(LSeq $this, Function1 p) {
        return $this.take($this.prefixLength(p));
    }

    public static Tuple2 splitAt(LSeq $this, long n) {
        return new Tuple2($this.take(n), $this.drop(n));
    }

    public static LArray dropWhile(LSeq $this, Function1 p) {
        return $this.drop($this.prefixLength(p));
    }

    public static Tuple2 partition(LSeq $this, Function1 p) {
        return $this.iterator().partition(p);
    }

    public static Tuple2 span(LSeq $this, Function1 p) {
        LBuilder l = $this.newBuilder();
        LBuilder r = $this.newBuilder();
        BooleanRef toLeft = new BooleanRef(true);
        $this.foreach(new Serializable($this, l, r, toLeft, p){
            public static final long serialVersionUID = 0L;
            private final LBuilder l$1;
            private final LBuilder r$1;
            private final BooleanRef toLeft$1;
            private final Function1 p$4;

            public final LBuilder<A, LArray<A>> apply(A x) {
                this.toLeft$1.elem = this.toLeft$1.elem && BoxesRunTime.unboxToBoolean((Object)this.p$4.apply(x));
                return (this.toLeft$1.elem ? this.l$1 : this.r$1).$plus$eq(x);
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                this.l$1 = l$1;
                this.r$1 = var3_3;
                this.toLeft$1 = var4_4;
                this.p$4 = var5_5;
            }
        });
        return new Tuple2(l.result(), r.result());
    }

    public static void copyToArray(LSeq $this, Object xs, int start, int len) {
        long i = 0L;
        int j = start;
        long end = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper($this.length())).min((Object)BoxesRunTime.boxToLong((long)len))))).min((Object)BoxesRunTime.boxToLong((long)(ScalaRunTime$.MODULE$.array_length(xs) - start))));
        while (i < end) {
            ScalaRunTime$.MODULE$.array_update(xs, j, $this.apply(i));
            ++i;
            ++j;
        }
    }

    public static void copyToArray(LSeq $this, LArray xs, long start, long len) {
        long i = 0L;
        long j = start;
        long end = BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper($this.length())).min((Object)BoxesRunTime.boxToLong((long)len))))).min((Object)BoxesRunTime.boxToLong((long)(xs.length() - start))));
        while (i < end) {
            xs.update(j, $this.apply(i));
            ++i;
            ++j;
        }
    }

    public static boolean sameElements(LSeq $this, LIterable that) {
        return $this.iterator().sameElements(that.toIterator());
    }

    public static LIterator zipAll(LSeq $this, LIterable that, Object thisElem, Object thatElem) {
        return $this.iterator().zipAll(that.toIterator(), thisElem, thatElem);
    }

    public static LIterator zipWithIndex(LSeq $this) {
        return $this.iterator().zipWithIndex();
    }

    public static LIterator zip(LSeq $this, LIterable that) {
        return $this.iterator().zip(that.toIterator());
    }

    public static StringBuilder addString(LSeq $this, StringBuilder b, String start, String sep, String end) {
        return $this.iterator().addString(b, start, sep, end);
    }

    public static String mkString(LSeq $this, String start, String sep, String end) {
        return $this.addString(new StringBuilder(), start, sep, end).toString();
    }

    public static String mkString(LSeq $this, String sep) {
        return $this.mkString("", sep, "");
    }

    public static String mkString(LSeq $this) {
        return $this.mkString("");
    }

    public static LIterator sliding(LSeq $this, int size2) {
        return $this.sliding(size2, 1L);
    }

    public static LIterator sliding(LSeq $this, long size2, long step) {
        return new LIterable.SlidingIterator($this, size2, step);
    }

    public static void $init$(LSeq $this) {
    }
}

