/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray;

import java.nio.ByteBuffer;
import scala.Function0;
import scala.Function1;
import scala.Symbol;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import sun.nio.ch.DirectBuffer;
import xerial.core.log.LogLevel;
import xerial.core.log.LogWriter;
import xerial.core.log.Logger;
import xerial.larray.LArray;
import xerial.larray.LArray$;
import xerial.larray.LArrayBuilder$;
import xerial.larray.LBuilder;
import xerial.larray.LBuilder$class;
import xerial.larray.LByteArray;
import xerial.larray.LIterator;
import xerial.larray.LSeq;
import xerial.larray.UnsafeUtil$;
import xerial.larray.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005}d!B\u0001\u0003\u0003\u00039!!\u0004'BeJ\f\u0017PQ;jY\u0012,'O\u0003\u0002\u0004\t\u00051A.\u0019:sCfT\u0011!B\u0001\u0007q\u0016\u0014\u0018.\u00197\u0004\u0001U\u0019\u0001b\u0006\u0013\u0014\t\u0001I\u0011C\u000b\t\u0003\u0015=i\u0011a\u0003\u0006\u0003\u00195\tA\u0001\\1oO*\ta\"\u0001\u0003kCZ\f\u0017B\u0001\t\f\u0005\u0019y%M[3diB!!cE\u000b$\u001b\u0005\u0011\u0011B\u0001\u000b\u0003\u0005!a%)^5mI\u0016\u0014\bC\u0001\f\u0018\u0019\u0001!Q\u0001\u0007\u0001C\u0002e\u0011\u0011!Q\t\u00035\u0001\u0002\"a\u0007\u0010\u000e\u0003qQ\u0011!H\u0001\u0006g\u000e\fG.Y\u0005\u0003?q\u0011qAT8uQ&tw\r\u0005\u0002\u001cC%\u0011!\u0005\b\u0002\u0004\u0003:L\bC\u0001\f%\t\u0015)\u0003A1\u0001'\u0005\u0011\u0011V\r\u001d:\u0012\u0005i9\u0003c\u0001\n)+%\u0011\u0011F\u0001\u0002\u0007\u0019\u0006\u0013(/Y=\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013a\u00017pO*\u0011q\u0006B\u0001\u0005G>\u0014X-\u0003\u00022Y\t1Aj\\4hKJDQa\r\u0001\u0005\u0002Q\na\u0001P5oSRtD#A\u001b\u0011\tI\u0001Qc\t\u0005\no\u0001\u0001\r\u00111A\u0005\u0012a\nQ!\u001a7f[N,\u0012!\u000f\t\u0003%iJ!a\u000f\u0002\u0003\u00151\u0013\u0015\u0010^3BeJ\f\u0017\u0010C\u0005>\u0001\u0001\u0007\t\u0019!C\t}\u0005IQ\r\\3ng~#S-\u001d\u000b\u0003\u007f\t\u0003\"a\u0007!\n\u0005\u0005c\"\u0001B+oSRDqa\u0011\u001f\u0002\u0002\u0003\u0007\u0011(A\u0002yIEBa!\u0012\u0001!B\u0013I\u0014AB3mK6\u001c\b\u0005C\u0004H\u0001\u0001\u0007I\u0011\u0003%\u0002\u0011\r\f\u0007/Y2jif,\u0012!\u0013\t\u00037)K!a\u0013\u000f\u0003\t1{gn\u001a\u0005\b\u001b\u0002\u0001\r\u0011\"\u0005O\u00031\u0019\u0017\r]1dSRLx\fJ3r)\tyt\nC\u0004D\u0019\u0006\u0005\t\u0019A%\t\rE\u0003\u0001\u0015)\u0003J\u0003%\u0019\u0017\r]1dSRL\b\u0005C\u0004T\u0001\u0001\u0007I\u0011\u0003%\u0002\r\r,(o]8s\u0011\u001d)\u0006\u00011A\u0005\u0012Y\u000b!bY;sg>\u0014x\fJ3r)\tyt\u000bC\u0004D)\u0006\u0005\t\u0019A%\t\re\u0003\u0001\u0015)\u0003J\u0003\u001d\u0019WO]:pe\u0002BQa\u0017\u0001\u0005\u0012!\u000b\u0001B\\;n\u000b2,Wn\u001d\u0005\u0006;\u0002!\tAX\u0001\u0007CB\u0004XM\u001c3\u0015\tUzv\r\u001c\u0005\u0006Ar\u0003\r!Y\u0001\u0002EB\u00191D\u00193\n\u0005\rd\"!B!se\u0006L\bCA\u000ef\u0013\t1GD\u0001\u0003CsR,\u0007\"\u00025]\u0001\u0004I\u0017AB8gMN,G\u000f\u0005\u0002\u001cU&\u00111\u000e\b\u0002\u0004\u0013:$\b\"B7]\u0001\u0004I\u0017a\u00017f]\")Q\f\u0001C\u0001_R\u0011\u0001/]\u0007\u0002\u0001!)!O\u001ca\u0001g\u0006\u00191/Z9\u0011\u0007I!X#\u0003\u0002v\u0005\t!AjU3r\u0011\u00159\b\u0001\"\u0005y\u0003\u001di7.\u0011:sCf$\"!O=\t\u000bi4\b\u0019A%\u0002\tML'0\u001a\u0005\u0006y\u0002!\t!`\u0001\tg&TX\rS5oiR\u0011qH \u0005\u0006un\u0004\r!\u0013\u0005\b\u0003\u0003\u0001A\u0011CA\u0002\u0003))gn];sKNK'0\u001a\u000b\u0004\u007f\u0005\u0015\u0001\"\u0002>\u0000\u0001\u0004I\u0005bBA\u0005\u0001\u0011E\u00111B\u0001\u0007e\u0016\u001c\u0018N_3\u0015\u0007}\ni\u0001\u0003\u0004{\u0003\u000f\u0001\r!\u0013\u0005\b\u0003#\u0001A\u0011AA\n\u0003\u0015\u0019G.Z1s)\u0005y\u0004bBA\f\u0001\u0011\u0005\u0011\u0011D\u0001\u0006oJLG/\u001a\u000b\u0004S\u0006m\u0001\u0002CA\u000f\u0003+\u0001\r!a\b\u0002\u0007M\u00148\r\u0005\u0003\u0002\"\u0005\u001dRBAA\u0012\u0015\r\t)#D\u0001\u0004]&|\u0017\u0002BA\u0015\u0003G\u0011!BQ=uK\n+hMZ3s\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\ta![:Pa\u0016tGCAA\u0019!\rY\u00121G\u0005\u0004\u0003ka\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003s\u0001A\u0011AA\n\u0003\u0015\u0019Gn\\:f\u000f\u001d\tiD\u0001E\u0001\u0003\u007f\tQ\u0002T!se\u0006L()^5mI\u0016\u0014\bc\u0001\n\u0002B\u00191\u0011A\u0001E\u0001\u0003\u0007\u001ab!!\u0011\u0002F\u0005-\u0003cA\u000e\u0002H%\u0019\u0011\u0011\n\u000f\u0003\r\u0005s\u0017PU3g!\rY\u0012QJ\u0005\u0004\u0003\u001fb\"\u0001D*fe&\fG.\u001b>bE2,\u0007bB\u001a\u0002B\u0011\u0005\u00111\u000b\u000b\u0003\u0003\u007fA\u0001\"a\u0016\u0002B\u0011\u0005\u0011\u0011L\u0001\u0005[\u0006\\W-\u0006\u0003\u0002\\\u0005\rDCAA/)\u0011\ty&!\u001b\u0011\rI\u0019\u0012\u0011MA4!\r1\u00121\r\u0003\b\u0003K\n)F1\u0001\u001a\u0005\u0005!\u0006\u0003\u0002\n)\u0003CB!\"a\u001b\u0002V\u0005\u0005\t9AA7\u0003))g/\u001b3f]\u000e,GE\r\t\u0007\u0003_\n)(!\u0019\u000e\u0005\u0005E$bAA:9\u00059!/\u001a4mK\u000e$\u0018\u0002BA<\u0003c\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\u000b\u0003w\n\t%!A\u0005\n\u0005u\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\u0012!\u0003")
public abstract class LArrayBuilder<A, Repr extends LArray<A>>
implements LBuilder<A, Repr>,
Logger {
    private LByteArray elems;
    private long capacity;
    private long cursor;

    public static <T> LBuilder<T, LArray<T>> make(ClassTag<T> classTag) {
        return LArrayBuilder$.MODULE$.make(classTag);
    }

    public void log(LogLevel logLevel, Function0<Object> message) {
        Logger.class.log((Logger)this, (LogLevel)logLevel, message);
    }

    public LogWriter getLogger(Symbol tag) {
        return Logger.class.getLogger((Logger)this, (Symbol)tag);
    }

    public LogWriter getLogger(String tag) {
        return Logger.class.getLogger((Logger)this, (String)tag);
    }

    public <U> void log(String tag, Function1<LogWriter, U> f) {
        Logger.class.log((Logger)this, (String)tag, f);
    }

    public void fatal(Function0<Object> message) {
        Logger.class.fatal((Logger)this, message);
    }

    public void error(Function0<Object> message) {
        Logger.class.error((Logger)this, message);
    }

    public void warn(Function0<Object> message) {
        Logger.class.warn((Logger)this, message);
    }

    public void info(Function0<Object> message) {
        Logger.class.info((Logger)this, message);
    }

    public void debug(Function0<Object> message) {
        Logger.class.debug((Logger)this, message);
    }

    public void trace(Function0<Object> message) {
        Logger.class.trace((Logger)this, message);
    }

    @Override
    public LBuilder<A, Repr> append(A elem) {
        return LBuilder$class.append(this, elem);
    }

    @Override
    public LBuilder<A, Repr> $plus$plus$eq(TraversableOnce<A> xs) {
        return LBuilder$class.$plus$plus$eq((LBuilder)this, xs);
    }

    @Override
    public LBuilder<A, Repr> $plus$plus$eq(LIterator<A> xs) {
        return LBuilder$class.$plus$plus$eq((LBuilder)this, xs);
    }

    public LByteArray elems() {
        return this.elems;
    }

    public void elems_$eq(LByteArray x$1) {
        this.elems = x$1;
    }

    public long capacity() {
        return this.capacity;
    }

    public void capacity_$eq(long x$1) {
        this.capacity = x$1;
    }

    public long cursor() {
        return this.cursor;
    }

    public void cursor_$eq(long x$1) {
        this.cursor = x$1;
    }

    public long numElems() {
        return this.cursor() / this.elementSize();
    }

    public LArrayBuilder<A, Repr> append(byte[] b, int offset, int len) {
        long elemsToAdd = ((long)len + this.elementSize() - 1L) / this.elementSize();
        this.ensureSize(this.numElems() + elemsToAdd);
        this.elems().readFromArray(b, offset, this.cursor(), len);
        this.cursor_$eq(this.cursor() + (long)len);
        return this;
    }

    @Override
    public LArrayBuilder<A, Repr> append(LSeq<A> seq) {
        long n = seq.size();
        this.ensureSize(this.numElems() + n);
        seq.copyTo(this.elems(), this.cursor());
        this.cursor_$eq(this.cursor() + n * this.elementSize());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LByteArray mkArray(long size2) {
        void var3_2;
        LByteArray newArray = new LByteArray(size2 * this.elementSize(), package$.MODULE$.defaultAllocator());
        if (this.numElems() > 0L) {
            LArray$.MODULE$.copy(this.elems(), newArray);
            this.elems().free();
        }
        return var3_2;
    }

    @Override
    public void sizeHint(long size2) {
        if (this.capacity() < size2) {
            this.resize(size2);
        }
    }

    public void ensureSize(long size2) {
        long factor = 2L;
        if (this.capacity() < size2 || this.capacity() == 0L) {
            long newsize;
            long l = newsize = this.capacity() <= 1L ? 16L : this.capacity() * factor;
            while (newsize < size2) {
                newsize *= factor;
            }
            this.resize(newsize);
        }
    }

    public void resize(long size2) {
        this.elems_$eq(this.mkArray(size2));
        this.capacity_$eq(size2);
    }

    @Override
    public void clear() {
        if (this.numElems() > 0L) {
            this.elems().free();
        }
        this.capacity_$eq(0L);
        this.cursor_$eq(0L);
    }

    @Override
    public int write(ByteBuffer src) {
        int n;
        int len = scala.math.package$.MODULE$.max(src.limit() - src.position(), 0);
        long toAdd = ((long)len + this.elementSize() - 1L) / this.elementSize();
        this.ensureSize(this.numElems() + toAdd);
        ByteBuffer byteBuffer = src;
        if (byteBuffer instanceof DirectBuffer) {
            ByteBuffer byteBuffer2 = byteBuffer;
            UnsafeUtil$.MODULE$.unsafe().copyMemory(((DirectBuffer)((Object)byteBuffer2)).address() + (long)byteBuffer2.position(), this.elems().address() + this.cursor(), len);
            n = len;
        } else if (src.hasArray()) {
            n = this.elems().readFromArray(src.array(), src.position(), this.cursor(), len);
        } else {
            long c = this.cursor();
            for (long i = 0L; i < (long)len; ++i) {
                this.elems().putByte(c + i, src.get((int)((long)src.position() + i)));
            }
            n = len;
        }
        int writeLen = n;
        this.cursor_$eq(this.cursor() + (long)writeLen);
        src.position(src.position() + writeLen);
        return writeLen;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
        this.clear();
    }

    public LArrayBuilder() {
        LBuilder$class.$init$(this);
        Logger.class.$init$((Logger)this);
        this.capacity = 0L;
        this.cursor = 0L;
    }
}

