/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query.aggregation;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.AggregateFunctionPatterns;
import io.trino.plugin.base.expression.AggregateFunctionRule;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.Optional;
import java.util.Set;

public class ImplementMinMax
implements AggregateFunctionRule {
    private static final Capture<Variable> INPUT = Capture.newCapture();
    private static final Set<Type> SUPPORTED_INPUT_TYPES = ImmutableSet.of((Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE);

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().matching(Set.of("min", "max")::contains)).with(AggregateFunctionPatterns.singleInput().matching(AggregateFunctionPatterns.variable().with(AggregateFunctionPatterns.expressionType().matching(SUPPORTED_INPUT_TYPES::contains)).capturedAs(INPUT)));
    }

    public Optional<PinotColumnHandle> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        Variable input = (Variable)captures.get(INPUT);
        PinotColumnHandle columnHandle = (PinotColumnHandle)context.getAssignment(input.getName());
        Verify.verify((boolean)columnHandle.getDataType().equals(aggregateFunction.getOutputType()));
        return Optional.of(new PinotColumnHandle(String.format("%s(%s)", aggregateFunction.getFunctionName(), context.getIdentifierQuote().apply(columnHandle.getColumnName())), aggregateFunction.getOutputType()));
    }
}

