/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query.aggregation;

import com.google.common.base.Verify;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.plugin.base.expression.AggregateFunctionPatterns;
import io.trino.plugin.base.expression.AggregateFunctionRule;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.expression.Variable;
import io.trino.spi.type.BigintType;
import java.util.Optional;

public class ImplementCountDistinct
implements AggregateFunctionRule {
    private static final Capture<Variable> INPUT = Capture.newCapture();

    public Pattern<AggregateFunction> getPattern() {
        return AggregateFunctionPatterns.basicAggregation().with(AggregateFunctionPatterns.functionName().equalTo((Object)"count")).with(AggregateFunctionPatterns.outputType().equalTo((Object)BigintType.BIGINT)).with(AggregateFunctionPatterns.singleInput().matching(AggregateFunctionPatterns.variable().capturedAs(INPUT)));
    }

    public Optional<PinotColumnHandle> rewrite(AggregateFunction aggregateFunction, Captures captures, AggregateFunctionRule.RewriteContext context) {
        if (!PinotSessionProperties.isCountDistinctPushdownEnabled(context.getSession())) {
            return Optional.empty();
        }
        Variable input = (Variable)captures.get(INPUT);
        Verify.verify((aggregateFunction.getOutputType() == BigintType.BIGINT ? 1 : 0) != 0);
        return Optional.of(new PinotColumnHandle(String.format("distinctcount(%s)", context.getIdentifierQuote().apply(input.getName())), aggregateFunction.getOutputType(), false));
    }
}

