/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.base.Preconditions;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.OrderByExpression;
import io.trino.plugin.pinot.query.PinotQueryBuilder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class DynamicTablePqlExtractor {
    private DynamicTablePqlExtractor() {
    }

    public static String extractPql(DynamicTable table, TupleDomain<ColumnHandle> tupleDomain, List<PinotColumnHandle> columnHandles) {
        StringBuilder builder = new StringBuilder();
        builder.append("select ");
        if (!table.getSelections().isEmpty()) {
            builder.append(table.getSelections().stream().map(DynamicTablePqlExtractor::quoteIdentifier).collect(Collectors.joining(", ")));
        }
        if (!table.getGroupingColumns().isEmpty()) {
            builder.append(table.getGroupingColumns().stream().map(DynamicTablePqlExtractor::quoteIdentifier).collect(Collectors.joining(", ")));
            if (!table.getAggregateColumns().isEmpty()) {
                builder.append(", ");
            }
        }
        builder.append(table.getAggregateColumns().stream().map(PinotColumnHandle::getColumnName).collect(Collectors.joining(", ")));
        builder.append(" from ");
        builder.append(table.getTableName());
        builder.append(table.getSuffix().orElse(""));
        Optional<String> filter = DynamicTablePqlExtractor.getFilter(table.getFilter(), tupleDomain, columnHandles);
        if (filter.isPresent()) {
            builder.append(" where ").append(filter.get());
        }
        if (!table.getGroupingColumns().isEmpty()) {
            builder.append(" group by ");
            builder.append(table.getGroupingColumns().stream().map(DynamicTablePqlExtractor::quoteIdentifier).collect(Collectors.joining(", ")));
        }
        if (!table.getOrderBy().isEmpty()) {
            builder.append(" order by ").append(table.getOrderBy().stream().map(DynamicTablePqlExtractor::convertOrderByExpressionToPql).collect(Collectors.joining(", ")));
        }
        if (table.getLimit().isPresent()) {
            builder.append(" limit ").append(table.getLimit().getAsLong());
            if (!table.getSelections().isEmpty() && table.getOffset().isPresent()) {
                builder.append(", ").append(table.getOffset().getAsLong());
            }
        }
        return builder.toString();
    }

    private static Optional<String> getFilter(Optional<String> filter, TupleDomain<ColumnHandle> tupleDomain, List<PinotColumnHandle> columnHandles) {
        Optional<String> tupleFilter = PinotQueryBuilder.getFilterClause(tupleDomain, Optional.empty(), columnHandles);
        if (tupleFilter.isPresent() && filter.isPresent()) {
            return Optional.of(String.format("%s AND %s", DynamicTablePqlExtractor.encloseInParentheses(tupleFilter.get()), DynamicTablePqlExtractor.encloseInParentheses(filter.get())));
        }
        if (filter.isPresent()) {
            return filter;
        }
        if (tupleFilter.isPresent()) {
            return tupleFilter;
        }
        return Optional.empty();
    }

    private static String convertOrderByExpressionToPql(OrderByExpression orderByExpression) {
        Objects.requireNonNull(orderByExpression, "orderByExpression is null");
        StringBuilder builder = new StringBuilder().append(DynamicTablePqlExtractor.quoteIdentifier(orderByExpression.getColumn()));
        if (!orderByExpression.isAsc()) {
            builder.append(" desc");
        }
        return builder.toString();
    }

    public static String encloseInParentheses(String value) {
        return String.format("(%s)", value);
    }

    private static String quoteIdentifier(String identifier) {
        Preconditions.checkArgument((!identifier.contains("\"") ? 1 : 0) != 0, (String)"Identifier contains double quotes: '%s'", (Object)identifier);
        return String.format("\"%s\"", identifier);
    }
}

