/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.collect.ImmutableList;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotMetadata;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.FilterToPinotSqlConverter;
import io.trino.plugin.pinot.query.OrderByExpression;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.SelectionSort;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.query.request.context.utils.BrokerRequestToQueryContextConverter;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;

public final class DynamicTableBuilder {
    private static final CalciteSqlCompiler REQUEST_COMPILER = new CalciteSqlCompiler();
    private static final String WILDCARD = "*";
    public static final String OFFLINE_SUFFIX = "_OFFLINE";
    public static final String REALTIME_SUFFIX = "_REALTIME";

    private DynamicTableBuilder() {
    }

    public static DynamicTable buildFromPql(PinotMetadata pinotMetadata, SchemaTableName schemaTableName) {
        Objects.requireNonNull(pinotMetadata, "pinotMetadata is null");
        Objects.requireNonNull(schemaTableName, "schemaTableName is null");
        String query = schemaTableName.getTableName();
        BrokerRequest request = REQUEST_COMPILER.compileToBrokerRequest(query);
        String pinotTableName = DynamicTableBuilder.stripSuffix(request.getQuerySource().getTableName());
        Optional<String> suffix = DynamicTableBuilder.getSuffix(request.getQuerySource().getTableName());
        Map<String, ColumnHandle> columnHandles = pinotMetadata.getPinotColumnHandles(pinotTableName);
        Object selectionColumns = ImmutableList.of();
        ImmutableList orderBy = ImmutableList.of();
        if (request.getSelections() != null) {
            selectionColumns = DynamicTableBuilder.resolvePinotColumns(schemaTableName, request.getSelections().getSelectionColumns(), columnHandles);
            if (request.getSelections().getSelectionSortSequence() != null) {
                ImmutableList.Builder orderByBuilder = ImmutableList.builder();
                for (SelectionSort sortItem : request.getSelections().getSelectionSortSequence()) {
                    PinotColumnHandle columnHandle = (PinotColumnHandle)columnHandles.get(sortItem.getColumn());
                    if (columnHandle == null) {
                        throw new ColumnNotFoundException(schemaTableName, sortItem.getColumn());
                    }
                    orderByBuilder.add((Object)new OrderByExpression(columnHandle.getColumnName(), sortItem.isIsAsc()));
                }
                orderBy = orderByBuilder.build();
            }
        }
        Object groupByColumns = request.getGroupBy() == null ? ImmutableList.of() : DynamicTableBuilder.resolvePinotColumns(schemaTableName, request.getGroupBy().getExpressions(), columnHandles);
        Optional<String> filter = request.getFilterQuery() != null ? Optional.of(FilterToPinotSqlConverter.convertFilter(request.getPinotQuery(), columnHandles)) : Optional.empty();
        QueryContext queryContext = BrokerRequestToQueryContextConverter.convert((BrokerRequest)request);
        ImmutableList.Builder aggregateColumnsBuilder = ImmutableList.builder();
        if (request.getAggregationsInfo() != null) {
            for (AggregationFunction aggregationFunction : queryContext.getAggregationFunctions()) {
                aggregateColumnsBuilder.add((Object)new PinotColumnHandle(aggregationFunction.getResultColumnName(), DynamicTableBuilder.toTrinoType(aggregationFunction.getFinalResultColumnType())));
            }
        }
        return new DynamicTable(pinotTableName, suffix, (List<String>)selectionColumns, filter, (List<String>)groupByColumns, (List<PinotColumnHandle>)aggregateColumnsBuilder.build(), (List<OrderByExpression>)orderBy, DynamicTableBuilder.getTopNOrLimit(request), DynamicTableBuilder.getOffset(request), query);
    }

    private static Type toTrinoType(DataSchema.ColumnDataType columnDataType) {
        switch (columnDataType) {
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case BYTES: {
                return VarbinaryType.VARBINARY;
            }
            case INT_ARRAY: {
                return new ArrayType((Type)IntegerType.INTEGER);
            }
            case LONG_ARRAY: {
                return new ArrayType((Type)BigintType.BIGINT);
            }
            case DOUBLE_ARRAY: {
                return new ArrayType((Type)DoubleType.DOUBLE);
            }
            case STRING_ARRAY: {
                return new ArrayType((Type)VarcharType.VARCHAR);
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Unsupported column data type: " + columnDataType);
    }

    private static List<String> resolvePinotColumns(SchemaTableName schemaTableName, List<String> trinoColumnNames, Map<String, ColumnHandle> columnHandles) {
        ImmutableList.Builder pinotColumnNamesBuilder = ImmutableList.builder();
        for (String trinoColumnName : trinoColumnNames) {
            if (trinoColumnName.equals(WILDCARD)) {
                pinotColumnNamesBuilder.addAll((Iterable)columnHandles.values().stream().map(handle -> ((PinotColumnHandle)handle).getColumnName()).collect(ImmutableList.toImmutableList()));
                continue;
            }
            PinotColumnHandle columnHandle = (PinotColumnHandle)columnHandles.get(trinoColumnName);
            if (columnHandle == null) {
                throw new ColumnNotFoundException(schemaTableName, trinoColumnName);
            }
            pinotColumnNamesBuilder.add((Object)columnHandle.getColumnName());
        }
        return pinotColumnNamesBuilder.build();
    }

    private static OptionalLong getTopNOrLimit(BrokerRequest request) {
        if (request.getGroupBy() != null) {
            return OptionalLong.of(request.getGroupBy().getTopN());
        }
        if (request.getSelections() != null) {
            return OptionalLong.of(request.getSelections().getSize());
        }
        return OptionalLong.empty();
    }

    private static OptionalLong getOffset(BrokerRequest request) {
        if (request.getSelections() != null && request.getSelections().getOffset() > 0) {
            return OptionalLong.of(request.getSelections().getOffset());
        }
        return OptionalLong.empty();
    }

    private static String stripSuffix(String tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(OFFLINE_SUFFIX)) {
            return tableName.substring(0, tableName.length() - OFFLINE_SUFFIX.length());
        }
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(REALTIME_SUFFIX)) {
            return tableName.substring(0, tableName.length() - REALTIME_SUFFIX.length());
        }
        return tableName;
    }

    private static Optional<String> getSuffix(String tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(OFFLINE_SUFFIX)) {
            return Optional.of(OFFLINE_SUFFIX);
        }
        if (tableName.toUpperCase(Locale.ENGLISH).endsWith(REALTIME_SUFFIX)) {
            return Optional.of(REALTIME_SUFFIX);
        }
        return Optional.empty();
    }
}

