/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.query.OrderByExpression;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public final class DynamicTable {
    private final String tableName;
    private final Optional<String> suffix;
    private final List<String> selections;
    private final Optional<String> filter;
    private final List<String> groupingColumns;
    private final List<PinotColumnHandle> aggregateColumns;
    private final List<OrderByExpression> orderBy;
    private final OptionalLong limit;
    private final OptionalLong offset;
    private final String query;

    @JsonCreator
    public DynamicTable(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="suffix") Optional<String> suffix, @JsonProperty(value="selections") List<String> selections, @JsonProperty(value="filter") Optional<String> filter, @JsonProperty(value="groupingColumns") List<String> groupingColumns, @JsonProperty(value="aggregateColumns") List<PinotColumnHandle> aggregateColumns, @JsonProperty(value="orderBy") List<OrderByExpression> orderBy, @JsonProperty(value="limit") OptionalLong limit, @JsonProperty(value="offset") OptionalLong offset, @JsonProperty(value="query") String query) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.suffix = Objects.requireNonNull(suffix, "suffix is null");
        this.selections = ImmutableList.copyOf((Collection)Objects.requireNonNull(selections, "selections is null"));
        this.filter = Objects.requireNonNull(filter, "filter is null");
        this.groupingColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(groupingColumns, "groupingColumns is null"));
        this.aggregateColumns = ImmutableList.copyOf((Collection)Objects.requireNonNull(aggregateColumns, "aggregateColumns is null"));
        this.orderBy = ImmutableList.copyOf((Collection)Objects.requireNonNull(orderBy, "orderBy is null"));
        this.limit = Objects.requireNonNull(limit, "limit is null");
        this.offset = Objects.requireNonNull(offset, "offset is null");
        this.query = Objects.requireNonNull(query, "query is null");
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public Optional<String> getSuffix() {
        return this.suffix;
    }

    @JsonProperty
    public List<String> getSelections() {
        return this.selections;
    }

    @JsonProperty
    public Optional<String> getFilter() {
        return this.filter;
    }

    @JsonProperty
    public List<String> getGroupingColumns() {
        return this.groupingColumns;
    }

    @JsonProperty
    public List<PinotColumnHandle> getAggregateColumns() {
        return this.aggregateColumns;
    }

    @JsonProperty
    public List<OrderByExpression> getOrderBy() {
        return this.orderBy;
    }

    @JsonProperty
    public OptionalLong getLimit() {
        return this.limit;
    }

    @JsonProperty
    public OptionalLong getOffset() {
        return this.offset;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DynamicTable)) {
            return false;
        }
        DynamicTable that = (DynamicTable)other;
        return this.tableName.equals(that.tableName) && this.selections.equals(that.selections) && this.filter.equals(that.filter) && this.groupingColumns.equals(that.groupingColumns) && this.aggregateColumns.equals(that.aggregateColumns) && this.orderBy.equals(that.orderBy) && this.limit.equals(that.limit) && this.offset.equals(that.offset) && this.query.equals(that.query);
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.selections, this.filter, this.groupingColumns, this.aggregateColumns, this.orderBy, this.limit, this.offset, this.query);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("selections", this.selections).add("filter", this.filter).add("groupingColumns", this.groupingColumns).add("aggregateColumns", this.aggregateColumns).add("orderBy", this.orderBy).add("limit", (Object)this.limit).add("offset", (Object)this.offset).add("query", (Object)this.query).toString();
    }
}

