/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.decoders;

import com.google.common.base.Preconditions;
import io.trino.plugin.pinot.decoders.Decoder;
import io.trino.plugin.pinot.decoders.DecoderFactory;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class ArrayDecoder
implements Decoder {
    private final ArrayType type;
    private final Decoder elementDecoder;

    public ArrayDecoder(Type type) {
        Objects.requireNonNull(type, "type is null");
        Preconditions.checkState((boolean)(type instanceof ArrayType), (String)"Unexpected type %s", (Object)type);
        this.type = (ArrayType)type;
        this.elementDecoder = DecoderFactory.createDecoder(this.type.getElementType());
    }

    @Override
    public void decode(Supplier<Object> getter, BlockBuilder output) {
        List value = (List)getter.get();
        if (value == null) {
            output.appendNull();
        } else {
            BlockBuilder elementBlockBuilder = this.type.getElementType().createBlockBuilder(null, 1);
            int i = 0;
            while (i < value.size()) {
                int index = i++;
                this.elementDecoder.decode(() -> value.get(index), elementBlockBuilder);
            }
            this.type.writeObject(output, (Object)elementBlockBuilder.build());
        }
    }
}

