/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.client;

import com.yammer.metrics.core.MetricsRegistry;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.client.PinotHostMapper;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.inject.Inject;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.transport.AsyncQueryResponse;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerInstance;
import org.apache.pinot.core.transport.ServerResponse;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;
import org.apache.pinot.sql.parsers.SqlCompilationException;

public class PinotQueryClient {
    private static final CalciteSqlCompiler REQUEST_COMPILER = new CalciteSqlCompiler();
    private static final String TRINO_HOST_PREFIX = "trino-pinot-master";
    private static final String SERVER_INSTANCE_PREFIX = "Server";
    private final String trinoHostId;
    private final BrokerMetrics brokerMetrics;
    private final QueryRouter queryRouter;
    private final PinotHostMapper pinotHostMapper;
    private final AtomicLong requestIdGenerator = new AtomicLong();

    @Inject
    public PinotQueryClient(PinotHostMapper pinotHostMapper) {
        this.trinoHostId = PinotQueryClient.getDefaultTrinoId();
        this.pinotHostMapper = Objects.requireNonNull(pinotHostMapper, "pinotHostMapper is null");
        MetricsRegistry registry = new MetricsRegistry();
        this.brokerMetrics = new BrokerMetrics(registry);
        this.brokerMetrics.initializeGlobalMeters();
        this.queryRouter = new QueryRouter(this.trinoHostId, this.brokerMetrics);
    }

    private static String getDefaultTrinoId() {
        Object defaultBrokerId;
        try {
            defaultBrokerId = TRINO_HOST_PREFIX + InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            defaultBrokerId = TRINO_HOST_PREFIX;
        }
        return defaultBrokerId;
    }

    public Map<ServerInstance, DataTable> queryPinotServerForDataTable(String query, String serverHost, List<String> segments, long connectionTimeoutInMillis, int pinotRetryCount) {
        BrokerRequest brokerRequest;
        try {
            brokerRequest = REQUEST_COMPILER.compileToBrokerRequest(query);
        }
        catch (SqlCompilationException e) {
            throw new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.of(query), String.format("Parsing error with on %s, Error = %s", serverHost, e.getMessage()), e);
        }
        ServerInstance serverInstance = this.pinotHostMapper.getServerInstance(serverHost);
        HashMap<ServerInstance, ArrayList<String>> routingTable = new HashMap<ServerInstance, ArrayList<String>>();
        routingTable.put(serverInstance, new ArrayList<String>(segments));
        String tableName = brokerRequest.getQuerySource().getTableName();
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        HashMap<ServerInstance, ArrayList<String>> offlineRoutingTable = TableNameBuilder.isOfflineTableResource((String)tableName) ? routingTable : null;
        HashMap<ServerInstance, ArrayList<String>> realtimeRoutingTable = TableNameBuilder.isRealtimeTableResource((String)tableName) ? routingTable : null;
        BrokerRequest offlineBrokerRequest = TableNameBuilder.isOfflineTableResource((String)tableName) ? brokerRequest : null;
        BrokerRequest realtimeBrokerRequest = TableNameBuilder.isRealtimeTableResource((String)tableName) ? brokerRequest : null;
        AsyncQueryResponse asyncQueryResponse = this.doWithRetries(pinotRetryCount, requestId -> this.queryRouter.submitQuery(requestId.longValue(), rawTableName, offlineBrokerRequest, offlineRoutingTable, realtimeBrokerRequest, realtimeRoutingTable, connectionTimeoutInMillis));
        try {
            Map response = asyncQueryResponse.getResponse();
            HashMap<ServerInstance, DataTable> dataTableMap = new HashMap<ServerInstance, DataTable>();
            for (Map.Entry entry : response.entrySet()) {
                ServerResponse serverResponse = (ServerResponse)entry.getValue();
                DataTable dataTable = serverResponse.getDataTable();
                dataTableMap.put(PinotQueryClient.toServerInstance((ServerRoutingInstance)entry.getKey()), dataTable);
            }
            return dataTableMap;
        }
        catch (InterruptedException e) {
            throw new PinotException(PinotErrorCode.PINOT_EXCEPTION, Optional.of(query), "Pinot query execution was interrupted", e);
        }
    }

    private static ServerInstance toServerInstance(ServerRoutingInstance serverRoutingInstance) {
        return new ServerInstance(InstanceConfig.toInstanceConfig((String)String.format("%s_%s_%s", SERVER_INSTANCE_PREFIX, serverRoutingInstance.getHostname(), serverRoutingInstance.getPort())));
    }

    private <T> T doWithRetries(int retries, Function<Long, T> caller) {
        PinotException firstError = null;
        for (int i = 0; i < retries; ++i) {
            try {
                return caller.apply(this.requestIdGenerator.getAndIncrement());
            }
            catch (PinotException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (e.isRetryable()) continue;
                throw e;
            }
        }
        throw firstError;
    }
}

