/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.log.Logger;
import io.trino.plugin.base.expression.AggregateFunctionRewriter;
import io.trino.plugin.base.expression.AggregateFunctionRule;
import io.trino.plugin.pinot.ForPinot;
import io.trino.plugin.pinot.PinotColumn;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotConfig;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.plugin.pinot.PinotTableHandle;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.plugin.pinot.query.DynamicTable;
import io.trino.plugin.pinot.query.DynamicTableBuilder;
import io.trino.plugin.pinot.query.OrderByExpression;
import io.trino.plugin.pinot.query.aggregation.ImplementApproxDistinct;
import io.trino.plugin.pinot.query.aggregation.ImplementAvg;
import io.trino.plugin.pinot.query.aggregation.ImplementCountAll;
import io.trino.plugin.pinot.query.aggregation.ImplementCountDistinct;
import io.trino.plugin.pinot.query.aggregation.ImplementMinMax;
import io.trino.plugin.pinot.query.aggregation.ImplementSum;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.Assignment;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.expression.Variable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.inject.Inject;
import org.apache.pinot.spi.data.Schema;

public class PinotMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(PinotMetadata.class);
    private static final Object ALL_TABLES_CACHE_KEY = new Object();
    private static final String SCHEMA_NAME = "default";
    private static final String PINOT_COLUMN_NAME_PROPERTY = "pinotColumnName";
    private final LoadingCache<String, List<PinotColumn>> pinotTableColumnCache;
    private final LoadingCache<Object, List<String>> allTablesCache;
    private final int maxRowsPerBrokerQuery;
    private final AggregateFunctionRewriter aggregateFunctionRewriter;
    private final ImplementCountDistinct implementCountDistinct;

    @Inject
    public PinotMetadata(final PinotClient pinotClient, PinotConfig pinotConfig, @ForPinot Executor executor) {
        Objects.requireNonNull(pinotConfig, "pinot config");
        long metadataCacheExpiryMillis = pinotConfig.getMetadataCacheExpiry().roundTo(TimeUnit.MILLISECONDS);
        this.allTablesCache = CacheBuilder.newBuilder().refreshAfterWrite(metadataCacheExpiryMillis, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)CacheLoader.from(pinotClient::getAllTables), (Executor)executor));
        this.pinotTableColumnCache = CacheBuilder.newBuilder().refreshAfterWrite(metadataCacheExpiryMillis, TimeUnit.MILLISECONDS).build(CacheLoader.asyncReloading((CacheLoader)new CacheLoader<String, List<PinotColumn>>(){

            public List<PinotColumn> load(String tableName) throws Exception {
                Schema tablePinotSchema = pinotClient.getTableSchema(tableName);
                return PinotColumn.getPinotColumnsForPinotSchema(tablePinotSchema);
            }
        }, (Executor)executor));
        executor.execute(() -> this.allTablesCache.refresh(ALL_TABLES_CACHE_KEY));
        this.maxRowsPerBrokerQuery = pinotConfig.getMaxRowsForBrokerQueries();
        this.implementCountDistinct = new ImplementCountDistinct();
        this.aggregateFunctionRewriter = new AggregateFunctionRewriter(UnaryOperator.identity(), (Set)ImmutableSet.builder().add((Object)new ImplementCountAll()).add((Object)new ImplementAvg()).add((Object)new ImplementMinMax()).add((Object)new ImplementSum()).add((Object)new ImplementApproxDistinct()).add((Object)this.implementCountDistinct).build());
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)SCHEMA_NAME);
    }

    public PinotTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        if (tableName.getTableName().trim().startsWith("select ")) {
            DynamicTable dynamicTable = DynamicTableBuilder.buildFromPql(this, tableName);
            return new PinotTableHandle(tableName.getSchemaName(), dynamicTable.getTableName(), (TupleDomain<ColumnHandle>)TupleDomain.all(), OptionalLong.empty(), Optional.of(dynamicTable));
        }
        try {
            String pinotTableName = this.getPinotTableNameFromTrinoTableName(tableName.getTableName());
            return new PinotTableHandle(tableName.getSchemaName(), pinotTableName);
        }
        catch (TableNotFoundException e) {
            log.debug((Throwable)e, "Table not found: %s", new Object[]{tableName});
            return null;
        }
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)table;
        if (pinotTableHandle.getQuery().isPresent()) {
            PinotColumnHandle pinotColumnHandle;
            DynamicTable dynamicTable = pinotTableHandle.getQuery().get();
            Map<String, ColumnHandle> columnHandles = this.getColumnHandles(session, table);
            ImmutableList.Builder columnMetadataBuilder = ImmutableList.builder();
            for (String columnName : dynamicTable.getSelections()) {
                pinotColumnHandle = (PinotColumnHandle)columnHandles.get(columnName.toLowerCase(Locale.ENGLISH));
                columnMetadataBuilder.add((Object)pinotColumnHandle.getColumnMetadata());
            }
            for (String columnName : dynamicTable.getGroupingColumns()) {
                pinotColumnHandle = (PinotColumnHandle)columnHandles.get(columnName.toLowerCase(Locale.ENGLISH));
                columnMetadataBuilder.add((Object)pinotColumnHandle.getColumnMetadata());
            }
            dynamicTable.getAggregateColumns().forEach(handle -> columnMetadataBuilder.add((Object)handle.getColumnMetadata()));
            SchemaTableName schemaTableName = new SchemaTableName(pinotTableHandle.getSchemaName(), dynamicTable.getTableName());
            return new ConnectorTableMetadata(schemaTableName, (List)columnMetadataBuilder.build());
        }
        SchemaTableName tableName = new SchemaTableName(pinotTableHandle.getSchemaName(), pinotTableHandle.getTableName());
        return this.getTableMetadata(tableName);
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String table : this.getPinotTableNames()) {
            builder.add((Object)new SchemaTableName(SCHEMA_NAME, table));
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        PinotTableHandle pinotTableHandle = (PinotTableHandle)tableHandle;
        if (pinotTableHandle.getQuery().isPresent()) {
            return this.getDynamicTableColumnHandles(pinotTableHandle);
        }
        return this.getPinotColumnHandles(pinotTableHandle.getTableName());
    }

    public Map<String, ColumnHandle> getPinotColumnHandles(String tableName) {
        ImmutableMap.Builder columnHandlesBuilder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getColumnsMetadata(tableName)) {
            columnHandlesBuilder.put((Object)columnMetadata.getName(), (Object)new PinotColumnHandle(PinotMetadata.getPinotColumnName(columnMetadata), columnMetadata.getType()));
        }
        return columnHandlesBuilder.build();
    }

    private static String getPinotColumnName(ColumnMetadata columnMetadata) {
        Object pinotColumnName = Objects.requireNonNull(columnMetadata.getProperties().get(PINOT_COLUMN_NAME_PROPERTY), "Pinot column name is missing");
        return pinotColumnName.toString();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        for (SchemaTableName tableName : this.listTables(session, prefix)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((PinotColumnHandle)columnHandle).getColumnMetadata();
    }

    public Optional<Object> getInfo(ConnectorTableHandle table) {
        return Optional.empty();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        return new ConnectorTableProperties();
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        PinotTableHandle handle = (PinotTableHandle)table;
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        Optional<DynamicTable> dynamicTable = handle.getQuery();
        if (dynamicTable.isPresent() && (dynamicTable.get().getLimit().isEmpty() || dynamicTable.get().getLimit().getAsLong() > limit)) {
            dynamicTable = Optional.of(new DynamicTable(dynamicTable.get().getTableName(), dynamicTable.get().getSuffix(), dynamicTable.get().getSelections(), dynamicTable.get().getFilter(), dynamicTable.get().getGroupingColumns(), dynamicTable.get().getAggregateColumns(), dynamicTable.get().getOrderBy(), OptionalLong.of(limit), dynamicTable.get().getOffset(), dynamicTable.get().getQuery()));
        }
        handle = new PinotTableHandle(handle.getSchemaName(), handle.getTableName(), handle.getConstraint(), OptionalLong.of(limit), dynamicTable);
        boolean singleSplit = dynamicTable.isPresent();
        return Optional.of(new LimitApplicationResult((Object)handle, singleSplit, false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain remainingFilter;
        PinotTableHandle handle = (PinotTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (newDomain.isNone()) {
            remainingFilter = TupleDomain.all();
        } else {
            Map domains = (Map)newDomain.getDomains().orElseThrow();
            HashMap<ColumnHandle, Domain> supported = new HashMap<ColumnHandle, Domain>();
            HashMap<ColumnHandle, Domain> unsupported = new HashMap<ColumnHandle, Domain>();
            for (Map.Entry entry : domains.entrySet()) {
                if (((PinotColumnHandle)entry.getKey()).getDataType() instanceof ArrayType) {
                    unsupported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
                    continue;
                }
                supported.put((ColumnHandle)entry.getKey(), (Domain)entry.getValue());
            }
            newDomain = TupleDomain.withColumnDomains(supported);
            remainingFilter = TupleDomain.withColumnDomains(unsupported);
        }
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        handle = new PinotTableHandle(handle.getSchemaName(), handle.getTableName(), (TupleDomain<ColumnHandle>)newDomain, handle.getLimit(), handle.getQuery());
        return Optional.of(new ConstraintApplicationResult((Object)handle, remainingFilter, false));
    }

    public Optional<AggregationApplicationResult<ConnectorTableHandle>> applyAggregation(ConnectorSession session, ConnectorTableHandle handle, List<AggregateFunction> aggregates, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        if (!PinotSessionProperties.isAggregationPushdownEnabled(session)) {
            return Optional.empty();
        }
        Verify.verify((!groupingSets.isEmpty() ? 1 : 0) != 0, (String)"No grouping sets provided", (Object[])new Object[0]);
        if (groupingSets.size() != 1) {
            return Optional.empty();
        }
        PinotTableHandle tableHandle = (PinotTableHandle)handle;
        if (tableHandle.getQuery().isPresent() && !tableHandle.getQuery().get().getAggregateColumns().isEmpty()) {
            return Optional.empty();
        }
        ImmutableList.Builder projections = ImmutableList.builder();
        ImmutableList.Builder resultAssignments = ImmutableList.builder();
        ImmutableList.Builder aggregationExpressions = ImmutableList.builder();
        for (AggregateFunction aggregate : aggregates) {
            Optional<PinotColumnHandle> rewriteResult = this.aggregateFunctionRewriter.rewrite(session, aggregate, assignments);
            if ((rewriteResult = this.applyCountDistinct(session, aggregate, assignments, tableHandle, rewriteResult)).isEmpty()) {
                return Optional.empty();
            }
            PinotColumnHandle pinotColumnHandle = rewriteResult.get();
            aggregationExpressions.add((Object)pinotColumnHandle);
            projections.add((Object)new Variable(pinotColumnHandle.getColumnName(), pinotColumnHandle.getDataType()));
            resultAssignments.add((Object)new Assignment(pinotColumnHandle.getColumnName(), (ColumnHandle)pinotColumnHandle, pinotColumnHandle.getDataType()));
        }
        List groupingColumns = (List)((List)Iterables.getOnlyElement(groupingSets)).stream().map(PinotColumnHandle.class::cast).map(PinotColumnHandle::getColumnName).collect(ImmutableList.toImmutableList());
        OptionalLong limitForDynamicTable = OptionalLong.empty();
        if (tableHandle.getLimit().isEmpty() && !groupingColumns.isEmpty()) {
            limitForDynamicTable = OptionalLong.of(this.maxRowsPerBrokerQuery + 1);
        }
        DynamicTable dynamicTable = new DynamicTable(tableHandle.getTableName(), Optional.empty(), (List<String>)ImmutableList.of(), tableHandle.getQuery().flatMap(DynamicTable::getFilter), groupingColumns, (List<PinotColumnHandle>)aggregationExpressions.build(), (List<OrderByExpression>)ImmutableList.of(), limitForDynamicTable, OptionalLong.empty(), "");
        tableHandle = new PinotTableHandle(tableHandle.getSchemaName(), tableHandle.getTableName(), tableHandle.getConstraint(), tableHandle.getLimit(), Optional.of(dynamicTable));
        return Optional.of(new AggregationApplicationResult((Object)tableHandle, (List)projections.build(), (List)resultAssignments.build(), (Map)ImmutableMap.of(), false));
    }

    private Optional<PinotColumnHandle> applyCountDistinct(final ConnectorSession session, AggregateFunction aggregate, final Map<String, ColumnHandle> assignments, PinotTableHandle tableHandle, Optional<PinotColumnHandle> rewriteResult) {
        AggregateFunctionRule.RewriteContext context = new AggregateFunctionRule.RewriteContext(){

            public Map<String, ColumnHandle> getAssignments() {
                return assignments;
            }

            public Function<String, String> getIdentifierQuote() {
                return UnaryOperator.identity();
            }

            public ConnectorSession getSession() {
                return session;
            }
        };
        if (this.implementCountDistinct.getPattern().matches((Object)aggregate, (Object)context)) {
            Variable input = (Variable)Iterables.getOnlyElement((Iterable)aggregate.getInputs());
            if (tableHandle.getQuery().isEmpty() || !tableHandle.getQuery().get().getGroupingColumns().contains(input.getName())) {
                return Optional.empty();
            }
        }
        return rewriteResult;
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    @VisibleForTesting
    public List<PinotColumn> getPinotColumns(String tableName) {
        String pinotTableName = this.getPinotTableNameFromTrinoTableName(tableName);
        return PinotMetadata.getFromCache(this.pinotTableColumnCache, pinotTableName);
    }

    private List<String> getPinotTableNames() {
        return PinotMetadata.getFromCache(this.allTablesCache, ALL_TABLES_CACHE_KEY);
    }

    private static <K, V> V getFromCache(LoadingCache<K, V> cache, K key) {
        Object value = cache.getIfPresent(key);
        if (value != null) {
            return (V)value;
        }
        try {
            return (V)cache.get(key);
        }
        catch (ExecutionException e) {
            throw new PinotException(PinotErrorCode.PINOT_UNCLASSIFIED_ERROR, Optional.empty(), "Cannot fetch from cache " + key, e.getCause());
        }
    }

    private String getPinotTableNameFromTrinoTableName(String trinoTableName) {
        List<String> allTables = this.getPinotTableNames();
        String pinotTableName = null;
        for (String candidate : allTables) {
            if (!trinoTableName.equalsIgnoreCase(candidate)) continue;
            pinotTableName = candidate;
            break;
        }
        if (pinotTableName == null) {
            throw new TableNotFoundException(new SchemaTableName(SCHEMA_NAME, trinoTableName));
        }
        return pinotTableName;
    }

    private Map<String, ColumnHandle> getDynamicTableColumnHandles(PinotTableHandle pinotTableHandle) {
        PinotColumnHandle columnHandle;
        Preconditions.checkState((boolean)pinotTableHandle.getQuery().isPresent(), (Object)"dynamic table not present");
        String schemaName = pinotTableHandle.getSchemaName();
        DynamicTable dynamicTable = pinotTableHandle.getQuery().get();
        Map<String, ColumnHandle> columnHandles = this.getPinotColumnHandles(dynamicTable.getTableName());
        ImmutableMap.Builder columnHandlesBuilder = ImmutableMap.builder();
        for (String columnName : dynamicTable.getSelections()) {
            columnHandle = (PinotColumnHandle)columnHandles.get(columnName.toLowerCase(Locale.ENGLISH));
            if (columnHandle == null) {
                throw new ColumnNotFoundException(new SchemaTableName(schemaName, dynamicTable.getTableName()), columnName);
            }
            columnHandlesBuilder.put((Object)columnName.toLowerCase(Locale.ENGLISH), (Object)columnHandle);
        }
        for (String columnName : dynamicTable.getGroupingColumns()) {
            columnHandle = (PinotColumnHandle)columnHandles.get(columnName.toLowerCase(Locale.ENGLISH));
            if (columnHandle == null) {
                throw new ColumnNotFoundException(new SchemaTableName(schemaName, dynamicTable.getTableName()), columnName);
            }
            columnHandlesBuilder.put((Object)columnName.toLowerCase(Locale.ENGLISH), (Object)columnHandle);
        }
        dynamicTable.getAggregateColumns().forEach(handle -> columnHandlesBuilder.put((Object)handle.getColumnName().toLowerCase(Locale.ENGLISH), handle));
        return columnHandlesBuilder.build();
    }

    private ConnectorTableMetadata getTableMetadata(SchemaTableName tableName) {
        return new ConnectorTableMetadata(tableName, this.getColumnsMetadata(tableName.getTableName()));
    }

    private List<ColumnMetadata> getColumnsMetadata(String tableName) {
        List<PinotColumn> columns = this.getPinotColumns(tableName);
        return (List)columns.stream().map(PinotMetadata::createPinotColumnMetadata).collect(ImmutableList.toImmutableList());
    }

    private static ColumnMetadata createPinotColumnMetadata(PinotColumn pinotColumn) {
        return ColumnMetadata.builder().setName(pinotColumn.getName().toLowerCase(Locale.ENGLISH)).setType(pinotColumn.getType()).setProperties((Map)ImmutableMap.builder().put((Object)PINOT_COLUMN_NAME_PROPERTY, (Object)pinotColumn.getName()).build()).build();
    }

    private List<SchemaTableName> listTables(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchema().isEmpty() || prefix.getTable().isEmpty()) {
            return this.listTables(session, Optional.empty());
        }
        return ImmutableList.of((Object)new SchemaTableName((String)prefix.getSchema().get(), (String)prefix.getTable().get()));
    }
}

