/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.query.PinotQuery;
import java.util.Optional;

public class PinotInsufficientServerResponseException
extends PinotException {
    public PinotInsufficientServerResponseException(PinotQuery query, int numberOfServersResponded, int numberOfServersQueried) {
        this(query, String.format("Only %s out of %s servers responded for query %s", numberOfServersResponded, numberOfServersQueried, query.getQuery()));
    }

    public PinotInsufficientServerResponseException(PinotQuery query, String message) {
        super(PinotErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE, Optional.of(query.getQuery()), message, true);
    }

    public PinotInsufficientServerResponseException(String message) {
        super(PinotErrorCode.PINOT_INSUFFICIENT_SERVER_RESPONSE, Optional.empty(), message, true);
    }
}

