/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;

public class PinotColumnHandle
implements ColumnHandle {
    private final String columnName;
    private final Type dataType;
    private final boolean returnNullOnEmptyGroup;

    public PinotColumnHandle(String columnName, Type dataType) {
        this(columnName, dataType, true);
    }

    @JsonCreator
    public PinotColumnHandle(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="dataType") Type dataType, @JsonProperty(value="returnNullOnEmptyGroup") boolean returnNullOnEmptyGroup) {
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.dataType = Objects.requireNonNull(dataType, "dataType is null");
        this.returnNullOnEmptyGroup = returnNullOnEmptyGroup;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Type getDataType() {
        return this.dataType;
    }

    public ColumnMetadata getColumnMetadata() {
        return new ColumnMetadata(this.getColumnName(), this.getDataType());
    }

    @JsonProperty
    public boolean isReturnNullOnEmptyGroup() {
        return this.returnNullOnEmptyGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PinotColumnHandle that = (PinotColumnHandle)o;
        return Objects.equals(this.getColumnName(), that.getColumnName());
    }

    public int hashCode() {
        return Objects.hash(this.columnName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnName", (Object)this.columnName).add("dataType", (Object)this.dataType).add("returnNullOnEmptyGroup", this.returnNullOnEmptyGroup).toString();
    }
}

