/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class PinotColumn {
    private final String name;
    private final Type type;

    @JsonCreator
    public PinotColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") Type type) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is null or is empty");
        this.name = name;
        this.type = Objects.requireNonNull(type, "type is null");
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PinotColumn other = (PinotColumn)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.type, other.type);
    }

    public String toString() {
        return this.name + ":" + this.type;
    }

    public static List<PinotColumn> getPinotColumnsForPinotSchema(Schema pinotTableSchema) {
        return (List)pinotTableSchema.getColumnNames().stream().filter(columnName -> !columnName.startsWith("$")).map(columnName -> new PinotColumn((String)columnName, PinotColumn.getTrinoTypeFromPinotType(pinotTableSchema.getFieldSpecFor(columnName)))).collect(ImmutableList.toImmutableList());
    }

    public static Type getTrinoTypeFromPinotType(FieldSpec field) {
        Type type = PinotColumn.getTrinoTypeFromPinotType(field.getDataType());
        if (field.isSingleValueField()) {
            return type;
        }
        return new ArrayType(type);
    }

    public static Type getTrinoTypeFromPinotType(FieldSpec.DataType dataType) {
        switch (dataType) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case INT: {
                return IntegerType.INTEGER;
            }
            case LONG: {
                return BigintType.BIGINT;
            }
            case STRING: {
                return VarcharType.VARCHAR;
            }
            case BYTES: {
                return VarbinaryType.VARBINARY;
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_UNSUPPORTED_COLUMN_TYPE, Optional.empty(), "Unsupported type conversion for pinot data type: " + dataType);
    }
}

