/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils.builder;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.spi.config.table.CompletionConfig;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.IngestionConfig;
import org.apache.pinot.spi.config.table.QueryConfig;
import org.apache.pinot.spi.config.table.QuotaConfig;
import org.apache.pinot.spi.config.table.ReplicaGroupStrategyConfig;
import org.apache.pinot.spi.config.table.RoutingConfig;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableCustomConfig;
import org.apache.pinot.spi.config.table.TableTaskConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.TagOverrideConfig;
import org.apache.pinot.spi.config.table.TenantConfig;
import org.apache.pinot.spi.config.table.TierConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.config.table.assignment.InstanceAssignmentConfig;
import org.apache.pinot.spi.config.table.assignment.InstancePartitionsType;

public class TableConfigBuilder {
    private static final String DEFAULT_SEGMENT_PUSH_TYPE = "APPEND";
    private static final String REFRESH_SEGMENT_PUSH_TYPE = "REFRESH";
    private static final String DEFAULT_SEGMENT_ASSIGNMENT_STRATEGY = "BalanceNumSegmentAssignmentStrategy";
    private static final String DEFAULT_NUM_REPLICAS = "1";
    private static final String DEFAULT_LOAD_MODE = "HEAP";
    private static final String MMAP_LOAD_MODE = "MMAP";
    private final TableType _tableType;
    private String _tableName;
    private boolean _isLLC;
    private String _schemaName;
    private String _numReplicas = "1";
    private String _timeColumnName;
    private String _timeType;
    private String _retentionTimeUnit;
    private String _retentionTimeValue;
    private String _segmentPushFrequency;
    private String _segmentPushType = "APPEND";
    private String _segmentAssignmentStrategy = "BalanceNumSegmentAssignmentStrategy";
    private String _peerSegmentDownloadScheme;
    private ReplicaGroupStrategyConfig _replicaGroupStrategyConfig;
    private CompletionConfig _completionConfig;
    private String _crypterClassName;
    private String _brokerTenant;
    private String _serverTenant;
    private TagOverrideConfig _tagOverrideConfig;
    private String _loadMode = "HEAP";
    private String _segmentVersion;
    private String _sortedColumn;
    private List<String> _invertedIndexColumns;
    private boolean _createInvertedIndexDuringSegmentGeneration;
    private List<String> _noDictionaryColumns;
    private List<String> _onHeapDictionaryColumns;
    private List<String> _bloomFilterColumns;
    private List<String> _rangeIndexColumns;
    private Map<String, String> _streamConfigs;
    private SegmentPartitionConfig _segmentPartitionConfig;
    private boolean _nullHandlingEnabled;
    private List<String> _varLengthDictionaryColumns;
    private List<StarTreeIndexConfig> _starTreeIndexConfigs;
    private TableCustomConfig _customConfig;
    private QuotaConfig _quotaConfig;
    private TableTaskConfig _taskConfig;
    private RoutingConfig _routingConfig;
    private QueryConfig _queryConfig;
    private Map<InstancePartitionsType, InstanceAssignmentConfig> _instanceAssignmentConfigMap;
    private List<FieldConfig> _fieldConfigList;
    private UpsertConfig _upsertConfig;
    private IngestionConfig _ingestionConfig;
    private List<TierConfig> _tierConfigList;

    public TableConfigBuilder(TableType tableType) {
        this._tableType = tableType;
    }

    public TableConfigBuilder setTableName(String tableName) {
        this._tableName = tableName;
        return this;
    }

    public TableConfigBuilder setLLC(boolean isLLC) {
        Preconditions.checkState((this._tableType == TableType.REALTIME ? 1 : 0) != 0);
        this._isLLC = isLLC;
        return this;
    }

    public TableConfigBuilder setSchemaName(String schemaName) {
        this._schemaName = schemaName;
        return this;
    }

    public TableConfigBuilder setNumReplicas(int numReplicas) {
        Preconditions.checkArgument((numReplicas > 0 ? 1 : 0) != 0);
        this._numReplicas = String.valueOf(numReplicas);
        return this;
    }

    public TableConfigBuilder setTimeColumnName(String timeColumnName) {
        this._timeColumnName = timeColumnName;
        return this;
    }

    public TableConfigBuilder setTimeType(String timeType) {
        this._timeType = timeType;
        return this;
    }

    public TableConfigBuilder setRetentionTimeUnit(String retentionTimeUnit) {
        this._retentionTimeUnit = retentionTimeUnit;
        return this;
    }

    public TableConfigBuilder setRetentionTimeValue(String retentionTimeValue) {
        this._retentionTimeValue = retentionTimeValue;
        return this;
    }

    public TableConfigBuilder setSegmentPushType(String segmentPushType) {
        this._segmentPushType = REFRESH_SEGMENT_PUSH_TYPE.equalsIgnoreCase(segmentPushType) ? REFRESH_SEGMENT_PUSH_TYPE : DEFAULT_SEGMENT_PUSH_TYPE;
        return this;
    }

    public TableConfigBuilder setSegmentPushFrequency(String segmentPushFrequency) {
        this._segmentPushFrequency = segmentPushFrequency;
        return this;
    }

    public TableConfigBuilder setSegmentAssignmentStrategy(String segmentAssignmentStrategy) {
        this._segmentAssignmentStrategy = segmentAssignmentStrategy;
        return this;
    }

    public TableConfigBuilder setReplicaGroupStrategyConfig(ReplicaGroupStrategyConfig replicaGroupStrategyConfig) {
        this._replicaGroupStrategyConfig = replicaGroupStrategyConfig;
        return this;
    }

    public TableConfigBuilder setCompletionConfig(CompletionConfig completionConfig) {
        this._completionConfig = completionConfig;
        return this;
    }

    public TableConfigBuilder setCrypterClassName(String crypterClassName) {
        this._crypterClassName = crypterClassName;
        return this;
    }

    public TableConfigBuilder setBrokerTenant(String brokerTenant) {
        this._brokerTenant = brokerTenant;
        return this;
    }

    public TableConfigBuilder setServerTenant(String serverTenant) {
        this._serverTenant = serverTenant;
        return this;
    }

    public TableConfigBuilder setTagOverrideConfig(TagOverrideConfig tagOverrideConfig) {
        this._tagOverrideConfig = tagOverrideConfig;
        return this;
    }

    public TableConfigBuilder setLoadMode(String loadMode) {
        this._loadMode = MMAP_LOAD_MODE.equalsIgnoreCase(loadMode) ? MMAP_LOAD_MODE : DEFAULT_LOAD_MODE;
        return this;
    }

    public TableConfigBuilder setSegmentVersion(String segmentVersion) {
        this._segmentVersion = segmentVersion;
        return this;
    }

    public TableConfigBuilder setSortedColumn(String sortedColumn) {
        this._sortedColumn = sortedColumn;
        return this;
    }

    public TableConfigBuilder setInvertedIndexColumns(List<String> invertedIndexColumns) {
        this._invertedIndexColumns = invertedIndexColumns;
        return this;
    }

    public TableConfigBuilder setCreateInvertedIndexDuringSegmentGeneration(boolean createInvertedIndexDuringSegmentGeneration) {
        this._createInvertedIndexDuringSegmentGeneration = createInvertedIndexDuringSegmentGeneration;
        return this;
    }

    public TableConfigBuilder setNoDictionaryColumns(List<String> noDictionaryColumns) {
        this._noDictionaryColumns = noDictionaryColumns;
        return this;
    }

    public TableConfigBuilder setOnHeapDictionaryColumns(List<String> onHeapDictionaryColumns) {
        this._onHeapDictionaryColumns = onHeapDictionaryColumns;
        return this;
    }

    public TableConfigBuilder setBloomFilterColumns(List<String> bloomFilterColumns) {
        this._bloomFilterColumns = bloomFilterColumns;
        return this;
    }

    public TableConfigBuilder setRangeIndexColumns(List<String> rangeIndexColumns) {
        this._rangeIndexColumns = rangeIndexColumns;
        return this;
    }

    public TableConfigBuilder setVarLengthDictionaryColumns(List<String> varLengthDictionaryColumns) {
        this._varLengthDictionaryColumns = varLengthDictionaryColumns;
        return this;
    }

    public TableConfigBuilder setStarTreeIndexConfigs(List<StarTreeIndexConfig> starTreeIndexConfigs) {
        this._starTreeIndexConfigs = starTreeIndexConfigs;
        return this;
    }

    public TableConfigBuilder setStreamConfigs(Map<String, String> streamConfigs) {
        Preconditions.checkState((this._tableType == TableType.REALTIME ? 1 : 0) != 0);
        this._streamConfigs = streamConfigs;
        return this;
    }

    public TableConfigBuilder setSegmentPartitionConfig(SegmentPartitionConfig segmentPartitionConfig) {
        this._segmentPartitionConfig = segmentPartitionConfig;
        return this;
    }

    public TableConfigBuilder setNullHandlingEnabled(boolean nullHandlingEnabled) {
        this._nullHandlingEnabled = nullHandlingEnabled;
        return this;
    }

    public TableConfigBuilder setCustomConfig(TableCustomConfig customConfig) {
        this._customConfig = customConfig;
        return this;
    }

    public TableConfigBuilder setQuotaConfig(QuotaConfig quotaConfig) {
        this._quotaConfig = quotaConfig;
        return this;
    }

    public TableConfigBuilder setTaskConfig(TableTaskConfig taskConfig) {
        this._taskConfig = taskConfig;
        return this;
    }

    public TableConfigBuilder setRoutingConfig(RoutingConfig routingConfig) {
        this._routingConfig = routingConfig;
        return this;
    }

    public TableConfigBuilder setQueryConfig(QueryConfig queryConfig) {
        this._queryConfig = queryConfig;
        return this;
    }

    public TableConfigBuilder setInstanceAssignmentConfigMap(Map<InstancePartitionsType, InstanceAssignmentConfig> instanceAssignmentConfigMap) {
        this._instanceAssignmentConfigMap = instanceAssignmentConfigMap;
        return this;
    }

    public TableConfigBuilder setFieldConfigList(List<FieldConfig> fieldConfigList) {
        this._fieldConfigList = fieldConfigList;
        return this;
    }

    public TableConfigBuilder setUpsertConfig(UpsertConfig upsertConfig) {
        this._upsertConfig = upsertConfig;
        return this;
    }

    public TableConfigBuilder setPeerSegmentDownloadScheme(String peerSegmentDownloadScheme) {
        this._peerSegmentDownloadScheme = peerSegmentDownloadScheme;
        return this;
    }

    public TableConfigBuilder setIngestionConfig(IngestionConfig ingestionConfig) {
        this._ingestionConfig = ingestionConfig;
        return this;
    }

    public TableConfigBuilder setTierConfigList(List<TierConfig> tierConfigList) {
        this._tierConfigList = tierConfigList;
        return this;
    }

    public TableConfig build() {
        SegmentsValidationAndRetentionConfig validationConfig = new SegmentsValidationAndRetentionConfig();
        validationConfig.setTimeColumnName(this._timeColumnName);
        validationConfig.setTimeType(this._timeType);
        validationConfig.setRetentionTimeUnit(this._retentionTimeUnit);
        validationConfig.setRetentionTimeValue(this._retentionTimeValue);
        validationConfig.setSegmentPushFrequency(this._segmentPushFrequency);
        validationConfig.setSegmentPushType(this._segmentPushType);
        validationConfig.setSegmentAssignmentStrategy(this._segmentAssignmentStrategy);
        validationConfig.setReplicaGroupStrategyConfig(this._replicaGroupStrategyConfig);
        validationConfig.setCompletionConfig(this._completionConfig);
        validationConfig.setSchemaName(this._schemaName);
        validationConfig.setReplication(this._numReplicas);
        validationConfig.setPeerSegmentDownloadScheme(this._peerSegmentDownloadScheme);
        if (this._isLLC) {
            validationConfig.setReplicasPerPartition(this._numReplicas);
        }
        validationConfig.setCrypterClassName(this._crypterClassName);
        TenantConfig tenantConfig = new TenantConfig(this._brokerTenant, this._serverTenant, this._tagOverrideConfig);
        IndexingConfig indexingConfig = new IndexingConfig();
        indexingConfig.setLoadMode(this._loadMode);
        indexingConfig.setSegmentFormatVersion(this._segmentVersion);
        if (this._sortedColumn != null) {
            indexingConfig.setSortedColumn(Collections.singletonList(this._sortedColumn));
        }
        indexingConfig.setInvertedIndexColumns(this._invertedIndexColumns);
        indexingConfig.setCreateInvertedIndexDuringSegmentGeneration(this._createInvertedIndexDuringSegmentGeneration);
        indexingConfig.setNoDictionaryColumns(this._noDictionaryColumns);
        indexingConfig.setOnHeapDictionaryColumns(this._onHeapDictionaryColumns);
        indexingConfig.setBloomFilterColumns(this._bloomFilterColumns);
        indexingConfig.setRangeIndexColumns(this._rangeIndexColumns);
        indexingConfig.setStreamConfigs(this._streamConfigs);
        indexingConfig.setSegmentPartitionConfig(this._segmentPartitionConfig);
        indexingConfig.setNullHandlingEnabled(this._nullHandlingEnabled);
        indexingConfig.setVarLengthDictionaryColumns(this._varLengthDictionaryColumns);
        indexingConfig.setStarTreeIndexConfigs(this._starTreeIndexConfigs);
        if (this._customConfig == null) {
            this._customConfig = new TableCustomConfig(null);
        }
        return new TableConfig(this._tableName, this._tableType.toString(), validationConfig, tenantConfig, indexingConfig, this._customConfig, this._quotaConfig, this._taskConfig, this._routingConfig, this._queryConfig, this._instanceAssignmentConfigMap, this._fieldConfigList, this._upsertConfig, this._ingestionConfig, this._tierConfigList);
    }
}

