/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class TimeUtils {
    public static final long VALID_MIN_TIME_MILLIS = new DateTime(1971, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC).getMillis();
    public static final long VALID_MAX_TIME_MILLIS = new DateTime(2071, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC).getMillis();
    public static final Interval VALID_TIME_INTERVAL = new Interval(VALID_MIN_TIME_MILLIS, VALID_MAX_TIME_MILLIS, DateTimeZone.UTC);
    private static final String UPPER_CASE_DAYS = "DAYS";
    private static final String UPPER_CASE_DAYS_SINCE_EPOCH = "DAYSSINCEEPOCH";
    private static final String UPPER_CASE_HOURS = "HOURS";
    private static final String UPPER_CASE_HOURS_SINCE_EPOCH = "HOURSSINCEEPOCH";
    private static final String UPPER_CASE_MINUTES = "MINUTES";
    private static final String UPPER_CASE_MINUTES_SINCE_EPOCH = "MINUTESSINCEEPOCH";
    private static final String UPPER_CASE_SECONDS = "SECONDS";
    private static final String UPPER_CASE_SECONDS_SINCE_EPOCH = "SECONDSSINCEEPOCH";
    private static final String UPPER_CASE_MILLISECONDS = "MILLISECONDS";
    private static final String UPPER_CASE_MILLIS_SINCE_EPOCH = "MILLISSINCEEPOCH";
    private static final String UPPER_CASE_MILLISECONDS_SINCE_EPOCH = "MILLISECONDSSINCEEPOCH";
    private static final String UPPER_CASE_MICROSECONDS = "MICROSECONDS";
    private static final String UPPER_CASE_MICROS_SINCE_EPOCH = "MICROSSINCEEPOCH";
    private static final String UPPER_CASE_MICROSECONDS_SINCE_EPOCH = "MICROSECONDSSINCEEPOCH";
    private static final String UPPER_CASE_NANOSECONDS = "NANOSECONDS";
    private static final String UPPER_CASE_NANOS_SINCE_EPOCH = "NANOSSINCEEPOCH";
    private static final String UPPER_CASE_NANOSECONDS_SINCE_EPOCH = "NANOSECONDSSINCEEPOCH";
    private static final PeriodFormatter PERIOD_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendHours().appendSuffix("h").appendMinutes().appendSuffix("m").appendSeconds().appendSuffix("s").toFormatter();

    @Nullable
    public static TimeUnit timeUnitFromString(@Nullable String timeUnitString) {
        if (timeUnitString == null || timeUnitString.isEmpty()) {
            return null;
        }
        switch (timeUnitString.toUpperCase()) {
            case "DAYS": 
            case "DAYSSINCEEPOCH": {
                return TimeUnit.DAYS;
            }
            case "HOURS": 
            case "HOURSSINCEEPOCH": {
                return TimeUnit.HOURS;
            }
            case "MINUTES": 
            case "MINUTESSINCEEPOCH": {
                return TimeUnit.MINUTES;
            }
            case "SECONDS": 
            case "SECONDSSINCEEPOCH": {
                return TimeUnit.SECONDS;
            }
            case "MILLISECONDS": 
            case "MILLISSINCEEPOCH": 
            case "MILLISECONDSSINCEEPOCH": {
                return TimeUnit.MILLISECONDS;
            }
            case "MICROSECONDS": 
            case "MICROSSINCEEPOCH": 
            case "MICROSECONDSSINCEEPOCH": {
                return TimeUnit.MICROSECONDS;
            }
            case "NANOSECONDS": 
            case "NANOSSINCEEPOCH": 
            case "NANOSECONDSSINCEEPOCH": {
                return TimeUnit.NANOSECONDS;
            }
        }
        throw new IllegalArgumentException("Unsupported time unit: " + timeUnitString);
    }

    public static boolean timeValueInValidRange(long timeValueInMillis) {
        return timeValueInMillis >= VALID_MIN_TIME_MILLIS && timeValueInMillis <= VALID_MAX_TIME_MILLIS;
    }

    public static boolean isValidTimeInterval(Interval timeInterval) {
        return timeInterval.getStartMillis() >= VALID_MIN_TIME_MILLIS && timeInterval.getEndMillis() <= VALID_MAX_TIME_MILLIS;
    }

    public static long getValidMinTimeMillis() {
        return VALID_MIN_TIME_MILLIS;
    }

    public static long getValidMaxTimeMillis() {
        return VALID_MAX_TIME_MILLIS;
    }

    public static Long convertPeriodToMillis(String timeStr) {
        Long millis = 0L;
        if (timeStr != null) {
            try {
                Period p = PERIOD_FORMATTER.parsePeriod(timeStr);
                millis = p.toStandardDuration().getStandardSeconds() * 1000L;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid time spec '" + timeStr + "' (Valid examples: '3h', '4h30m')", e);
            }
        }
        return millis;
    }

    public static String convertMillisToPeriod(Long millis) {
        String periodStr = null;
        if (millis != null) {
            Period p = new Period((Object)new Duration((Object)millis));
            periodStr = PERIOD_FORMATTER.print((ReadablePeriod)p);
        }
        return periodStr;
    }

    public static boolean isPeriodValid(String timeStr) {
        try {
            PERIOD_FORMATTER.parsePeriod(timeStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

