/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.FieldSpec;

public class JsonUtils {
    private static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    public static final ObjectReader DEFAULT_READER = DEFAULT_MAPPER.reader();
    public static final ObjectWriter DEFAULT_WRITER = DEFAULT_MAPPER.writer();
    public static final ObjectWriter DEFAULT_PRETTY_WRITER = DEFAULT_MAPPER.writerWithDefaultPrettyPrinter();

    private JsonUtils() {
    }

    public static <T> T stringToObject(String jsonString, Class<T> valueType) throws IOException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonString);
    }

    public static <T> T stringToObject(String jsonString, TypeReference<T> valueTypeRef) throws IOException {
        return (T)DEFAULT_READER.forType(valueTypeRef).readValue(jsonString);
    }

    public static JsonNode stringToJsonNode(String jsonString) throws IOException {
        return DEFAULT_READER.readTree(jsonString);
    }

    public static <T> T fileToObject(File jsonFile, Class<T> valueType) throws IOException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonFile);
    }

    public static <T> List<T> fileToList(File jsonFile, Class<T> valueType) throws IOException {
        return (List)DEFAULT_READER.forType((JavaType)DEFAULT_MAPPER.getTypeFactory().constructCollectionType(List.class, valueType)).readValue(jsonFile);
    }

    public static JsonNode fileToJsonNode(File jsonFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(jsonFile);){
            JsonNode jsonNode = DEFAULT_READER.readTree((InputStream)inputStream);
            return jsonNode;
        }
    }

    public static <T> T inputStreamToObject(InputStream jsonInputStream, Class<T> valueType) throws IOException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonInputStream);
    }

    public static JsonNode inputStreamToJsonNode(InputStream jsonInputStream) throws IOException {
        return DEFAULT_READER.readTree(jsonInputStream);
    }

    public static <T> T bytesToObject(byte[] jsonBytes, Class<T> valueType) throws IOException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonBytes);
    }

    public static JsonNode bytesToJsonNode(byte[] jsonBytes) throws IOException {
        return DEFAULT_READER.readTree((InputStream)new ByteArrayInputStream(jsonBytes));
    }

    public static <T> T jsonNodeToObject(JsonNode jsonNode, Class<T> valueType) throws IOException {
        return (T)DEFAULT_READER.forType(valueType).readValue(jsonNode);
    }

    public static <T> T jsonNodeToObject(JsonNode jsonNode, TypeReference<T> valueTypeRef) throws IOException {
        return (T)DEFAULT_READER.forType(valueTypeRef).readValue(jsonNode);
    }

    public static String objectToString(Object object) throws JsonProcessingException {
        return DEFAULT_WRITER.writeValueAsString(object);
    }

    public static String objectToPrettyString(Object object) throws JsonProcessingException {
        return DEFAULT_PRETTY_WRITER.writeValueAsString(object);
    }

    public static byte[] objectToBytes(Object object) throws JsonProcessingException {
        return DEFAULT_WRITER.writeValueAsBytes(object);
    }

    public static JsonNode objectToJsonNode(Object object) {
        return DEFAULT_MAPPER.valueToTree(object);
    }

    public static ObjectNode newObjectNode() {
        return JsonNodeFactory.instance.objectNode();
    }

    public static ArrayNode newArrayNode() {
        return JsonNodeFactory.instance.arrayNode();
    }

    public static Object extractValue(@Nullable JsonNode jsonValue, FieldSpec fieldSpec) {
        if (fieldSpec.isSingleValueField()) {
            if (jsonValue != null && !jsonValue.isNull()) {
                return JsonUtils.extractSingleValue(jsonValue, fieldSpec.getDataType());
            }
            return null;
        }
        if (jsonValue != null && !jsonValue.isNull()) {
            if (jsonValue.isArray()) {
                int numValues = jsonValue.size();
                if (numValues != 0) {
                    Object[] values = new Object[numValues];
                    for (int i = 0; i < numValues; ++i) {
                        values[i] = JsonUtils.extractSingleValue(jsonValue.get(i), fieldSpec.getDataType());
                    }
                    return values;
                }
                return null;
            }
            return new Object[]{JsonUtils.extractSingleValue(jsonValue, fieldSpec.getDataType())};
        }
        return null;
    }

    private static Object extractSingleValue(JsonNode jsonValue, FieldSpec.DataType dataType) {
        Preconditions.checkArgument((boolean)jsonValue.isValueNode());
        switch (dataType) {
            case INT: {
                return jsonValue.asInt();
            }
            case LONG: {
                return jsonValue.asLong();
            }
            case FLOAT: {
                return Float.valueOf((float)jsonValue.asDouble());
            }
            case DOUBLE: {
                return jsonValue.asDouble();
            }
            case STRING: {
                return jsonValue.asText();
            }
            case BYTES: {
                try {
                    return jsonValue.binaryValue();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to extract binary value");
                }
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported data type %s", new Object[]{dataType}));
    }
}

