/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.google.common.base.Preconditions;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataSizeUtils {
    private static final Pattern DATA_SIZE_PATTERN = Pattern.compile("^(\\d+(\\.\\d+)?)([KMGTP])?(B)?$", 2);
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.##");
    private static double KB_IN_BYTES = 1024.0;
    private static double MB_IN_BYTES = KB_IN_BYTES * 1024.0;
    private static double GB_IN_BYTES = MB_IN_BYTES * 1024.0;
    private static double TB_IN_BYTES = GB_IN_BYTES * 1024.0;
    private static double PB_IN_BYTES = TB_IN_BYTES * 1024.0;

    private DataSizeUtils() {
    }

    public static long toBytes(String dataSizeString) {
        Matcher matcher = DATA_SIZE_PATTERN.matcher(dataSizeString);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Illegal data size: %s", (Object)dataSizeString);
        double value = Double.parseDouble(matcher.group(1));
        String unit = matcher.group(3);
        if (unit != null) {
            switch (unit.toUpperCase()) {
                case "K": {
                    return (long)(value * KB_IN_BYTES);
                }
                case "M": {
                    return (long)(value * MB_IN_BYTES);
                }
                case "G": {
                    return (long)(value * GB_IN_BYTES);
                }
                case "T": {
                    return (long)(value * TB_IN_BYTES);
                }
                case "P": {
                    return (long)(value * PB_IN_BYTES);
                }
            }
            throw new IllegalStateException();
        }
        return (long)value;
    }

    public static String fromBytes(long dataSizeInBytes) {
        if ((double)dataSizeInBytes < KB_IN_BYTES) {
            return dataSizeInBytes + "B";
        }
        if ((double)dataSizeInBytes < MB_IN_BYTES) {
            return DECIMAL_FORMAT.format((double)dataSizeInBytes / KB_IN_BYTES) + "K";
        }
        if ((double)dataSizeInBytes < GB_IN_BYTES) {
            return DECIMAL_FORMAT.format((double)dataSizeInBytes / MB_IN_BYTES) + "M";
        }
        if ((double)dataSizeInBytes < TB_IN_BYTES) {
            return DECIMAL_FORMAT.format((double)dataSizeInBytes / GB_IN_BYTES) + "G";
        }
        if ((double)dataSizeInBytes < PB_IN_BYTES) {
            return DECIMAL_FORMAT.format((double)dataSizeInBytes / TB_IN_BYTES) + "T";
        }
        return DECIMAL_FORMAT.format((double)dataSizeInBytes / PB_IN_BYTES) + "P";
    }
}

