/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.pinot.spi.utils.BytesUtils;

public class ByteArray
implements Comparable<ByteArray> {
    private final byte[] _bytes;

    public ByteArray(byte[] bytes) {
        this._bytes = bytes;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public int length() {
        return this._bytes.length;
    }

    public String toHexString() {
        return BytesUtils.toHexString(this._bytes);
    }

    public String toString() {
        return this.toHexString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArray bytes = (ByteArray)o;
        return Arrays.equals(this._bytes, bytes._bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this._bytes);
    }

    @Override
    public int compareTo(@Nonnull ByteArray that) {
        if (this == that) {
            return 0;
        }
        return ByteArray.compare(this._bytes, that._bytes);
    }

    public static int compare(byte[] bytes1, byte[] bytes2) {
        int len1 = bytes1.length;
        int len2 = bytes2.length;
        int lim = Math.min(len1, len2);
        for (int k = 0; k < lim; ++k) {
            int bi;
            int ai = Byte.toUnsignedInt(bytes1[k]);
            if (ai == (bi = Byte.toUnsignedInt(bytes2[k]))) continue;
            return ai - bi;
        }
        return len1 - len2;
    }
}

