/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.plugin;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.spi.plugin.Plugin;
import org.apache.pinot.spi.plugin.PluginClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    public static final String PLUGINS_DIR_PROPERTY_NAME = "plugins.dir";
    public static final String PLUGINS_INCLUDE_PROPERTY_NAME = "plugins.include";
    public static final String DEFAULT_PLUGIN_NAME = "DEFAULT";
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private static final String JAR_FILE_EXTENSION = "jar";
    private static PluginManager PLUGIN_MANAGER = new PluginManager();
    private static final Map<String, String> PLUGINS_BACKWARD_COMPATIBLE_CLASS_NAME_MAP = new HashMap<String, String>(){
        {
            this.put("org.apache.pinot.core.realtime.stream.SimpleAvroMessageDecoder", "org.apache.pinot.plugin.inputformat.avro.SimpleAvroMessageDecoder");
            this.put("org.apache.pinot.core.realtime.impl.kafka.KafkaAvroMessageDecoder", "org.apache.pinot.plugin.inputformat.avro.KafkaAvroMessageDecoder");
            this.put("org.apache.pinot.core.realtime.impl.kafka.KafkaJSONMessageDecoder", "org.apache.pinot.plugin.stream.kafka.KafkaJSONMessageDecoder");
            this.put("org.apache.pinot.core.data.readers.AvroRecordReader", "org.apache.pinot.plugin.inputformat.avro.AvroRecordReader");
            this.put("org.apache.pinot.core.data.readers.CSVRecordReader", "org.apache.pinot.plugin.inputformat.csv.CSVRecordReader");
            this.put("org.apache.pinot.core.data.readers.JSONRecordReader", "org.apache.pinot.plugin.inputformat.json.JSONRecordReader");
            this.put("org.apache.pinot.plugin.inputformat.json.JsonRecordReader", "org.apache.pinot.plugin.inputformat.json.JSONRecordReader");
            this.put("org.apache.pinot.orc.data.readers.ORCRecordReader", "org.apache.pinot.plugin.inputformat.orc.ORCRecordReader");
            this.put("org.apache.pinot.plugin.inputformat.orc.OrcRecordReader", "org.apache.pinot.plugin.inputformat.orc.ORCRecordReader");
            this.put("org.apache.pinot.parquet.data.readers.ParquetRecordReader", "org.apache.pinot.plugin.inputformat.parquet.ParquetRecordReader");
            this.put("org.apache.pinot.core.data.readers.ThriftRecordReader", "org.apache.pinot.plugin.inputformat.thrift.ThriftRecordReader");
            this.put("org.apache.pinot.filesystem.AzurePinotFS", "org.apache.pinot.plugin.filesystem.AzurePinotFS");
            this.put("org.apache.pinot.filesystem.HadoopPinotFS", "org.apache.pinot.plugin.filesystem.HadoopPinotFS");
            this.put("org.apache.pinot.filesystem.LocalPinotFS", "org.apache.pinot.spi.filesystem.LocalPinotFS");
            this.put("org.apache.pinot.core.realtime.impl.kafka.KafkaConsumerFactory", "org.apache.pinot.plugin.stream.kafka09.KafkaConsumerFactory");
            this.put("org.apache.pinot.core.realtime.impl.kafka2.KafkaConsumerFactory", "org.apache.pinot.plugin.stream.kafka20.KafkaConsumerFactory");
        }
    };
    private Map<Plugin, PluginClassLoader> _registry = new HashMap<Plugin, PluginClassLoader>();
    private String _pluginsRootDir;
    private String _pluginsInclude;
    private boolean _initialized = false;

    private PluginManager() {
        this._registry.put(new Plugin(DEFAULT_PLUGIN_NAME), this.createClassLoader(Collections.emptyList()));
        this.init();
    }

    public synchronized void init() {
        if (this._initialized) {
            return;
        }
        try {
            this._pluginsRootDir = System.getProperty(PLUGINS_DIR_PROPERTY_NAME);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load env variable {}", (Object)PLUGINS_DIR_PROPERTY_NAME, (Object)e);
            this._pluginsRootDir = null;
        }
        try {
            this._pluginsInclude = System.getProperty(PLUGINS_INCLUDE_PROPERTY_NAME);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load env variable {}", (Object)PLUGINS_INCLUDE_PROPERTY_NAME, (Object)e);
            this._pluginsInclude = null;
        }
        this.init(this._pluginsRootDir, this._pluginsInclude);
        this._initialized = true;
    }

    private void init(String pluginsRootDir, String pluginsInclude) {
        if (StringUtils.isEmpty((String)pluginsRootDir)) {
            LOGGER.info("Env variable '{}' is not specified. Set this env variable to load additional plugins.", (Object)PLUGINS_DIR_PROPERTY_NAME);
            return;
        }
        if (!new File(pluginsRootDir).exists()) {
            LOGGER.warn("Plugins root dir [{}] doesn't exist.", (Object)pluginsRootDir);
            return;
        }
        LOGGER.info("Plugins root dir is [{}]", (Object)pluginsRootDir);
        Collection jarFiles = FileUtils.listFiles((File)new File(pluginsRootDir), (String[])new String[]{JAR_FILE_EXTENSION}, (boolean)true);
        List<String> pluginsToLoad = null;
        if (!StringUtils.isEmpty((String)pluginsInclude)) {
            pluginsToLoad = Arrays.asList(pluginsInclude.split(","));
            LOGGER.info("Trying to load plugins: [{}]", (Object)Arrays.toString(pluginsToLoad.toArray()));
        } else {
            LOGGER.info("Loading all plugins. Please use env variable '{}' to customize.", (Object)PLUGINS_INCLUDE_PROPERTY_NAME, (Object)Arrays.toString(jarFiles.toArray()));
        }
        for (File jarFile : jarFiles) {
            File pluginDir = jarFile.getParentFile();
            String pluginName = pluginDir.getName();
            if (pluginsToLoad != null && !pluginsToLoad.contains(pluginName)) continue;
            try {
                this.load(pluginName, pluginDir);
                LOGGER.info("Successfully Loaded plugin [{}] from dir [{}]", (Object)pluginName, (Object)pluginDir);
            }
            catch (Exception e) {
                LOGGER.error("Failed to load plugin [{}] from dir [{}]", new Object[]{pluginName, pluginDir, e});
            }
        }
    }

    public void load(String pluginName, File directory) {
        LOGGER.info("Trying to load plugin [{}] from location [{}]", (Object)pluginName, (Object)directory);
        Collection jarFiles = FileUtils.listFiles((File)directory, (String[])new String[]{JAR_FILE_EXTENSION}, (boolean)true);
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (File jarFile : jarFiles) {
            try {
                urlList.add(jarFile.toURI().toURL());
                LOGGER.info("Successfully loaded plugin [{}] from jar file [{}]", (Object)pluginName, (Object)jarFile);
            }
            catch (MalformedURLException e) {
                LOGGER.error("Unable to load plugin [{}] jar file [{}]", new Object[]{pluginName, jarFile, e});
            }
        }
        PluginClassLoader classLoader = this.createClassLoader(urlList);
        this._registry.put(new Plugin(pluginName), classLoader);
    }

    private PluginClassLoader createClassLoader(Collection<URL> urlList) {
        Object[] urls = new URL[urlList.size()];
        urlList.toArray(urls);
        Arrays.sort(urls);
        return new PluginClassLoader((URL[])urls, this.getClass().getClassLoader());
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        String pluginName = DEFAULT_PLUGIN_NAME;
        String realClassName = className;
        if (className.indexOf(":") > -1) {
            String[] split = className.split("\\:");
            pluginName = split[0];
            realClassName = split[1];
        }
        return this.loadClass(pluginName, realClassName);
    }

    public Class<?> loadClass(String pluginName, String className) throws ClassNotFoundException {
        return this._registry.get(new Plugin(pluginName)).loadClass(PluginManager.loadClassWithBackwardCompatibleCheck(className), true);
    }

    public static String loadClassWithBackwardCompatibleCheck(String className) {
        return PLUGINS_BACKWARD_COMPATIBLE_CLASS_NAME_MAP.getOrDefault(className, className);
    }

    public <T> T createInstance(String className) throws Exception {
        return this.createInstance(className, new Class[0], new Object[0]);
    }

    public <T> T createInstance(String className, Class[] argTypes, Object[] argValues) throws Exception {
        String pluginName = DEFAULT_PLUGIN_NAME;
        String realClassName = className;
        if (className.indexOf(":") > -1) {
            String[] split = className.split("\\:");
            pluginName = split[0];
            realClassName = split[1];
        }
        return this.createInstance(pluginName, realClassName, argTypes, argValues);
    }

    public <T> T createInstance(String pluginName, String className) throws Exception {
        return this.createInstance(pluginName, className, new Class[0], new Object[0]);
    }

    public <T> T createInstance(String pluginName, String className, Class[] argTypes, Object[] argValues) throws Exception {
        PluginClassLoader pluginClassLoader = PluginManager.PLUGIN_MANAGER._registry.get(new Plugin(pluginName));
        Class<?> loadedClass = pluginClassLoader.loadClass(PluginManager.loadClassWithBackwardCompatibleCheck(className), true);
        Constructor<?> constructor = loadedClass.getConstructor(argTypes);
        Object instance = constructor.newInstance(argValues);
        return (T)instance;
    }

    public String getPluginsRootDir() {
        return this._pluginsRootDir;
    }

    public static PluginManager get() {
        return PLUGIN_MANAGER;
    }
}

