/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.plugin;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class PluginClassLoader
extends URLClassLoader {
    private final ClassLoader classLoader = PluginClassLoader.class.getClassLoader();

    public PluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        Method method = null;
        try {
            method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        }
        catch (NoSuchMethodException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
        method.setAccessible(true);
        for (URL url : urls) {
            try {
                method.invoke((Object)this.classLoader, url);
            }
            catch (Exception e) {
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(name);
        if (loadedClass == null) {
            try {
                if (this.classLoader != null) {
                    loadedClass = this.classLoader.loadClass(name);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            try {
                if (loadedClass == null) {
                    loadedClass = this.findClass(name);
                }
            }
            catch (ClassNotFoundException e) {
                loadedClass = super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(loadedClass);
        }
        return loadedClass;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration<URL> parentRes;
        Enumeration<URL> thisRes;
        final LinkedList<URL> allRes = new LinkedList<URL>();
        Enumeration<URL> sysResources = this.classLoader.getResources(name);
        if (sysResources != null) {
            while (sysResources.hasMoreElements()) {
                allRes.add(sysResources.nextElement());
            }
        }
        if ((thisRes = this.findResources(name)) != null) {
            while (thisRes.hasMoreElements()) {
                allRes.add(thisRes.nextElement());
            }
        }
        if ((parentRes = super.findResources(name)) != null) {
            while (parentRes.hasMoreElements()) {
                allRes.add(parentRes.nextElement());
            }
        }
        return new Enumeration<URL>(){
            Iterator<URL> it;
            {
                this.it = allRes.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.it.next();
            }
        };
    }

    @Override
    public URL getResource(String name) {
        URL res = null;
        if (this.classLoader != null) {
            res = this.classLoader.getResource(name);
        }
        if (res == null) {
            res = this.findResource(name);
        }
        if (res == null) {
            res = super.getResource(name);
        }
        return res;
    }
}

