/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.readers.RecordExtractor;

public abstract class BaseRecordExtractor<T>
implements RecordExtractor<T> {
    @Override
    @Nullable
    public Object convert(Object value) {
        Object convertedValue = this.isMultiValue(value) ? this.convertMultiValue(value) : (this.isMap(value) ? this.convertMap(value) : (this.isRecord(value) ? this.convertRecord(value) : this.convertSingleValue(value)));
        return convertedValue;
    }

    protected boolean isRecord(Object value) {
        return false;
    }

    protected boolean isMultiValue(Object value) {
        return value instanceof Collection;
    }

    protected boolean isMap(Object value) {
        return value instanceof Map;
    }

    @Nullable
    protected Object convertRecord(Object value) {
        throw new UnsupportedOperationException("Extractor cannot convert record type structures for this data format.");
    }

    @Nullable
    protected Object convertMultiValue(Object value) {
        Collection collection = (Collection)value;
        if (collection.isEmpty()) {
            return null;
        }
        int numValues = collection.size();
        Object[] array = new Object[numValues];
        int index = 0;
        for (Object element : collection) {
            Object convertedValue = null;
            if (element != null) {
                convertedValue = this.convert(element);
            }
            if (convertedValue == null || convertedValue.toString().equals("")) continue;
            array[index++] = convertedValue;
        }
        if (index == numValues) {
            return array;
        }
        if (index == 0) {
            return null;
        }
        return Arrays.copyOf(array, index);
    }

    @Nullable
    protected Object convertMap(Object value) {
        Map map = (Map)value;
        if (map.isEmpty()) {
            return null;
        }
        HashMap<Object, Object> convertedMap = new HashMap<Object, Object>();
        for (Map.Entry entry : map.entrySet()) {
            Object mapKey = entry.getKey();
            Object mapValue = entry.getValue();
            if (mapKey == null) continue;
            Object convertedMapValue = null;
            if (mapValue != null) {
                convertedMapValue = this.convert(mapValue);
            }
            if (convertedMapValue == null) continue;
            convertedMap.put(this.convertSingleValue(entry.getKey()), convertedMapValue);
        }
        if (convertedMap.isEmpty()) {
            return null;
        }
        return convertedMap;
    }

    protected Object convertSingleValue(Object value) {
        if (value instanceof ByteBuffer) {
            ByteBuffer byteBufferValue = (ByteBuffer)value;
            byte[] bytesValue = new byte[byteBufferValue.remaining()];
            byteBufferValue.get(bytesValue);
            return bytesValue;
        }
        if (value instanceof Number || value instanceof byte[]) {
            return value;
        }
        return value.toString();
    }
}

