/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.crypt;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.spi.crypt.PinotCrypter;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpPinotCrypter
implements PinotCrypter {
    public static final Logger LOGGER = LoggerFactory.getLogger(NoOpPinotCrypter.class);

    @Override
    public void init(PinotConfiguration config) {
    }

    @Override
    public void encrypt(File decryptedFile, File encryptedFile) {
        try {
            FileUtils.copyFile((File)decryptedFile, (File)encryptedFile);
        }
        catch (IOException e) {
            LOGGER.warn("Could not encrypt file");
            FileUtils.deleteQuietly((File)encryptedFile);
        }
    }

    @Override
    public void decrypt(File encryptedFile, File decryptedFile) {
        try {
            FileUtils.copyFile((File)encryptedFile, (File)decryptedFile);
        }
        catch (IOException e) {
            LOGGER.warn("Could not decrypt file");
            FileUtils.deleteQuietly((File)decryptedFile);
        }
    }
}

