/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class TierConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Name of the tier with format TIER<number>")
    private final String _name;
    @JsonPropertyDescription(value="The strategy for selecting segments")
    private final String _segmentSelectorType;
    @JsonPropertyDescription(value="For 'TIME' segment selector, the period after which to select segments for this tier")
    private final String _segmentAge;
    @JsonPropertyDescription(value="The type of storage storage")
    private final String _storageType;
    @JsonPropertyDescription(value="For 'PINOT_SERVER' storageSelector, the tag with which to identify servers for this tier.")
    private final String _serverTag;

    public TierConfig(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="segmentSelectorType", required=true) String segmentSelectorType, @JsonProperty(value="segmentAge") @Nullable String segmentAge, @JsonProperty(value="storageType", required=true) String storageType, @JsonProperty(value="serverTag") @Nullable String serverTag) {
        Preconditions.checkArgument((name != null ? 1 : 0) != 0, (Object)"Must provide non-null 'name' in tierConfig");
        Preconditions.checkArgument((segmentSelectorType != null ? 1 : 0) != 0, (Object)"Must provide non-null 'segmentSelectorType' in tierConfig");
        Preconditions.checkArgument((storageType != null ? 1 : 0) != 0, (Object)"Must provide non-null 'storageType' in tierConfig");
        this._name = name;
        this._segmentSelectorType = segmentSelectorType;
        this._segmentAge = segmentAge;
        this._storageType = storageType;
        this._serverTag = serverTag;
    }

    public String getName() {
        return this._name;
    }

    public String getSegmentSelectorType() {
        return this._segmentSelectorType;
    }

    public String getSegmentAge() {
        return this._segmentAge;
    }

    public String getStorageType() {
        return this._storageType;
    }

    public String getServerTag() {
        return this._serverTag;
    }
}

