/*
 * Decompiled with CFR 0.152.
 */
package xerial.larray.impl;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.UUID;
import xerial.larray.impl.OSInfo;

class LArrayLoader {
    public static String KEY_LARRAY_TEMPDIR = "xerial.larray.tempdir";
    private static boolean isLoaded = false;
    private static Object api = null;

    LArrayLoader() {
    }

    public static void setApi(Object object) {
        api = object;
        isLoaded = true;
    }

    public static synchronized void load() throws Exception {
        if (isLoaded) {
            return;
        }
        try {
            File file = LArrayLoader.findNativeLibrary().newCopy();
            file.deleteOnExit();
            System.load(file.getAbsolutePath());
            isLoaded = true;
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            throw exception;
        }
    }

    public static String md5sum(InputStream inputStream) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);){
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(bufferedInputStream, messageDigest);
            while (digestInputStream.read() >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(messageDigest.digest());
            String string = ((Object)byteArrayOutputStream).toString();
            return string;
        }
    }

    private static boolean hasResource(String string) {
        return LArrayLoader.class.getResource(string) != null;
    }

    private static NativeLib findNativeLibrary() {
        String string;
        String string2 = System.mapLibraryName("larray");
        String string3 = "/xerial/larray/native/" + OSInfo.getNativeLibFolderPathForCurrentOS();
        boolean bl = LArrayLoader.hasResource(string3 + "/" + string2);
        if (!bl && OSInfo.getOSName().equals("Mac")) {
            string = "liblarray.jnilib";
            if (LArrayLoader.hasResource(string3 + "/" + string)) {
                string2 = string;
                bl = true;
            }
        }
        if (!bl) {
            string = String.format("no native library is found for os.name=%s and os.arch=%s", OSInfo.getOSName(), OSInfo.getArchName());
            System.err.println(string);
        }
        return new NativeLib(string3, string2);
    }

    static class NativeLib {
        private final String nativeLibFolder;
        private final String libName;

        public NativeLib(String string, String string2) {
            this.nativeLibFolder = string;
            this.libName = string2;
        }

        public File newCopy() throws IOException {
            String string = new File(System.getProperty(KEY_LARRAY_TEMPDIR, System.getProperty("java.io.tmpdir"))).getAbsolutePath();
            return this.extractLibraryFile(this.nativeLibFolder, this.libName, string);
        }

        private boolean contentsEquals(InputStream inputStream, InputStream inputStream2) throws IOException {
            int n;
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            if (!(inputStream2 instanceof BufferedInputStream)) {
                inputStream2 = new BufferedInputStream(inputStream2);
            }
            int n2 = inputStream.read();
            while (n2 != -1) {
                n = inputStream2.read();
                if (n2 != n) {
                    return false;
                }
                n2 = inputStream.read();
            }
            n = inputStream2.read();
            return n == -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private File extractLibraryFile(String string, String string2, String string3) throws IOException {
            Object object;
            String string4 = string + "/" + string2;
            String string5 = UUID.randomUUID().toString().substring(0, 8);
            String string6 = String.format("larray-%s.lib", string5);
            File file = new File(string3, string6);
            InputStream inputStream = this.getClass().getResourceAsStream(string4);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            try {
                object = new byte[8192];
                int n = 0;
                while ((n = inputStream.read((byte[])object)) != -1) {
                    ((OutputStream)fileOutputStream).write((byte[])object, 0, n);
                }
            }
            finally {
                file.deleteOnExit();
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            file.setReadable(true);
            file.setWritable(true, true);
            file.setExecutable(true);
            object = LArrayLoader.class.getResourceAsStream(string4);
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                if (!this.contentsEquals((InputStream)object, fileInputStream)) {
                    throw new IOException(String.format("Failed to write a native library file at %s", file));
                }
            }
            finally {
                if (object != null) {
                    ((InputStream)object).close();
                }
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
            }
            return new File(string3, string6);
        }
    }
}

