/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import org.apache.helix.HelixException;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.IdealState;
import org.apache.helix.tools.IdealStateCalculatorByShuffling;

public class DefaultIdealStateCalculator {
    static final String _MasterAssignmentMap = "MasterAssignmentMap";
    static final String _SlaveAssignmentMap = "SlaveAssignmentMap";
    static final String _partitions = "partitions";
    static final String _replicas = "replicas";

    public static ZNRecord calculateIdealState(List<String> instanceNames, int partitions, int replicas, String resourceName, String masterStateValue, String slaveStateValue) {
        Collections.sort(instanceNames);
        if (instanceNames.size() < replicas + 1) {
            throw new HelixException("Number of instances must not be less than replicas + 1. instanceNr:" + instanceNames.size() + ", replicas:" + replicas);
        }
        if (partitions < instanceNames.size()) {
            ZNRecord idealState = IdealStateCalculatorByShuffling.calculateIdealState(instanceNames, partitions, replicas, resourceName, 12345L, masterStateValue, slaveStateValue);
            int i = 0;
            for (String partitionId : idealState.getMapFields().keySet()) {
                Map<String, String> partitionAssignmentMap = idealState.getMapField(partitionId);
                ArrayList<String> partitionAssignmentPriorityList = new ArrayList<String>();
                String masterInstance = "";
                for (String instanceName : partitionAssignmentMap.keySet()) {
                    if (partitionAssignmentMap.get(instanceName).equalsIgnoreCase(masterStateValue) && masterInstance.equals("")) {
                        masterInstance = instanceName;
                        continue;
                    }
                    partitionAssignmentPriorityList.add(instanceName);
                }
                Collections.shuffle(partitionAssignmentPriorityList, new Random(i++));
                partitionAssignmentPriorityList.add(0, masterInstance);
                idealState.setListField(partitionId, partitionAssignmentPriorityList);
            }
            return idealState;
        }
        Map<String, Object> result = DefaultIdealStateCalculator.calculateInitialIdealState(instanceNames, partitions, replicas);
        return DefaultIdealStateCalculator.convertToZNRecord(result, resourceName, masterStateValue, slaveStateValue);
    }

    public static ZNRecord calculateIdealStateBatch(List<List<String>> instanceBatches, int partitions, int replicas, String resourceName, String masterStateValue, String slaveStateValue) {
        Map<String, Object> result = DefaultIdealStateCalculator.calculateInitialIdealState(instanceBatches.get(0), partitions, replicas);
        for (int i = 1; i < instanceBatches.size(); ++i) {
            result = DefaultIdealStateCalculator.calculateNextIdealState(instanceBatches.get(i), result);
        }
        return DefaultIdealStateCalculator.convertToZNRecord(result, resourceName, masterStateValue, slaveStateValue);
    }

    public static ZNRecord convertToZNRecord(Map<String, Object> result, String resourceName, String masterStateValue, String slaveStateValue) {
        Map nodeMasterAssignmentMap = (Map)result.get(_MasterAssignmentMap);
        Map nodeSlaveAssignmentMap = (Map)result.get(_SlaveAssignmentMap);
        int partitions = (Integer)result.get(_partitions);
        ZNRecord idealState = new ZNRecord(resourceName);
        idealState.setSimpleField(IdealState.IdealStateProperty.NUM_PARTITIONS.toString(), String.valueOf(partitions));
        for (String instanceName : nodeMasterAssignmentMap.keySet()) {
            for (Object partitionId : (List)nodeMasterAssignmentMap.get(instanceName)) {
                String partitionName = resourceName + "_" + partitionId;
                if (!idealState.getMapFields().containsKey(partitionName)) {
                    idealState.setMapField(partitionName, new TreeMap<String, String>());
                }
                idealState.getMapField(partitionName).put(instanceName, masterStateValue);
            }
        }
        for (String instanceName : nodeSlaveAssignmentMap.keySet()) {
            Map slaveAssignmentMap = (Map)nodeSlaveAssignmentMap.get(instanceName);
            for (String slaveNode : slaveAssignmentMap.keySet()) {
                List slaveAssignment = (List)slaveAssignmentMap.get(slaveNode);
                for (Integer partitionId : slaveAssignment) {
                    String partitionName = resourceName + "_" + partitionId;
                    idealState.getMapField(partitionName).put(slaveNode, slaveStateValue);
                }
            }
        }
        for (String partitionId : idealState.getMapFields().keySet()) {
            Map<String, String> partitionAssignmentMap = idealState.getMapField(partitionId);
            ArrayList<String> partitionAssignmentPriorityList = new ArrayList<String>();
            String masterInstance = "";
            for (String instanceName : partitionAssignmentMap.keySet()) {
                if (partitionAssignmentMap.get(instanceName).equalsIgnoreCase(masterStateValue) && masterInstance.equals("")) {
                    masterInstance = instanceName;
                    continue;
                }
                partitionAssignmentPriorityList.add(instanceName);
            }
            Collections.shuffle(partitionAssignmentPriorityList);
            partitionAssignmentPriorityList.add(0, masterInstance);
            idealState.setListField(partitionId, partitionAssignmentPriorityList);
        }
        assert (result.containsKey(_replicas));
        idealState.setSimpleField(IdealState.IdealStateProperty.REPLICAS.toString(), result.get(_replicas).toString());
        return idealState;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, Object> calculateInitialIdealState(List<String> instanceNames, int partitions, int replicas) {
        Random r = new Random(54321L);
        assert (replicas <= instanceNames.size() - 1);
        ArrayList<Integer> masterPartitionAssignment = new ArrayList<Integer>();
        for (int i = 0; i < partitions; ++i) {
            masterPartitionAssignment.add(i);
        }
        Collections.shuffle(masterPartitionAssignment, new Random(r.nextInt()));
        TreeMap nodeMasterAssignmentMap = new TreeMap();
        for (int i = 0; i < masterPartitionAssignment.size(); ++i) {
            String instanceName = instanceNames.get(i % instanceNames.size());
            if (!nodeMasterAssignmentMap.containsKey(instanceName)) {
                nodeMasterAssignmentMap.put(instanceName, new ArrayList());
            }
            ((List)nodeMasterAssignmentMap.get(instanceName)).add(masterPartitionAssignment.get(i));
        }
        ArrayList<Map<String, Map<String, List<Integer>>>> nodeSlaveAssignmentMapsList = new ArrayList<Map<String, Map<String, List<Integer>>>>(replicas);
        TreeMap<String, Map<String, List<Integer>>> firstNodeSlaveAssignmentMap = new TreeMap<String, Map<String, List<Integer>>>();
        TreeMap<String, TreeMap<String, List<Integer>>> combinedNodeSlaveAssignmentMap = new TreeMap<String, TreeMap<String, List<Integer>>>();
        if (replicas > 0) {
            for (int i = 0; i < instanceNames.size(); ++i) {
                int j;
                void var13_18;
                ArrayList<String> slaveInstances = new ArrayList<String>();
                ArrayList<Integer> slaveAssignment = new ArrayList<Integer>();
                TreeMap slaveAssignmentMap = new TreeMap();
                boolean bl = false;
                while (var13_18 < instanceNames.size()) {
                    if (var13_18 != i) {
                        slaveInstances.add(instanceNames.get((int)var13_18));
                        slaveAssignmentMap.put(instanceNames.get((int)var13_18), new ArrayList());
                    }
                    ++var13_18;
                }
                List list = (List)nodeMasterAssignmentMap.get(instanceNames.get(i));
                for (j = 0; j < list.size(); ++j) {
                    slaveAssignment.add(j);
                }
                Collections.shuffle(slaveAssignment, new Random(r.nextInt()));
                Collections.shuffle(slaveInstances, new Random(instanceNames.get(i).hashCode()));
                for (j = 0; j < list.size(); ++j) {
                    String slaveInstanceName = (String)slaveInstances.get((Integer)slaveAssignment.get(j) % slaveInstances.size());
                    if (!slaveAssignmentMap.containsKey(slaveInstanceName)) {
                        slaveAssignmentMap.put(slaveInstanceName, new ArrayList());
                    }
                    ((List)slaveAssignmentMap.get(slaveInstanceName)).add(list.get(j));
                }
                firstNodeSlaveAssignmentMap.put(instanceNames.get(i), slaveAssignmentMap);
            }
            nodeSlaveAssignmentMapsList.add(firstNodeSlaveAssignmentMap);
            for (int replicaOrder = 1; replicaOrder < replicas; ++replicaOrder) {
                Map<String, Map<String, List<Integer>>> nextNodeSlaveAssignmentMap = DefaultIdealStateCalculator.calculateNextSlaveAssignemntMap(firstNodeSlaveAssignmentMap, replicaOrder);
                nodeSlaveAssignmentMapsList.add(nextNodeSlaveAssignmentMap);
            }
            for (String instanceName : nodeMasterAssignmentMap.keySet()) {
                TreeMap<String, List<Integer>> combinedSlaveAssignmentMap = new TreeMap<String, List<Integer>>();
                for (Map map : nodeSlaveAssignmentMapsList) {
                    Map slaveAssignmentMap = (Map)map.get(instanceName);
                    for (String slaveInstance : slaveAssignmentMap.keySet()) {
                        if (!combinedSlaveAssignmentMap.containsKey(slaveInstance)) {
                            combinedSlaveAssignmentMap.put(slaveInstance, new ArrayList());
                        }
                        ((List)combinedSlaveAssignmentMap.get(slaveInstance)).addAll((Collection)slaveAssignmentMap.get(slaveInstance));
                    }
                }
                DefaultIdealStateCalculator.migrateSlaveAssignMapToNewInstances(combinedSlaveAssignmentMap, new ArrayList<String>());
                combinedNodeSlaveAssignmentMap.put(instanceName, combinedSlaveAssignmentMap);
            }
        }
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        result.put(_MasterAssignmentMap, nodeMasterAssignmentMap);
        result.put(_SlaveAssignmentMap, combinedNodeSlaveAssignmentMap);
        result.put(_replicas, new Integer(replicas + 1));
        result.put(_partitions, new Integer(partitions));
        return result;
    }

    static Map<String, Map<String, List<Integer>>> calculateNextSlaveAssignemntMap(Map<String, Map<String, List<Integer>>> firstInstanceSlaveAssignmentMap, int replicaOrder) {
        TreeMap<String, Map<String, List<Integer>>> result = new TreeMap<String, Map<String, List<Integer>>>();
        for (String currentInstance : firstInstanceSlaveAssignmentMap.keySet()) {
            TreeMap resultAssignmentMap = new TreeMap();
            result.put(currentInstance, resultAssignmentMap);
        }
        for (String currentInstance : firstInstanceSlaveAssignmentMap.keySet()) {
            Map<String, List<Integer>> previousSlaveAssignmentMap = firstInstanceSlaveAssignmentMap.get(currentInstance);
            Map resultAssignmentMap = (Map)result.get(currentInstance);
            int offset = replicaOrder - 1;
            for (String instance : previousSlaveAssignmentMap.keySet()) {
                ArrayList<String> otherInstances = new ArrayList<String>(previousSlaveAssignmentMap.size() - 1);
                for (String otherInstance : previousSlaveAssignmentMap.keySet()) {
                    otherInstances.add(otherInstance);
                }
                Collections.sort(otherInstances);
                int instanceIndex = -1;
                for (int index = 0; index < otherInstances.size(); ++index) {
                    if (!((String)otherInstances.get(index)).equalsIgnoreCase(instance)) continue;
                    instanceIndex = index;
                }
                assert (instanceIndex >= 0);
                if (instanceIndex == otherInstances.size() - 1) {
                    --instanceIndex;
                }
                otherInstances.remove(instance);
                List<Integer> previousAssignmentList = previousSlaveAssignmentMap.get(instance);
                for (int i = 0; i < previousAssignmentList.size(); ++i) {
                    int newInstanceIndex = (i + offset + instanceIndex) % otherInstances.size();
                    String newInstance = (String)otherInstances.get(newInstanceIndex);
                    if (!resultAssignmentMap.containsKey(newInstance)) {
                        resultAssignmentMap.put(newInstance, new ArrayList());
                    }
                    ((List)resultAssignmentMap.get(newInstance)).add(previousAssignmentList.get(i));
                }
            }
        }
        return result;
    }

    public static Map<String, Object> calculateNextIdealState(List<String> newInstances, Map<String, Object> previousIdealState) {
        Collections.sort(newInstances);
        Map previousMasterAssignmentMap = (Map)previousIdealState.get(_MasterAssignmentMap);
        Map nodeSlaveAssignmentMap = (Map)previousIdealState.get(_SlaveAssignmentMap);
        ArrayList<String> oldInstances = new ArrayList<String>();
        for (String oldInstance : previousMasterAssignmentMap.keySet()) {
            oldInstances.add(oldInstance);
        }
        int previousInstanceNum = previousMasterAssignmentMap.size();
        int partitions = (Integer)previousIdealState.get(_partitions);
        int totalMasterParitionsToMove = partitions * newInstances.size() / (previousInstanceNum + newInstances.size());
        int numMastersFromEachNode = totalMasterParitionsToMove / previousInstanceNum;
        int remain = totalMasterParitionsToMove % previousInstanceNum;
        ArrayList<Integer> masterPartitionListToMove = new ArrayList<Integer>();
        TreeMap<String, List<Integer>> slavePartitionsToMoveMap = new TreeMap<String, List<Integer>>();
        ArrayList<Object> bigList = new ArrayList<Object>();
        ArrayList<Object> smallList = new ArrayList<Object>();
        for (Object oldInstance : previousMasterAssignmentMap.keySet()) {
            List list = (List)previousMasterAssignmentMap.get(oldInstance);
            if (list.size() > numMastersFromEachNode) {
                bigList.add(oldInstance);
                continue;
            }
            smallList.add(oldInstance);
        }
        bigList.addAll(smallList);
        int totalSlaveMoves = 0;
        for (String string : bigList) {
            List masterAssignmentList = (List)previousMasterAssignmentMap.get(string);
            int numToChoose = numMastersFromEachNode;
            if (remain > 0) {
                numToChoose = numMastersFromEachNode + 1;
                --remain;
            }
            Iterator masterPartionsMoved = new ArrayList<Integer>();
            DefaultIdealStateCalculator.randomSelect(masterAssignmentList, masterPartionsMoved, numToChoose);
            masterPartitionListToMove.addAll((Collection<Integer>)((Object)masterPartionsMoved));
            Map slaveAssignmentMap = (Map)nodeSlaveAssignmentMap.get(string);
            DefaultIdealStateCalculator.removeFromSlaveAssignmentMap(slaveAssignmentMap, masterPartionsMoved, slavePartitionsToMoveMap);
            int movesWithinInstance = DefaultIdealStateCalculator.migrateSlaveAssignMapToNewInstances(slaveAssignmentMap, newInstances);
            totalSlaveMoves += movesWithinInstance;
        }
        Collections.shuffle(masterPartitionListToMove, new Random(12345L));
        for (int i = 0; i < newInstances.size(); ++i) {
            String string = newInstances.get(i);
            ArrayList masterPartitionList = new ArrayList();
            for (int j = 0; j < masterPartitionListToMove.size(); ++j) {
                if (j % newInstances.size() != i) continue;
                masterPartitionList.add(masterPartitionListToMove.get(j));
            }
            TreeMap<String, List<Integer>> slavePartitionMap = new TreeMap<String, List<Integer>>();
            for (String oldInstance : oldInstances) {
                slavePartitionMap.put(oldInstance, new ArrayList());
            }
            for (Integer x : masterPartitionList) {
                for (String oldInstance : slavePartitionsToMoveMap.keySet()) {
                    List slaves = (List)slavePartitionsToMoveMap.get(oldInstance);
                    if (!slaves.contains(x)) continue;
                    ((List)slavePartitionMap.get(oldInstance)).add(x);
                }
            }
            ArrayList<String> otherNewInstances = new ArrayList<String>();
            for (String instance : newInstances) {
                if (instance.equalsIgnoreCase(string)) continue;
                otherNewInstances.add(instance);
            }
            DefaultIdealStateCalculator.migrateSlaveAssignMapToNewInstances(slavePartitionMap, otherNewInstances);
            previousMasterAssignmentMap.put(string, masterPartitionList);
            nodeSlaveAssignmentMap.put(string, slavePartitionMap);
        }
        return previousIdealState;
    }

    public ZNRecord calculateNextIdealState(List<String> newInstances, Map<String, Object> previousIdealState, String resourceName, String masterStateValue, String slaveStateValue) {
        return DefaultIdealStateCalculator.convertToZNRecord(DefaultIdealStateCalculator.calculateNextIdealState(newInstances, previousIdealState), resourceName, masterStateValue, slaveStateValue);
    }

    static void removeFromSlaveAssignmentMap(Map<String, List<Integer>> slaveAssignmentMap, List<Integer> masterPartionsMoved, Map<String, List<Integer>> removedAssignmentMap) {
        for (String instanceName : slaveAssignmentMap.keySet()) {
            List<Integer> slaveAssignment = slaveAssignmentMap.get(instanceName);
            for (Integer partitionId : masterPartionsMoved) {
                if (!slaveAssignment.contains(partitionId)) continue;
                slaveAssignment.remove(partitionId);
                if (!removedAssignmentMap.containsKey(instanceName)) {
                    removedAssignmentMap.put(instanceName, new ArrayList());
                }
                removedAssignmentMap.get(instanceName).add(partitionId);
            }
        }
    }

    static int migrateSlaveAssignMapToNewInstances(Map<String, List<Integer>> nodeSlaveAssignmentMap, List<String> newInstances) {
        int moves = 0;
        boolean done = false;
        for (String newInstance : newInstances) {
            nodeSlaveAssignmentMap.put(newInstance, new ArrayList());
        }
        while (!done) {
            List<Integer> maxAssignment = null;
            List<Integer> minAssignment = null;
            int minCount = Integer.MAX_VALUE;
            int maxCount = Integer.MIN_VALUE;
            String minInstance = "";
            for (String instanceName : nodeSlaveAssignmentMap.keySet()) {
                List<Integer> slaveAssignment = nodeSlaveAssignmentMap.get(instanceName);
                if (minCount > slaveAssignment.size()) {
                    minCount = slaveAssignment.size();
                    minAssignment = slaveAssignment;
                    minInstance = instanceName;
                }
                if (maxCount >= slaveAssignment.size()) continue;
                maxCount = slaveAssignment.size();
                maxAssignment = slaveAssignment;
            }
            if (maxCount - minCount <= 1) {
                done = true;
                continue;
            }
            int indexToMove = -1;
            for (int i = 0; i < maxAssignment.size(); ++i) {
                if (minAssignment.contains(maxAssignment.get(i))) continue;
                indexToMove = i;
                break;
            }
            minAssignment.add((Integer)maxAssignment.get(indexToMove));
            maxAssignment.remove(indexToMove);
            if (!newInstances.contains(minInstance)) continue;
            ++moves;
        }
        return moves;
    }

    static void randomSelect(List<Integer> originalList, List<Integer> selectedList, int num) {
        assert (originalList.size() >= num);
        int[] indexArray = new int[originalList.size()];
        for (int i = 0; i < indexArray.length; ++i) {
            indexArray[i] = i;
        }
        int numRemains = originalList.size();
        Random r = new Random(numRemains);
        for (int j = 0; j < num; ++j) {
            int randIndex = r.nextInt(numRemains);
            selectedList.add(originalList.get(randIndex));
            originalList.remove(randIndex);
            --numRemains;
        }
    }

    public static void main(String[] args) {
        ArrayList<String> instanceNames = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            instanceNames.add("localhost:123" + i);
        }
        int partitions = 144;
        int replicas = 3;
        Map<String, Object> resultOriginal = DefaultIdealStateCalculator.calculateInitialIdealState(instanceNames, partitions, replicas);
    }
}

