/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.Message;

public class HealthStat
extends HelixProperty {
    public static final String VALUE_NAME = "value";
    public static final String TIMESTAMP_NAME = "TimeStamp";
    public static final String statFieldDelim = ".";

    public HealthStat(String id) {
        super(id);
    }

    public HealthStat(ZNRecord record) {
        super(record);
        if (this.getCreateTimeStamp() == 0L) {
            this._record.setLongField(Message.Attributes.CREATE_TIMESTAMP.toString(), new Date().getTime());
        }
    }

    public long getLastModifiedTimeStamp() {
        return this._record.getModifiedTime();
    }

    public long getCreateTimeStamp() {
        return this._record.getLongField(Message.Attributes.CREATE_TIMESTAMP.toString(), 0L);
    }

    public String getTestField() {
        return this._record.getSimpleField("requestCountStat");
    }

    public void setHealthFields(Map<String, Map<String, String>> healthFields) {
        this._record.setMapFields(healthFields);
    }

    public String buildCompositeKey(String instance, String parentKey, String statName) {
        String delim = statFieldDelim;
        return instance + delim + parentKey + delim + statName;
    }

    public Map<String, Map<String, String>> getHealthFields(String instanceName) {
        Map<String, Map<String, String>> currMapFields = this._record.getMapFields();
        HashMap<String, Map<String, String>> convertedMapFields = new HashMap<String, Map<String, String>>();
        for (String key : currMapFields.keySet()) {
            Map<String, String> currMap = currMapFields.get(key);
            String timestamp = this._record.getStringField(TIMESTAMP_NAME, "-1");
            for (String subKey : currMap.keySet()) {
                if (subKey.equals("StatsHolder.TIMESTAMP_NAME")) continue;
                String compositeKey = this.buildCompositeKey(instanceName, key, subKey);
                String value = currMap.get(subKey);
                HashMap<String, String> convertedMap = new HashMap<String, String>();
                convertedMap.put(VALUE_NAME, value);
                convertedMap.put(TIMESTAMP_NAME, timestamp);
                convertedMapFields.put(compositeKey, convertedMap);
            }
        }
        return convertedMapFields;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static enum HealthStatProperty {
        FIELDS;

    }
}

