/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.PropertyKey;
import org.apache.helix.ZNRecord;
import org.apache.helix.ZNRecordDelta;
import org.apache.helix.controller.LogUtil;
import org.apache.helix.controller.dataproviders.ResourceControllerDataProvider;
import org.apache.helix.controller.pipeline.AbstractAsyncBaseStage;
import org.apache.helix.controller.pipeline.AsyncWorkerType;
import org.apache.helix.controller.pipeline.StageException;
import org.apache.helix.controller.stages.AttributeName;
import org.apache.helix.controller.stages.ClusterEvent;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.Message;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceConfig;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.model.StatusUpdate;
import org.apache.helix.monitoring.mbeans.ClusterStatusMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalViewComputeStage
extends AbstractAsyncBaseStage {
    private static Logger LOG = LoggerFactory.getLogger(ExternalViewComputeStage.class);

    @Override
    public AsyncWorkerType getAsyncWorkerType() {
        return AsyncWorkerType.ExternalViewComputeWorker;
    }

    @Override
    public void execute(ClusterEvent event) throws Exception {
        this._eventId = event.getEventId();
        HelixManager manager = (HelixManager)event.getAttribute(AttributeName.helixmanager.name());
        Map resourceMap = (Map)event.getAttribute(AttributeName.RESOURCES_TO_REBALANCE.name());
        ResourceControllerDataProvider cache = (ResourceControllerDataProvider)event.getAttribute(AttributeName.ControllerDataProvider.name());
        if (manager == null || resourceMap == null || cache == null) {
            throw new StageException("Missing attributes in event:" + event + ". Requires ClusterManager|RESOURCES|DataCache");
        }
        HelixDataAccessor dataAccessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = dataAccessor.keyBuilder();
        CurrentStateOutput currentStateOutput = (CurrentStateOutput)event.getAttribute(AttributeName.CURRENT_STATE.name());
        ClusterStatusMonitor clusterStatusMonitor = (ClusterStatusMonitor)event.getAttribute(AttributeName.clusterStatusMonitor.name());
        ArrayList<ExternalView> newExtViews = new ArrayList<ExternalView>();
        HashSet<String> monitoringResources = new HashSet<String>();
        Map<String, ExternalView> curExtViews = cache.getExternalViews();
        for (Resource resource : resourceMap.values()) {
            try {
                this.computeExternalView(resource, currentStateOutput, cache, clusterStatusMonitor, curExtViews, manager, monitoringResources, newExtViews);
            }
            catch (HelixException ex) {
                LogUtil.logError(LOG, this._eventId, "Failed to calculate external view for resource " + resource.getResourceName(), ex);
            }
        }
        if (clusterStatusMonitor != null) {
            clusterStatusMonitor.retainResourceMonitor(monitoringResources);
        }
        ArrayList<String> externalViewsToRemove = new ArrayList<String>();
        ArrayList<PropertyKey> keys = new ArrayList<PropertyKey>();
        Iterator it = newExtViews.iterator();
        while (it.hasNext()) {
            ExternalView view = (ExternalView)it.next();
            String resourceName = view.getResourceName();
            IdealState idealState = cache.getIdealState(resourceName);
            if (idealState != null && idealState.isExternalViewDisabled()) {
                it.remove();
                if (!curExtViews.containsKey(resourceName)) continue;
                LogUtil.logInfo(LOG, this._eventId, "Remove externalView for resource: " + resourceName);
                dataAccessor.removeProperty(keyBuilder.externalView(resourceName));
                externalViewsToRemove.add(resourceName);
                continue;
            }
            keys.add(keyBuilder.externalView(resourceName));
        }
        if (newExtViews.size() > 0) {
            dataAccessor.setChildren(keys, newExtViews);
            cache.updateExternalViews(newExtViews);
        }
        for (String resourceName : curExtViews.keySet()) {
            if (resourceMap.keySet().contains(resourceName)) continue;
            LogUtil.logInfo(LOG, this._eventId, "Remove externalView for resource: " + resourceName);
            dataAccessor.removeProperty(keyBuilder.externalView(resourceName));
            externalViewsToRemove.add(resourceName);
        }
        cache.removeExternalViews(externalViewsToRemove);
    }

    private void computeExternalView(Resource resource, CurrentStateOutput currentStateOutput, ResourceControllerDataProvider cache, ClusterStatusMonitor clusterStatusMonitor, Map<String, ExternalView> curExtViews, HelixManager manager, Set<String> monitoringResources, List<ExternalView> newExtViews) {
        String resourceName = resource.getResourceName();
        ExternalView view = new ExternalView(resource.getResourceName());
        if (resource.getBucketSize() > 0) {
            view.setBucketSize(resource.getBucketSize());
        } else {
            view.setBucketSize(currentStateOutput.getBucketSize(resourceName));
        }
        int totalPendingMessageCount = 0;
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resourceName, partition);
            if (currentStateMap != null && currentStateMap.size() > 0) {
                for (String instance : currentStateMap.keySet()) {
                    view.setState(partition.getPartitionName(), instance, currentStateMap.get(instance));
                }
            }
            totalPendingMessageCount += currentStateOutput.getPendingMessageMap(resource.getResourceName(), partition).size();
        }
        IdealState idealState = cache.getIdealState(resourceName);
        ResourceConfig resourceConfig = cache.getResourceConfig(resourceName);
        if (!(clusterStatusMonitor == null || idealState == null || resourceConfig != null && resourceConfig.isMonitoringDisabled().booleanValue() || idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue"))) {
            StateModelDefinition stateModelDef = cache.getStateModelDef(idealState.getStateModelDefRef());
            clusterStatusMonitor.setResourceStatus(view, cache.getIdealState(view.getResourceName()), stateModelDef, totalPendingMessageCount);
            monitoringResources.add(resourceName);
        }
        ExternalView curExtView = curExtViews.get(resourceName);
        if (idealState != null) {
            view.getRecord().getSimpleFields().putAll(idealState.getRecord().getSimpleFields());
        } else if (curExtView != null) {
            view.getRecord().getSimpleFields().putAll(curExtView.getRecord().getSimpleFields());
        }
        if (curExtView == null || !curExtView.getRecord().equals(view.getRecord())) {
            newExtViews.add(view);
            if (idealState != null && idealState.getStateModelDefRef().equalsIgnoreCase("SchedulerTaskQueue")) {
                this.updateScheduledTaskStatus(view, manager, idealState);
            }
        }
    }

    private void updateScheduledTaskStatus(ExternalView ev, HelixManager manager, IdealState taskQueueIdealState) {
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        ZNRecord finishedTasks = new ZNRecord(ev.getResourceName());
        HashMap emptyMap = new HashMap();
        LinkedList emptyList = new LinkedList();
        HashMap<String, Integer> controllerMsgIdCountMap = new HashMap<String, Integer>();
        HashMap controllerMsgUpdates = new HashMap();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        for (String taskPartitionName : ev.getPartitionSet()) {
            for (String taskState : ev.getStateMap(taskPartitionName).values()) {
                Object controllerMsgId;
                if (!taskState.equalsIgnoreCase(HelixDefinedState.ERROR.toString()) && !taskState.equalsIgnoreCase("COMPLETED")) continue;
                LogUtil.logInfo(LOG, this._eventId, taskPartitionName + " finished as " + taskState);
                finishedTasks.getListFields().put(taskPartitionName, emptyList);
                finishedTasks.getMapFields().put(taskPartitionName, emptyMap);
                if (taskQueueIdealState.getRecord().getMapField(taskPartitionName) == null || (controllerMsgId = taskQueueIdealState.getRecord().getMapField(taskPartitionName).get("controllerMsgId")) == null) continue;
                LogUtil.logInfo(LOG, this._eventId, taskPartitionName + " finished with controllerMsg " + (String)controllerMsgId);
                if (!controllerMsgUpdates.containsKey(controllerMsgId)) {
                    controllerMsgUpdates.put(controllerMsgId, new HashMap());
                }
                ((Map)controllerMsgUpdates.get(controllerMsgId)).put(taskPartitionName, taskState);
            }
        }
        for (String taskId : taskQueueIdealState.getPartitionSet()) {
            String controllerMsgId = taskQueueIdealState.getRecord().getMapField(taskId).get("controllerMsgId");
            if (controllerMsgId == null) continue;
            if (!controllerMsgIdCountMap.containsKey(controllerMsgId)) {
                controllerMsgIdCountMap.put(controllerMsgId, 0);
            }
            controllerMsgIdCountMap.put(controllerMsgId, (Integer)controllerMsgIdCountMap.get(controllerMsgId) + 1);
        }
        if (controllerMsgUpdates.size() > 0) {
            for (String controllerMsgId : controllerMsgUpdates.keySet()) {
                PropertyKey controllerStatusUpdateKey = keyBuilder.controllerTaskStatus(Message.MessageType.SCHEDULER_MSG.name(), controllerMsgId);
                StatusUpdate controllerStatusUpdate = (StatusUpdate)accessor.getProperty(controllerStatusUpdateKey);
                for (String taskPartitionName : ((Map)controllerMsgUpdates.get(controllerMsgId)).keySet()) {
                    HashMap<String, String> result = new HashMap<String, String>();
                    result.put("Result", (String)((Map)controllerMsgUpdates.get(controllerMsgId)).get(taskPartitionName));
                    controllerStatusUpdate.getRecord().setMapField("MessageResult " + taskQueueIdealState.getRecord().getMapField(taskPartitionName).get(Message.Attributes.TGT_NAME.toString()) + " " + taskPartitionName + " " + taskQueueIdealState.getRecord().getMapField(taskPartitionName).get(Message.Attributes.MSG_ID.toString()), result);
                }
                Integer controllerMsgIdCount = (Integer)controllerMsgIdCountMap.get(controllerMsgId);
                if (controllerMsgIdCount != null && ((Map)controllerMsgUpdates.get(controllerMsgId)).size() == controllerMsgIdCount.intValue()) {
                    int finishedTasksNum = 0;
                    int completedTasksNum = 0;
                    for (String key : controllerStatusUpdate.getRecord().getMapFields().keySet()) {
                        if (key.startsWith("MessageResult ")) {
                            ++finishedTasksNum;
                        }
                        if (controllerStatusUpdate.getRecord().getMapField(key).get("Result") == null || !controllerStatusUpdate.getRecord().getMapField(key).get("Result").equalsIgnoreCase("COMPLETED")) continue;
                        ++completedTasksNum;
                    }
                    TreeMap<String, String> summary = new TreeMap<String, String>();
                    summary.put("TotalMessages:", "" + finishedTasksNum);
                    summary.put("CompletedMessages", "" + completedTasksNum);
                    controllerStatusUpdate.getRecord().setMapField("Summary", summary);
                }
                accessor.updateProperty(controllerStatusUpdateKey, controllerStatusUpdate);
            }
        }
        if (finishedTasks.getListFields().size() > 0) {
            ZNRecordDelta znDelta = new ZNRecordDelta(finishedTasks, ZNRecordDelta.MergeOperation.SUBTRACT);
            LinkedList<ZNRecordDelta> deltaList = new LinkedList<ZNRecordDelta>();
            deltaList.add(znDelta);
            IdealState delta = new IdealState(taskQueueIdealState.getResourceName());
            delta.setDeltaList(deltaList);
            keyBuilder = accessor.keyBuilder();
            accessor.updateProperty(keyBuilder.idealStates(taskQueueIdealState.getResourceName()), delta);
        }
    }
}

