/*
 * Decompiled with CFR 0.152.
 */
package me.lemire.integercompression.differential;

import java.nio.ByteBuffer;
import java.util.Arrays;
import me.lemire.integercompression.BitPacking;
import me.lemire.integercompression.IntWrapper;
import me.lemire.integercompression.Util;
import me.lemire.integercompression.differential.Delta;
import me.lemire.integercompression.differential.IntegratedIntegerCODEC;

public final class IntegratedFastPFOR
implements IntegratedIntegerCODEC {
    static final int BLOCK_SIZE = 128;
    static final int OVERHEAD_OF_EACH_EXCEPT = 8;
    static final int DEFAULT_PAGE_SIZE = 65536;
    int pageSize;
    final int[] buffer = new int[128];
    final int[][] dataTobePacked = new int[33][];
    final ByteBuffer byteContainer;
    int[] dataPointers;
    int[] freqs;
    byte[] bestbbestcexceptmaxb;

    public IntegratedFastPFOR(int pagesize) {
        this.pageSize = pagesize;
        this.byteContainer = ByteBuffer.allocateDirect(3 * this.pageSize / 128 + this.pageSize);
        for (int k = 1; k < this.dataTobePacked.length; ++k) {
            this.dataTobePacked[k] = new int[this.pageSize / 32 * 4];
        }
    }

    public IntegratedFastPFOR() {
        this(65536);
    }

    public void compress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if ((inlength = Util.floorBy(inlength, 128)) == 0) {
            return;
        }
        out[outpos.get()] = inlength;
        outpos.increment();
        IntWrapper initoffset = new IntWrapper(0);
        this.dataPointers = new int[33];
        this.freqs = new int[33];
        this.bestbbestcexceptmaxb = new byte[3];
        int finalinpos = inpos.get() + inlength;
        while (inpos.get() != finalinpos) {
            int thissize = Math.min(this.pageSize, finalinpos - inpos.get());
            this.encodePage(in, inpos, thissize, out, outpos, initoffset);
        }
        this.dataPointers = null;
        this.freqs = null;
        this.bestbbestcexceptmaxb = null;
    }

    private void getBestBFromData(int[] in, int pos) {
        byte cexcept;
        Arrays.fill(this.freqs, 0);
        int k_end = pos + 128;
        for (int k = pos; k < k_end; ++k) {
            int n = Util.bits(in[k]);
            this.freqs[n] = this.freqs[n] + 1;
        }
        this.bestbbestcexceptmaxb[0] = 32;
        while (this.freqs[this.bestbbestcexceptmaxb[0]] == 0) {
            this.bestbbestcexceptmaxb[0] = (byte)(this.bestbbestcexceptmaxb[0] - 1);
        }
        this.bestbbestcexceptmaxb[2] = this.bestbbestcexceptmaxb[0];
        int bestcost = this.bestbbestcexceptmaxb[0] * 128;
        this.bestbbestcexceptmaxb[1] = cexcept = 0;
        for (int b = this.bestbbestcexceptmaxb[0] - 1; b >= 0 && (cexcept = (byte)(cexcept + this.freqs[b + 1])) >= 0; --b) {
            int thiscost = cexcept * 8 + cexcept * (this.bestbbestcexceptmaxb[2] - b) + b * 128 + 8;
            if (thiscost >= bestcost) continue;
            bestcost = thiscost;
            this.bestbbestcexceptmaxb[0] = (byte)b;
            this.bestbbestcexceptmaxb[1] = cexcept;
        }
    }

    private void encodePage(int[] constin, IntWrapper constinpos, int thissize, int[] out, IntWrapper outpos, IntWrapper initoffset) {
        int k;
        int tmpconstinpos;
        int headerpos = outpos.get();
        outpos.increment();
        int tmpoutpos = outpos.get();
        Arrays.fill(this.dataPointers, 0);
        this.byteContainer.clear();
        int finalconstinpos = tmpconstinpos + thissize - 128;
        for (tmpconstinpos = constinpos.get(); tmpconstinpos <= finalconstinpos; tmpconstinpos += 128) {
            initoffset.set(Delta.delta(constin, tmpconstinpos, 128, initoffset.intValue(), this.buffer));
            this.getBestBFromData(this.buffer, 0);
            byte tmpbestb = this.bestbbestcexceptmaxb[0];
            this.byteContainer.put(this.bestbbestcexceptmaxb[0]);
            this.byteContainer.put(this.bestbbestcexceptmaxb[1]);
            if (this.bestbbestcexceptmaxb[1] > 0) {
                this.byteContainer.put(this.bestbbestcexceptmaxb[2]);
                int index = this.bestbbestcexceptmaxb[2] - this.bestbbestcexceptmaxb[0];
                if (this.dataPointers[index] + this.bestbbestcexceptmaxb[1] >= this.dataTobePacked[index].length) {
                    int newsize = 2 * (this.dataPointers[index] + this.bestbbestcexceptmaxb[1]);
                    newsize = Util.floorBy(newsize + 31, 32);
                    this.dataTobePacked[index] = Arrays.copyOf(this.dataTobePacked[index], newsize);
                }
                for (k = 0; k < 128; ++k) {
                    if (this.buffer[k] >>> this.bestbbestcexceptmaxb[0] == 0) continue;
                    this.byteContainer.put((byte)k);
                    int n = index;
                    int n2 = this.dataPointers[n];
                    this.dataPointers[n] = n2 + 1;
                    this.dataTobePacked[index][n2] = this.buffer[k] >>> tmpbestb;
                }
            }
            for (int k2 = 0; k2 < 128; k2 += 32) {
                BitPacking.fastpack(this.buffer, k2, out, tmpoutpos, tmpbestb);
                tmpoutpos += tmpbestb;
            }
        }
        constinpos.set(tmpconstinpos);
        out[headerpos] = tmpoutpos - headerpos;
        while ((this.byteContainer.position() & 3) != 0) {
            this.byteContainer.put((byte)0);
        }
        int bytesize = this.byteContainer.position();
        out[tmpoutpos++] = bytesize;
        int howmanyints = bytesize / 4;
        this.byteContainer.flip();
        this.byteContainer.asIntBuffer().get(out, tmpoutpos, howmanyints);
        tmpoutpos += howmanyints;
        int bitmap = 0;
        for (k = 1; k <= 32; ++k) {
            if (this.dataPointers[k] == 0) continue;
            bitmap |= 1 << k - 1;
        }
        out[tmpoutpos++] = bitmap;
        for (k = 1; k <= 32; ++k) {
            if (this.dataPointers[k] == 0) continue;
            out[tmpoutpos++] = this.dataPointers[k];
            for (int j = 0; j < this.dataPointers[k]; j += 32) {
                BitPacking.fastpack(this.dataTobePacked[k], j, out, tmpoutpos, k);
                tmpoutpos += k;
            }
        }
        outpos.set(tmpoutpos);
    }

    public void uncompress(int[] in, IntWrapper inpos, int inlength, int[] out, IntWrapper outpos) {
        if (inlength == 0) {
            return;
        }
        int mynvalue = in[inpos.get()];
        inpos.increment();
        this.dataPointers = new int[33];
        IntWrapper initoffset = new IntWrapper(0);
        int finalout = outpos.get() + mynvalue;
        while (outpos.get() != finalout) {
            int thissize = Math.min(this.pageSize, finalout - outpos.get());
            this.decodePage(in, inpos, out, outpos, thissize, initoffset);
        }
        this.dataPointers = null;
    }

    private void decodePage(int[] in, IntWrapper inpos, int[] out, IntWrapper outpos, int thissize, IntWrapper initoffset) {
        int initpos = inpos.get();
        int wheremeta = in[inpos.get()];
        inpos.increment();
        int inexcept = initpos + wheremeta;
        int bytesize = in[inexcept++];
        this.byteContainer.clear();
        this.byteContainer.asIntBuffer().put(in, inexcept, bytesize / 4);
        inexcept += bytesize / 4;
        int bitmap = in[inexcept++];
        for (int k = 1; k <= 32; ++k) {
            int size;
            if ((bitmap & 1 << k - 1) == 0) continue;
            if (this.dataTobePacked[k].length < (size = in[inexcept++])) {
                this.dataTobePacked[k] = new int[Util.floorBy(size + 31, 32)];
            }
            for (int j = 0; j < size; j += 32) {
                BitPacking.fastunpack(in, inexcept, this.dataTobePacked[k], j, k);
                inexcept += k;
            }
        }
        Arrays.fill(this.dataPointers, 0);
        int tmpoutpos = outpos.get();
        int tmpinpos = inpos.get();
        int run = 0;
        int run_end = thissize / 128;
        while (run < run_end) {
            byte b = this.byteContainer.get();
            int cexcept = this.byteContainer.get();
            for (int k = 0; k < 128; k += 32) {
                BitPacking.fastunpack(in, tmpinpos, out, tmpoutpos + k, b);
                tmpinpos += b;
            }
            if (cexcept > 0) {
                byte maxbits = this.byteContainer.get();
                int index = maxbits - b;
                for (int k = 0; k < cexcept; ++k) {
                    byte pos = this.byteContainer.get();
                    int n = index;
                    int n2 = this.dataPointers[n];
                    this.dataPointers[n] = n2 + 1;
                    int exceptvalue = this.dataTobePacked[index][n2];
                    int n3 = pos + tmpoutpos;
                    out[n3] = out[n3] | exceptvalue << b;
                }
            }
            initoffset.set(Delta.fastinverseDelta(out, tmpoutpos, 128, initoffset.intValue()));
            ++run;
            tmpoutpos += 128;
        }
        outpos.set(tmpoutpos);
        inpos.set(inexcept);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

