/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.common.utils.config.TagNameUtils;
import org.apache.pinot.core.data.function.FunctionEvaluator;
import org.apache.pinot.core.data.function.FunctionEvaluatorFactory;
import org.apache.pinot.core.startree.v2.AggregationFunctionColumnPair;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.IngestionConfig;
import org.apache.pinot.spi.config.table.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.spi.config.table.StarTreeIndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.TierConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.config.table.ingestion.FilterConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.utils.TimeUtils;

public final class TableConfigUtils {
    private TableConfigUtils() {
    }

    public static void validate(TableConfig tableConfig, @Nullable Schema schema) {
        if (tableConfig.getTableType() == TableType.REALTIME) {
            Preconditions.checkState((schema != null ? 1 : 0) != 0, (Object)"Schema should not be null for REALTIME table");
        }
        TableConfigUtils.sanitize(tableConfig);
        TableConfigUtils.validateValidationConfig(tableConfig, schema);
        TableConfigUtils.validateIngestionConfig(tableConfig.getIngestionConfig(), schema);
        TableConfigUtils.validateTierConfigList(tableConfig.getTierConfigsList());
        TableConfigUtils.validateIndexingConfig(tableConfig.getIndexingConfig(), schema);
        TableConfigUtils.validateFieldConfigList(tableConfig.getFieldConfigList(), schema);
        TableConfigUtils.validateUpsertConfig(tableConfig, schema);
    }

    public static void validateTableName(TableConfig tableConfig) {
        String tableName = tableConfig.getTableName();
        if (tableName.contains(".") || tableName.contains(" ")) {
            throw new IllegalStateException("Table name: '" + tableName + "' containing '.' or space is not allowed");
        }
    }

    public static void validateRetentionConfig(TableConfig tableConfig) {
        SegmentsValidationAndRetentionConfig segmentsConfig = tableConfig.getValidationConfig();
        String tableName = tableConfig.getTableName();
        if (segmentsConfig == null) {
            throw new IllegalStateException(String.format("Table: %s, \"segmentsConfig\" field is missing in table config", tableName));
        }
        String segmentPushType = segmentsConfig.getSegmentPushType();
        if (!(tableConfig.getTableType() != TableType.OFFLINE || segmentPushType == null || segmentPushType.isEmpty() || segmentPushType.equalsIgnoreCase("REFRESH") || segmentPushType.equalsIgnoreCase("APPEND"))) {
            throw new IllegalStateException(String.format("Table: %s, invalid push type: %s", tableName, segmentPushType));
        }
        String timeUnitString = segmentsConfig.getRetentionTimeUnit();
        if (timeUnitString == null || timeUnitString.isEmpty()) {
            return;
        }
        try {
            TimeUnit.valueOf(timeUnitString.toUpperCase());
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Table: %s, invalid time unit: %s", tableName, timeUnitString));
        }
    }

    private static void validateValidationConfig(TableConfig tableConfig, @Nullable Schema schema) {
        String peerSegmentDownloadScheme;
        SegmentsValidationAndRetentionConfig validationConfig = tableConfig.getValidationConfig();
        String timeColumnName = validationConfig.getTimeColumnName();
        if (tableConfig.getTableType() == TableType.REALTIME) {
            Preconditions.checkState((timeColumnName != null ? 1 : 0) != 0, (Object)"'timeColumnName' cannot be null in REALTIME table config");
        }
        if (timeColumnName != null && !timeColumnName.isEmpty() && schema != null) {
            Preconditions.checkState((schema.getSpecForTimeColumn(timeColumnName) != null ? 1 : 0) != 0, (String)"Cannot find valid fieldSpec for timeColumn: %s from the table config: %s, in the schema: %s", (Object)timeColumnName, (Object)tableConfig.getTableName(), (Object)schema.getSchemaName());
        }
        if ((peerSegmentDownloadScheme = validationConfig.getPeerSegmentDownloadScheme()) != null && !"http".equalsIgnoreCase(peerSegmentDownloadScheme) && !"https".equalsIgnoreCase(peerSegmentDownloadScheme)) {
            throw new IllegalStateException("Invalid value '" + peerSegmentDownloadScheme + "' for peerSegmentDownloadScheme. Must be one of http or https");
        }
        TableConfigUtils.validateRetentionConfig(tableConfig);
    }

    private static void validateIngestionConfig(@Nullable IngestionConfig ingestionConfig, @Nullable Schema schema) {
        if (ingestionConfig != null) {
            List transformConfigs;
            String filterFunction;
            FilterConfig filterConfig = ingestionConfig.getFilterConfig();
            if (filterConfig != null && (filterFunction = filterConfig.getFilterFunction()) != null) {
                try {
                    FunctionEvaluatorFactory.getExpressionEvaluator(filterFunction);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Invalid filter function " + filterFunction, e);
                }
            }
            if ((transformConfigs = ingestionConfig.getTransformConfigs()) != null) {
                HashSet<String> transformColumns = new HashSet<String>();
                HashSet<String> argumentColumns = new HashSet<String>();
                for (TransformConfig transformConfig : transformConfigs) {
                    FunctionEvaluator expressionEvaluator;
                    String columnName = transformConfig.getColumnName();
                    if (schema != null) {
                        Preconditions.checkState((schema.getFieldSpecFor(columnName) != null ? 1 : 0) != 0, (Object)"The destination column of the transform function must be present in the schema");
                    }
                    String transformFunction = transformConfig.getTransformFunction();
                    if (columnName == null || transformFunction == null) {
                        throw new IllegalStateException("columnName/transformFunction cannot be null in TransformConfig " + transformConfig);
                    }
                    if (!transformColumns.add(columnName)) {
                        throw new IllegalStateException("Duplicate transform config found for column '" + columnName + "'");
                    }
                    try {
                        expressionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(transformFunction);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Invalid transform function '" + transformFunction + "' for column '" + columnName + "'");
                    }
                    List<String> arguments = expressionEvaluator.getArguments();
                    if (arguments.contains(columnName)) {
                        throw new IllegalStateException("Arguments of a transform function '" + arguments + "' cannot contain the destination column '" + columnName + "'");
                    }
                    argumentColumns.addAll(arguments);
                }
                if (!Collections.disjoint(transformColumns, argumentColumns)) {
                    throw new IllegalStateException("Derived columns not supported yet. Cannot use a transform column as argument to another transform functions");
                }
            }
        }
    }

    protected static void validateUpsertConfig(TableConfig tableConfig, Schema schema) {
        if (tableConfig.getUpsertMode() == UpsertConfig.Mode.NONE) {
            return;
        }
        Preconditions.checkState((tableConfig.getTableType() == TableType.REALTIME ? 1 : 0) != 0, (Object)"Upsert table is for realtime table only.");
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)schema.getPrimaryKeyColumns()), (Object)"Upsert table must have primary key columns in the schema");
        Preconditions.checkState((tableConfig.getIndexingConfig() != null && tableConfig.getIndexingConfig().getStreamConfigs() != null ? 1 : 0) != 0, (Object)"streamConfig must exist in the table config");
        StreamConfig streamConfig = new StreamConfig(tableConfig.getTableName(), tableConfig.getIndexingConfig().getStreamConfigs());
        Preconditions.checkState((streamConfig.hasLowLevelConsumerType() && !streamConfig.hasHighLevelConsumerType() ? 1 : 0) != 0, (Object)"Upsert table must use low-level streaming consumer type");
        Preconditions.checkState((tableConfig.getRoutingConfig() != null && "strictReplicaGroup".equalsIgnoreCase(tableConfig.getRoutingConfig().getInstanceSelectorType()) ? 1 : 0) != 0, (Object)"Upsert table must use strict replica-group (i.e. strictReplicaGroup) based routing");
        Preconditions.checkState((CollectionUtils.isEmpty((Collection)tableConfig.getIndexingConfig().getStarTreeIndexConfigs()) && !tableConfig.getIndexingConfig().isEnableDefaultStarTree() ? 1 : 0) != 0, (Object)"The upsert table cannot have star-tree index.");
    }

    private static void validateTierConfigList(@Nullable List<TierConfig> tierConfigList) {
        if (tierConfigList == null) {
            return;
        }
        HashSet<String> tierNames = new HashSet<String>();
        for (TierConfig tierConfig : tierConfigList) {
            String tierName = tierConfig.getName();
            Preconditions.checkState((!tierName.isEmpty() ? 1 : 0) != 0, (Object)"Tier name cannot be blank");
            Preconditions.checkState((boolean)tierNames.add(tierName), (String)"Tier name: %s already exists in tier configs", (Object)tierName);
            String segmentSelectorType = tierConfig.getSegmentSelectorType();
            String segmentAge = tierConfig.getSegmentAge();
            if (!segmentSelectorType.equalsIgnoreCase("time")) {
                throw new IllegalStateException("Unsupported segmentSelectorType: " + segmentSelectorType + " in tier: " + tierName);
            }
            Preconditions.checkState((segmentAge != null ? 1 : 0) != 0, (String)"Must provide 'segmentAge' for segmentSelectorType: %s in tier: %s", (Object)segmentSelectorType, (Object)tierName);
            Preconditions.checkState((boolean)TimeUtils.isPeriodValid((String)segmentAge), (String)"segmentAge: %s must be a valid period string (eg. 30d, 24h) in tier: %s", (Object)segmentAge, (Object)tierName);
            String storageType = tierConfig.getStorageType();
            String serverTag = tierConfig.getServerTag();
            if (storageType.equalsIgnoreCase("pinot_server")) {
                Preconditions.checkState((serverTag != null ? 1 : 0) != 0, (String)"Must provide 'serverTag' for storageType: %s in tier: %s", (Object)storageType, (Object)tierName);
                Preconditions.checkState((boolean)TagNameUtils.isServerTag((String)serverTag), (String)"serverTag: %s must have a valid server tag format (<tenantName>_OFFLINE or <tenantName>_REALTIME) in tier: %s", (Object)serverTag, (Object)tierName);
                continue;
            }
            throw new IllegalStateException("Unsupported storageType: " + storageType + " in tier: " + tierName);
        }
    }

    private static void validateIndexingConfig(@Nullable IndexingConfig indexingConfig, @Nullable Schema schema) {
        List starTreeIndexConfigList;
        if (indexingConfig == null || schema == null) {
            return;
        }
        HashMap<String, String> columnNameToConfigMap = new HashMap<String, String>();
        HashSet noDictionaryColumnsSet = new HashSet();
        if (indexingConfig.getNoDictionaryColumns() != null) {
            for (Iterator<Object> columnName : indexingConfig.getNoDictionaryColumns()) {
                columnNameToConfigMap.put((String)((Object)columnName), "No Dictionary Column Config");
                noDictionaryColumnsSet.add(columnName);
            }
        }
        HashSet bloomFilterColumns = new HashSet();
        if (indexingConfig.getBloomFilterColumns() != null) {
            bloomFilterColumns.addAll(indexingConfig.getBloomFilterColumns());
        }
        if (indexingConfig.getBloomFilterConfigs() != null) {
            bloomFilterColumns.addAll(indexingConfig.getBloomFilterConfigs().keySet());
        }
        for (String bloomFilterColumn : bloomFilterColumns) {
            if (noDictionaryColumnsSet.contains(bloomFilterColumn)) {
                throw new IllegalStateException("Cannot create a Bloom Filter on column " + bloomFilterColumn + " specified in the noDictionaryColumns config");
            }
            columnNameToConfigMap.put(bloomFilterColumn, "Bloom Filter Config");
        }
        if (indexingConfig.getInvertedIndexColumns() != null) {
            for (String columnName : indexingConfig.getInvertedIndexColumns()) {
                if (noDictionaryColumnsSet.contains(columnName)) {
                    throw new IllegalStateException("Cannot create an Inverted index on column " + columnName + " specified in the noDictionaryColumns config");
                }
                columnNameToConfigMap.put(columnName, "Inverted Index Config");
            }
        }
        if (indexingConfig.getOnHeapDictionaryColumns() != null) {
            for (String columnName : indexingConfig.getOnHeapDictionaryColumns()) {
                columnNameToConfigMap.put(columnName, "On Heap Dictionary Column Config");
            }
        }
        if (indexingConfig.getRangeIndexColumns() != null) {
            for (String columnName : indexingConfig.getRangeIndexColumns()) {
                columnNameToConfigMap.put(columnName, "Range Column Config");
            }
        }
        if (indexingConfig.getSortedColumn() != null) {
            for (String columnName : indexingConfig.getSortedColumn()) {
                columnNameToConfigMap.put(columnName, "Sorted Column Config");
            }
        }
        if (indexingConfig.getVarLengthDictionaryColumns() != null) {
            for (String columnName : indexingConfig.getVarLengthDictionaryColumns()) {
                columnNameToConfigMap.put(columnName, "Var Length Column Config");
            }
        }
        if (indexingConfig.getSegmentPartitionConfig() != null && indexingConfig.getSegmentPartitionConfig().getColumnPartitionMap() != null) {
            for (String columnName : indexingConfig.getSegmentPartitionConfig().getColumnPartitionMap().keySet()) {
                columnNameToConfigMap.put(columnName, "Segment Partition Config");
            }
        }
        if ((starTreeIndexConfigList = indexingConfig.getStarTreeIndexConfigs()) != null) {
            for (StarTreeIndexConfig starTreeIndexConfig : starTreeIndexConfigList) {
                Object functionColumnPair22;
                for (String columnName : starTreeIndexConfig.getDimensionsSplitOrder()) {
                    columnNameToConfigMap.put(columnName, "StarTreeIndex Config");
                }
                for (Object functionColumnPair22 : starTreeIndexConfig.getFunctionColumnPairs()) {
                    AggregationFunctionColumnPair columnPair;
                    try {
                        columnPair = AggregationFunctionColumnPair.fromColumnName((String)functionColumnPair22);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Invalid StarTreeIndex config: " + (String)functionColumnPair22 + ". Must bein the form <Aggregation function>__<Column name>");
                    }
                    String columnName = columnPair.getColumn();
                    if (columnName.equals("*")) continue;
                    columnNameToConfigMap.put(columnName, "StarTreeIndex Config");
                }
                List skipDimensionList = starTreeIndexConfig.getSkipStarNodeCreationForDimensions();
                if (skipDimensionList == null) continue;
                functionColumnPair22 = skipDimensionList.iterator();
                while (functionColumnPair22.hasNext()) {
                    String columnName = (String)functionColumnPair22.next();
                    columnNameToConfigMap.put(columnName, "StarTreeIndex Config");
                }
            }
        }
        for (Map.Entry entry : columnNameToConfigMap.entrySet()) {
            String columnName = (String)entry.getKey();
            String configName = (String)entry.getValue();
            Preconditions.checkState((schema.getFieldSpecFor(columnName) != null ? 1 : 0) != 0, (Object)("Column Name " + columnName + " defined in " + configName + " must be a valid column defined in the schema"));
        }
    }

    private static void validateFieldConfigList(@Nullable List<FieldConfig> fieldConfigList, @Nullable Schema schema) {
        if (fieldConfigList == null || schema == null) {
            return;
        }
        for (FieldConfig fieldConfig : fieldConfigList) {
            String columnName = fieldConfig.getName();
            Preconditions.checkState((schema.getFieldSpecFor(columnName) != null ? 1 : 0) != 0, (Object)("Column Name " + columnName + " defined in field config list must be a valid column defined in the schema"));
        }
    }

    private static void sanitize(TableConfig tableConfig) {
        tableConfig.setIndexingConfig(TableConfigUtils.sanitizeIndexingConfig(tableConfig.getIndexingConfig()));
    }

    private static IndexingConfig sanitizeIndexingConfig(IndexingConfig indexingConfig) {
        indexingConfig.setInvertedIndexColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getInvertedIndexColumns()));
        indexingConfig.setNoDictionaryColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getNoDictionaryColumns()));
        indexingConfig.setSortedColumn(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getSortedColumn()));
        indexingConfig.setBloomFilterColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getBloomFilterColumns()));
        indexingConfig.setOnHeapDictionaryColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getOnHeapDictionaryColumns()));
        indexingConfig.setRangeIndexColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getRangeIndexColumns()));
        indexingConfig.setVarLengthDictionaryColumns(TableConfigUtils.sanitizeListBasedIndexingColumns(indexingConfig.getVarLengthDictionaryColumns()));
        return indexingConfig;
    }

    private static List<String> sanitizeListBasedIndexingColumns(List<String> indexingColumns) {
        if (indexingColumns != null) {
            return indexingColumns.stream().filter(v -> !v.isEmpty()).collect(Collectors.toList());
        }
        return null;
    }
}

