/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.stream.StreamConfig;

public class ReplicationUtils {
    public static boolean useReplication(TableConfig tableConfig) {
        TableType tableType = tableConfig.getTableType();
        if (tableType.equals((Object)TableType.REALTIME)) {
            StreamConfig streamConfig = new StreamConfig(tableConfig.getTableName(), tableConfig.getIndexingConfig().getStreamConfigs());
            return streamConfig.hasHighLevelConsumerType();
        }
        return true;
    }

    public static boolean useReplicasPerPartition(TableConfig tableConfig) {
        TableType tableType = tableConfig.getTableType();
        if (tableType.equals((Object)TableType.REALTIME)) {
            StreamConfig streamConfig = new StreamConfig(tableConfig.getTableName(), tableConfig.getIndexingConfig().getStreamConfigs());
            return streamConfig.hasLowLevelConsumerType();
        }
        return false;
    }
}

