/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.pinot.common.utils.Pairs;
import org.apache.pinot.core.util.BaseIndexedPriorityQueue;

@NotThreadSafe
public class IntDoubleIndexedPriorityQueue
extends BaseIndexedPriorityQueue {
    DoubleArrayList _values;
    Pairs.IntDoublePair _reusablePair;

    public IntDoubleIndexedPriorityQueue(int initialCapacity, boolean minHeap) {
        super(initialCapacity, minHeap);
        this._values = new DoubleArrayList(initialCapacity);
        this._reusablePair = new Pairs.IntDoublePair(0, 0.0);
    }

    public void put(int key, double value) {
        if (!this._keyToIndexMap.containsKey(key)) {
            this._values.add(value);
            int last = this._values.size() - 1;
            this.updateKeyIndexMap(key, last);
            this.siftUp(last);
        } else {
            int index = this._keyToIndexMap.get(key);
            this._values.set(index, value);
            if (!this.siftDown(index)) {
                this.siftUp(index);
            }
        }
    }

    public Pairs.IntDoublePair get(int key) {
        if (!this._keyToIndexMap.containsKey(key)) {
            return null;
        }
        int index = this._keyToIndexMap.get(key);
        double value = this._values.getDouble(index);
        this._reusablePair.setIntValue(index);
        this._reusablePair.setDoubleValue(value);
        return this._reusablePair;
    }

    public Pairs.IntDoublePair poll() {
        if (this.isEmpty()) {
            return null;
        }
        Pairs.IntDoublePair poll = this.peek();
        int lastIndex = this._values.size() - 1;
        this.swapValues(0, lastIndex);
        this._values.removeDouble(lastIndex);
        this._keyToIndexMap.remove(this._indexToKeyMap.get(lastIndex));
        this._indexToKeyMap.remove(lastIndex);
        if (!this._values.isEmpty()) {
            this.siftDown(0);
        }
        return poll;
    }

    public Pairs.IntDoublePair peek() {
        if (this._values.isEmpty()) {
            throw new RuntimeException("Empty collection");
        }
        this._reusablePair.setIntValue(this._indexToKeyMap.get(0));
        this._reusablePair.setDoubleValue(this._values.getDouble(0));
        return this._reusablePair;
    }

    public boolean isEmpty() {
        return this._values.isEmpty();
    }

    private void siftUp(int index) {
        if (index == 0) {
            return;
        }
        while (index != 0) {
            int parentIndex = this.getParentIndex(index);
            double value = this._values.getDouble(index);
            double parentValue = this._values.getDouble(parentIndex);
            if (this.compare(parentValue, value) != 1) break;
            this.swapValues(index, parentIndex);
            index = parentIndex;
        }
    }

    private boolean siftDown(int index) {
        boolean hasChildren = this.hasChildren(index);
        if (!hasChildren) {
            return false;
        }
        boolean sifted = false;
        while (true) {
            double rightChildValue;
            double leftChildValue;
            int leftChildIndex = this.getLeftChildIndex(index);
            int rightChildIndex = this.getRightChildIndex(index);
            int size = this._values.size();
            if (leftChildIndex >= size && rightChildIndex >= size) break;
            int minIndex = rightChildIndex >= size ? leftChildIndex : (this.compare(leftChildValue = this._values.getDouble(leftChildIndex), rightChildValue = this._values.getDouble(rightChildIndex)) <= 0 ? leftChildIndex : rightChildIndex);
            if (this.compare(this._values.getDouble(index), this._values.getDouble(minIndex)) != 1) break;
            this.swapValues(index, minIndex);
            index = minIndex;
            sifted = true;
        }
        return sifted;
    }

    private int compare(double v1, double v2) {
        int ret = Double.compare(v1, v2);
        return this._minHeap ? ret : -ret;
    }

    private void swapValues(int index1, int index2) {
        if (index1 == index2) {
            return;
        }
        double tmp = this._values.getDouble(index1);
        this._values.set(index1, this._values.getDouble(index2));
        this._values.set(index2, tmp);
        this.swapKeys(index1, index2);
    }

    private boolean hasChildren(int index) {
        return this.getLeftChildIndex(index) < this._values.size();
    }
}

