/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.core.data.function.FunctionEvaluator;
import org.apache.pinot.core.data.function.FunctionEvaluatorFactory;
import org.apache.pinot.spi.config.table.IngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.FilterConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class IngestionUtils {
    public static Set<String> getFieldsForRecordExtractor(@Nullable IngestionConfig ingestionConfig, Schema schema) {
        HashSet<String> fieldsForRecordExtractor = new HashSet<String>();
        IngestionUtils.extractFieldsFromIngestionConfig(ingestionConfig, fieldsForRecordExtractor);
        IngestionUtils.extractFieldsFromSchema(schema, fieldsForRecordExtractor);
        return fieldsForRecordExtractor;
    }

    private static void extractFieldsFromSchema(Schema schema, Set<String> fields) {
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn()) continue;
            FunctionEvaluator functionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(fieldSpec);
            if (functionEvaluator != null) {
                fields.addAll(functionEvaluator.getArguments());
            }
            fields.add(fieldSpec.getName());
        }
    }

    private static void extractFieldsFromIngestionConfig(@Nullable IngestionConfig ingestionConfig, Set<String> fields) {
        if (ingestionConfig != null) {
            List transformConfigs;
            FunctionEvaluator functionEvaluator;
            String filterFunction;
            FilterConfig filterConfig = ingestionConfig.getFilterConfig();
            if (filterConfig != null && (filterFunction = filterConfig.getFilterFunction()) != null && (functionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(filterFunction)) != null) {
                fields.addAll(functionEvaluator.getArguments());
            }
            if ((transformConfigs = ingestionConfig.getTransformConfigs()) != null) {
                for (TransformConfig transformConfig : transformConfigs) {
                    FunctionEvaluator expressionEvaluator = FunctionEvaluatorFactory.getExpressionEvaluator(transformConfig.getTransformFunction());
                    fields.addAll(expressionEvaluator.getArguments());
                    fields.add(transformConfig.getColumnName());
                }
            }
        }
    }

    public static boolean shouldIngestRow(GenericRow genericRow) {
        return !Boolean.TRUE.equals(genericRow.getValue("$SKIP_RECORD_KEY$"));
    }

    public static Long extractTimeValue(Comparable time) {
        if (time != null) {
            if (time instanceof Number) {
                return ((Number)((Object)time)).longValue();
            }
            String stringValue = time.toString();
            if (StringUtils.isNumeric((CharSequence)stringValue)) {
                return Long.parseLong(stringValue);
            }
        }
        return null;
    }
}

