/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.upsert;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.core.upsert.PartitionUpsertMetadataManager;

@ThreadSafe
public class TableUpsertMetadataManager {
    private final Map<Integer, PartitionUpsertMetadataManager> _partitionMetadataManagerMap = new ConcurrentHashMap<Integer, PartitionUpsertMetadataManager>();
    private final String _tableNameWithType;
    private final ServerMetrics _serverMetrics;

    public TableUpsertMetadataManager(String tableNameWithType, ServerMetrics serverMetrics) {
        this._tableNameWithType = tableNameWithType;
        this._serverMetrics = serverMetrics;
    }

    public PartitionUpsertMetadataManager getOrCreatePartitionManager(int partitionId) {
        return this._partitionMetadataManagerMap.computeIfAbsent(partitionId, k -> new PartitionUpsertMetadataManager(this._tableNameWithType, (int)k, this._serverMetrics));
    }
}

