/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.upsert;

import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ServerGauge;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.core.realtime.impl.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.core.upsert.RecordLocation;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PartitionUpsertMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionUpsertMetadataManager.class);
    private final String _tableNameWithType;
    private final int _partitionId;
    private final ServerMetrics _serverMetrics;
    @VisibleForTesting
    final ConcurrentHashMap<PrimaryKey, RecordLocation> _primaryKeyToRecordLocationMap = new ConcurrentHashMap();

    public PartitionUpsertMetadataManager(String tableNameWithType, int partitionId, ServerMetrics serverMetrics) {
        this._tableNameWithType = tableNameWithType;
        this._partitionId = partitionId;
        this._serverMetrics = serverMetrics;
    }

    public ThreadSafeMutableRoaringBitmap addSegment(String segmentName, Iterator<RecordInfo> recordInfoIterator) {
        LOGGER.info("Adding upsert metadata for segment: {}", (Object)segmentName);
        ThreadSafeMutableRoaringBitmap validDocIds = new ThreadSafeMutableRoaringBitmap();
        while (recordInfoIterator.hasNext()) {
            RecordInfo recordInfo = recordInfoIterator.next();
            this._primaryKeyToRecordLocationMap.compute(recordInfo._primaryKey, (primaryKey, currentRecordLocation) -> {
                if (currentRecordLocation != null) {
                    if (segmentName.equals(currentRecordLocation.getSegmentName())) {
                        if (recordInfo._timestamp >= currentRecordLocation.getTimestamp()) {
                            if (validDocIds == currentRecordLocation.getValidDocIds()) {
                                validDocIds.remove(currentRecordLocation.getDocId());
                            }
                            validDocIds.add(recordInfo._docId);
                            return new RecordLocation(segmentName, recordInfo._docId, recordInfo._timestamp, validDocIds);
                        }
                        return currentRecordLocation;
                    }
                    if (recordInfo._timestamp > currentRecordLocation.getTimestamp() || recordInfo._timestamp == currentRecordLocation.getTimestamp() && LLCSegmentName.getSequenceNumber((String)segmentName) > LLCSegmentName.getSequenceNumber((String)currentRecordLocation.getSegmentName())) {
                        currentRecordLocation.getValidDocIds().remove(currentRecordLocation.getDocId());
                        validDocIds.add(recordInfo._docId);
                        return new RecordLocation(segmentName, recordInfo._docId, recordInfo._timestamp, validDocIds);
                    }
                    return currentRecordLocation;
                }
                validDocIds.add(recordInfo._docId);
                return new RecordLocation(segmentName, recordInfo._docId, recordInfo._timestamp, validDocIds);
            });
        }
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
        return validDocIds;
    }

    public void updateRecord(String segmentName, RecordInfo recordInfo, ThreadSafeMutableRoaringBitmap validDocIds) {
        this._primaryKeyToRecordLocationMap.compute(recordInfo._primaryKey, (primaryKey, currentRecordLocation) -> {
            if (currentRecordLocation != null) {
                if (recordInfo._timestamp >= currentRecordLocation.getTimestamp()) {
                    currentRecordLocation.getValidDocIds().remove(currentRecordLocation.getDocId());
                    validDocIds.add(recordInfo._docId);
                    return new RecordLocation(segmentName, recordInfo._docId, recordInfo._timestamp, validDocIds);
                }
                return currentRecordLocation;
            }
            validDocIds.add(recordInfo._docId);
            return new RecordLocation(segmentName, recordInfo._docId, recordInfo._timestamp, validDocIds);
        });
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
    }

    public void removeSegment(String segmentName, ThreadSafeMutableRoaringBitmap validDocIds) {
        LOGGER.info("Removing upsert metadata for segment: {}", (Object)segmentName);
        if (!validDocIds.getMutableRoaringBitmap().isEmpty()) {
            this._primaryKeyToRecordLocationMap.forEach((primaryKey, recordLocation) -> {
                if (recordLocation.getValidDocIds() == validDocIds) {
                    this._primaryKeyToRecordLocationMap.remove(primaryKey, recordLocation);
                }
            });
        }
        this._serverMetrics.setValueOfPartitionGauge(this._tableNameWithType, this._partitionId, (AbstractMetrics.Gauge)ServerGauge.UPSERT_PRIMARY_KEYS_COUNT, (long)this._primaryKeyToRecordLocationMap.size());
    }

    public static final class RecordInfo {
        private final PrimaryKey _primaryKey;
        private final int _docId;
        private final long _timestamp;

        public RecordInfo(PrimaryKey primaryKey, int docId, long timestamp) {
            this._primaryKey = primaryKey;
            this._docId = docId;
            this._timestamp = timestamp;
        }
    }
}

