/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import com.google.common.annotations.VisibleForTesting;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.config.table.TableType;

public class ServerInstance {
    private static final int SERVER_INSTANCE_PREFIX_LENGTH = "Server_".length();
    private static final String HOSTNAME_PORT_DELIMITER = "_";
    private final String _hostname;
    private final int _port;

    public ServerInstance(InstanceConfig instanceConfig) {
        String hostname = instanceConfig.getHostName();
        if (hostname != null) {
            this._hostname = hostname.startsWith("Server_") ? hostname.substring(SERVER_INSTANCE_PREFIX_LENGTH) : hostname;
            this._port = Integer.parseInt(instanceConfig.getPort());
        } else {
            String instanceName = instanceConfig.getInstanceName();
            String[] hostnameAndPort = instanceName.split("Server_")[1].split(HOSTNAME_PORT_DELIMITER);
            this._hostname = hostnameAndPort[0];
            this._port = Integer.parseInt(hostnameAndPort[1]);
        }
    }

    @VisibleForTesting
    ServerInstance(String hostname, int port) {
        this._hostname = hostname;
        this._port = port;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public ServerRoutingInstance toServerRoutingInstance(TableType tableType) {
        return new ServerRoutingInstance(this._hostname, this._port, tableType);
    }

    public int hashCode() {
        return 31 * this._hostname.hashCode() + this._port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ServerInstance) {
            ServerInstance that = (ServerInstance)obj;
            return this._hostname.equals(that._hostname) && this._port == that._port;
        }
        return false;
    }

    public String toString() {
        return "Server_" + this._hostname + HOSTNAME_PORT_DELIMITER + this._port;
    }
}

