/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerGauge;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.core.transport.DataTableHandler;
import org.apache.pinot.core.transport.QueryRouter;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.thrift.TBase;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

@ThreadSafe
public class ServerChannels {
    private final QueryRouter _queryRouter;
    private final BrokerMetrics _brokerMetrics;
    private final ConcurrentHashMap<ServerRoutingInstance, ServerChannel> _serverToChannelMap = new ConcurrentHashMap();
    private final EventLoopGroup _eventLoopGroup = new NioEventLoopGroup();

    public ServerChannels(QueryRouter queryRouter, BrokerMetrics brokerMetrics) {
        this._queryRouter = queryRouter;
        this._brokerMetrics = brokerMetrics;
    }

    public void sendRequest(ServerRoutingInstance serverRoutingInstance, InstanceRequest instanceRequest) throws Exception {
        this._serverToChannelMap.computeIfAbsent(serverRoutingInstance, x$0 -> new ServerChannel((ServerRoutingInstance)x$0)).sendRequest(instanceRequest);
    }

    public void shutDown() {
        this._eventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
    }

    @ThreadSafe
    private class ServerChannel {
        final TSerializer _serializer = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory());
        final ServerRoutingInstance _serverRoutingInstance;
        final Bootstrap _bootstrap;
        Channel _channel;

        ServerChannel(ServerRoutingInstance serverRoutingInstance) {
            this._serverRoutingInstance = serverRoutingInstance;
            this._bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().remoteAddress(serverRoutingInstance.getHostname(), serverRoutingInstance.getPort()).group(ServerChannels.this._eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4), new LengthFieldPrepender(4), new DataTableHandler(ServerChannels.this._queryRouter, ServerChannel.this._serverRoutingInstance, ServerChannels.this._brokerMetrics)});
                }
            });
        }

        synchronized void sendRequest(InstanceRequest instanceRequest) throws Exception {
            if (this._channel == null || !this._channel.isActive()) {
                long startTime = System.currentTimeMillis();
                this._channel = this._bootstrap.connect().sync().channel();
                ServerChannels.this._brokerMetrics.setValueOfGlobalGauge((AbstractMetrics.Gauge)BrokerGauge.NETTY_CONNECTION_CONNECT_TIME_MS, System.currentTimeMillis() - startTime);
            }
            byte[] requestBytes = this._serializer.serialize((TBase)instanceRequest);
            this._channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])requestBytes), this._channel.voidPromise());
            ServerChannels.this._brokerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.NETTY_CONNECTION_REQUESTS_SENT, 1L);
            ServerChannels.this._brokerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)BrokerMeter.NETTY_CONNECTION_BYTES_SENT, (long)requestBytes.length);
        }
    }
}

