/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.common.utils.DataTable;
import org.apache.pinot.core.transport.AsyncQueryResponse;
import org.apache.pinot.core.transport.ServerChannels;
import org.apache.pinot.core.transport.ServerInstance;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.config.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class QueryRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRouter.class);
    private final String _brokerId;
    private final BrokerMetrics _brokerMetrics;
    private final ServerChannels _serverChannels;
    private final ConcurrentHashMap<Long, AsyncQueryResponse> _asyncQueryResponseMap = new ConcurrentHashMap();

    public QueryRouter(String brokerId, BrokerMetrics brokerMetrics) {
        this._brokerId = brokerId;
        this._brokerMetrics = brokerMetrics;
        this._serverChannels = new ServerChannels(this, brokerMetrics);
    }

    public AsyncQueryResponse submitQuery(long requestId, String rawTableName, @Nullable BrokerRequest offlineBrokerRequest, @Nullable Map<ServerInstance, List<String>> offlineRoutingTable, @Nullable BrokerRequest realtimeBrokerRequest, @Nullable Map<ServerInstance, List<String>> realtimeRoutingTable, long timeoutMs) {
        InstanceRequest instanceRequest;
        ServerRoutingInstance serverRoutingInstance;
        assert (offlineBrokerRequest != null || realtimeBrokerRequest != null);
        HashMap<ServerRoutingInstance, InstanceRequest> requestMap = new HashMap<ServerRoutingInstance, InstanceRequest>();
        if (offlineBrokerRequest != null) {
            assert (offlineRoutingTable != null);
            for (Map.Entry<ServerInstance, List<String>> entry : offlineRoutingTable.entrySet()) {
                serverRoutingInstance = entry.getKey().toServerRoutingInstance(TableType.OFFLINE);
                instanceRequest = this.getInstanceRequest(requestId, offlineBrokerRequest, entry.getValue());
                requestMap.put(serverRoutingInstance, instanceRequest);
            }
        }
        if (realtimeBrokerRequest != null) {
            assert (realtimeRoutingTable != null);
            for (Map.Entry<ServerInstance, List<String>> entry : realtimeRoutingTable.entrySet()) {
                serverRoutingInstance = entry.getKey().toServerRoutingInstance(TableType.REALTIME);
                instanceRequest = this.getInstanceRequest(requestId, realtimeBrokerRequest, entry.getValue());
                requestMap.put(serverRoutingInstance, instanceRequest);
            }
        }
        AsyncQueryResponse asyncQueryResponse = new AsyncQueryResponse(this, requestId, requestMap.keySet(), System.currentTimeMillis(), timeoutMs);
        this._asyncQueryResponseMap.put(requestId, asyncQueryResponse);
        for (Map.Entry entry : requestMap.entrySet()) {
            ServerRoutingInstance serverRoutingInstance2 = (ServerRoutingInstance)entry.getKey();
            try {
                this._serverChannels.sendRequest(serverRoutingInstance2, (InstanceRequest)entry.getValue());
                asyncQueryResponse.markRequestSubmitted(serverRoutingInstance2);
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while sending request {} to server: {}, marking query failed", new Object[]{requestId, serverRoutingInstance2, e});
                this._brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.REQUEST_SEND_EXCEPTIONS, 1L);
                asyncQueryResponse.setBrokerRequestSendException(e);
                asyncQueryResponse.markQueryFailed();
                break;
            }
        }
        return asyncQueryResponse;
    }

    public void shutDown() {
        this._serverChannels.shutDown();
    }

    void receiveDataTable(ServerRoutingInstance serverRoutingInstance, DataTable dataTable, int responseSize, int deserializationTimeMs) {
        long requestId = Long.parseLong((String)dataTable.getMetadata().get("requestId"));
        AsyncQueryResponse asyncQueryResponse = this._asyncQueryResponseMap.get(requestId);
        if (asyncQueryResponse != null) {
            asyncQueryResponse.receiveDataTable(serverRoutingInstance, dataTable, responseSize, deserializationTimeMs);
        }
    }

    void markServerDown(ServerRoutingInstance serverRoutingInstance) {
        for (AsyncQueryResponse asyncQueryResponse : this._asyncQueryResponseMap.values()) {
            asyncQueryResponse.markServerDown(serverRoutingInstance);
        }
    }

    void markQueryDone(long requestId) {
        this._asyncQueryResponseMap.remove(requestId);
    }

    private InstanceRequest getInstanceRequest(long requestId, BrokerRequest brokerRequest, List<String> segments) {
        InstanceRequest instanceRequest = new InstanceRequest();
        instanceRequest.setRequestId(requestId);
        instanceRequest.setQuery(brokerRequest);
        instanceRequest.setEnableTrace(brokerRequest.isEnableTrace());
        instanceRequest.setSearchSegments(segments);
        instanceRequest.setBrokerId(this._brokerId);
        return instanceRequest;
    }
}

